MODULE SETDATE;       (* GEOFF CUTTER - 1992.12.26 Saturday,
Saturday, 93.05.15,  94.01.11 94.05.14 94-08-28 

(* Algorithm from
PRACTICAL ASTRONOMY WITH YOUR CALCULATOR - Peter Duffett-Smith *)

     1.B done

        What date is it some days different from now? AD1=
        Protect DOC file
        Documentation neater
        FILE_ID.DIZ file made
        REM for date check instead of HALT

     1.C done

        TODAY century needs 0 on front for 2000
        Optional parameter which replaces the file data
        include notes on version change: not just DOC corrupted but
           the DOC version has to correspond with the program version
        NS      Number of seconds past so far today

     1.D thoughts

        history file reqd
        change all CARDINAL to LONGCARD
        remove array entry automatically without specifying  CL :=
        DTM     Days this month
        PY0, PY1-PY9 - Periods during the year - Days
        DFD yymmdd    Days from a date *)

FROM Command  IMPORT Parameter,Parclass,GetParams;
FROM GetFiles IMPORT GetNames,FileName;
FROM GetDate  IMPORT GetDateTime, TimeRec;
FROM SmallIO  IMPORT WriteCard, WriteInt;
FROM Terminal IMPORT Read, Write, ReadString, WriteString, WriteLn; 
FROM Strings  IMPORT Pos;
FROM Streams  IMPORT Connect, STREAM, Disconnect, ReadChar,
        Direction, WriteChar; 

TYPE
   CHARSET=SET OF CHAR;
CONST
   DOCLen  = 9999;
   JMax = 1500;
   YearAtLeast = 1994;
   NumberSet   = CHARSET{"0".."9"};

VAR
   Names: ARRAY [0..120] OF FileName;
   Param:ARRAY [0..10] OF Parameter;
   Count, Indexp, NameCount : INTEGER;
   NumbSinceJan1, DayNumberToday, DayNumberYEARSTART, DayNumberYEAREnd,
      NumbToGo, NSec : LONGCARD;
   ADSt   : ARRAY [0..2] OF CHAR;
   PerdSt : ARRAY [0..1] OF CHAR;
   ICh, ContinueChar : CHAR;
   AllDOC : ARRAY [0..DOCLen] OF CHAR;
   CharMatrix : ARRAY [0..JMax] OF CHAR;
   S1, S2, S3, S4, S5, Ver, MyName, ProgramName, InputFile
         : ARRAY [0..11] OF CHAR; 
   TR: TimeRec;
   MinSoFarToday, Num1, Num2, TempNumber, ClearFromHere, Ind, DOC1, DOC2,
    CL, NMin, DayOfWeek : CARDINAL;
   InStream : STREAM;
   J, reply : INTEGER;
   NegDate: BOOLEAN;
   ADD, ADM, ADY: CARDINAL;

PROCEDURE Usage;
(* To write the day when given the enumeration number *)
BEGIN
   GetDateTime(TR);
   WriteLn;
   WriteString(ProgramName);
   WriteString(" by ");
   WriteString(MyName);
   WriteString(", ");
   WriteString(Ver);
   WriteLn;
   WriteLn;
   WriteString(S1); WriteString(S2);
   WriteLn;
   WriteString(S3);
   WriteLn;
   WriteString(S5);
   Write(" ");
   WriteString(S4);
   WriteLn;
   WriteLn;
   WriteString("Hit a key . . . ");
   Read(ContinueChar); 
   WriteLn;
   HALT;
   END Usage;

PROCEDURE RmoveVr;
(* remove variable from array so as not to be found by a later
   search while looking for something else *)
BEGIN
   FOR Ind := ClearFromHere TO ClearFromHere + CL DO 
      CharMatrix[Ind] := " "; END;
   END RmoveVr;

PROCEDURE WrSET;
BEGIN
   WriteString("SET ") END WrSET;

PROCEDURE Perd;
BEGIN
   ClearFromHere := Pos(PerdSt,(CharMatrix),0);
   CL := 2;   RmoveVr;
   (* read the next 2 numbers and see if the time now is in the range *)

   Ind := ClearFromHere;         (* find start of first number *)
   WHILE (NOT (CharMatrix[Ind] IN NumberSet)) DO
      INC(Ind); 
      END;

   TempNumber := 0;
   WHILE (CharMatrix[Ind] IN NumberSet) DO
      TempNumber := TempNumber * 10;
      TempNumber := TempNumber + ORD(CharMatrix[Ind])-48;
      CharMatrix[Ind] := " ";
      INC(Ind); 
      END;
   Num1 := TempNumber;

   WHILE (NOT (CharMatrix[Ind] IN NumberSet)) DO (* find start of 2nd number *)
      INC(Ind); 
      END;

   TempNumber := 0;
   WHILE (CharMatrix[Ind] IN NumberSet) DO
      TempNumber := TempNumber * 10;
      TempNumber := TempNumber + ORD(CharMatrix[Ind])-48;
      CharMatrix[Ind] := " ";
      INC(Ind); 
      END;
   Num2 := TempNumber;

IF (Num1 <= 24) AND (Num2 <= 24) THEN; (* assume its entered as hours *)
   Num1 := Num1 * 60;
   Num2 := Num2 * 60;
   END;
IF Num1 = Num2 THEN;WriteString("Make period numbers differ");Usage;END;
MinSoFarToday := TR.Minute+(TR.Hour*60);

WrSET; WriteString(PerdSt);
IF Num2 > Num1 THEN; (* usual case *)
   IF (MinSoFarToday >= Num1) AND (MinSoFarToday <= Num2) THEN;
      WriteString("=Y");
   ELSE
      WriteString("=N");
      END;
ELSE;                (* Over midnight *)
   IF (MinSoFarToday < Num2) OR (MinSoFarToday >= Num1) THEN;
      WriteString("=Y");
   ELSE
      WriteString("=N");
      END;
   END;
WriteLn;
(*
WriteCard(Num1,8); WriteCard(Num2,8); WriteCard(MinSoFarToday,9); WriteLn;*)
   END Perd;

PROCEDURE GetNumberOfDay(y, m, d:CARDINAL):LONGCARD;
VAR
   YY,MM,DD,A,Bpos,Bneg,C,D:LONGCARD;
BEGIN
   YY:=y;
   MM:=m;
   DD:=d;
   IF (MM=1) OR (MM=2) THEN YY := YY-1; MM := MM+12 END;
   IF (y<1582) OR
      (y=1582) AND (m<10) OR
      (y=1582) AND (m=10) AND (d<=15) THEN Bpos:=0;Bneg:=0
   ELSE
      A := YY DIV 100;
      Bpos := 2+A DIV 4;
      Bneg := A;
      END;
   C := (36525*YY) DIV 100;       (* C behaves as CARDINAL if y is used *)
   D := (306001*(MM+1)) DIV 10000;
   RETURN Bpos+C+D+DD-Bneg+1720994;
   END GetNumberOfDay;

PROCEDURE OutPartTime(Time : CARDINAL);
BEGIN
   IF (Time < 10) THEN
      Write("0");
      END;
   WriteCard(Time,1);
   WriteLn;
   END OutPartTime;

PROCEDURE 
   IsItPlus(VAR Y, M, D : CARDINAL; VAR DN : LONGCARD; VAR TestResult : CHAR);
VAR DayNumberFound : LONGCARD;
BEGIN
   DayNumberFound := GetNumberOfDay(Y, M, D);
   IF DayNumberFound > DN THEN 
      TestResult := "+";
   ELSIF DayNumberFound = DN THEN
      TestResult := "=";
   ELSE (* DayNumberFound = DN *)
      TestResult := "-";
      END;
   END IsItPlus;

PROCEDURE AnotherDate(VAR ADY, ADM, ADD : CARDINAL);
   VAR DNF, DayNumReqd, MovingGuess: LONGCARD;
BEGIN
   ClearFromHere := Pos(ADSt,(CharMatrix),0);
   CL := 3;   RmoveVr;

   (* read the following number *)

   Ind := ClearFromHere;   (* find start of number *)
   WHILE (NOT (CharMatrix[Ind] IN NumberSet)) DO INC(Ind) END;

   NegDate := FALSE;
   IF CharMatrix[Ind - 1] = "-" THEN NegDate := TRUE END;

   TempNumber := 0;
   WHILE (CharMatrix[Ind] IN NumberSet) DO
      TempNumber := TempNumber * 10;
      TempNumber := TempNumber + ORD(CharMatrix[Ind]) - 48;
      CharMatrix[Ind] := " "; INC(Ind); END;

   (* Now we have the number of days *)
   (*  days now - days found = date required - output YY, MM, DD *)
   DayNumberToday := GetNumberOfDay(TR.Year, TR.Month, TR.Day);

IF NegDate THEN
   DayNumReqd := DayNumberToday - TempNumber
ELSE
   DayNumReqd := DayNumberToday + TempNumber
   END;
(* Convert to date and write out *)
(* Hypothesise a date and test - start with today *)
(*WriteCard(DayNumReqd,8);WriteCard(DayNumberToday,8);WriteCard(TempNumber,8);
WriteLn;*)

ADD := 1;
ADM := 1;
ADY := TR.Year;

MovingGuess := GetNumberOfDay(ADY, ADM, ADD);

IF DayNumReqd <> MovingGuess THEN
   IF DayNumReqd < MovingGuess THEN
      IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
      WHILE ICh<>"-" DO
         DEC(ADY);
         IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);END;
   ELSE
      IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
      WHILE ICh<>"+" DO
         INC(ADY);
(*       WriteCard(ADD,10); WriteCard(ADM,6); WriteCard(ADY,6);WriteLn; *)
         IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);END;
      DEC(ADY);
      END;
END;
MovingGuess := GetNumberOfDay(ADY, ADM, ADD);

IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
WHILE ICh = "-" DO
   INC(ADM)
   IF ADM = 13 THEN
      ADM := 1;
      INC(ADY);
      END;
   IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
   END;

IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
IF ICh = "+" THEN DEC(ADM);END;
IF ADM = 0 THEN ADM := 12; DEC(ADY);END;

IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
WHILE ICh<>"=" DO
   INC(ADD);
   IsItPlus(ADY, ADM, ADD, DayNumReqd, ICh);
   IF ADD >= 32 THEN WriteString("Error getting a date "); WriteLn;Usage;END;
   END;

WrSET;
WriteString(ADSt);WriteString("Y=");
OutPartTime(ADY MOD 100);

WrSET;
WriteString(ADSt);WriteString("M=");
OutPartTime(ADM);

WrSET;
WriteString(ADSt);WriteString("D=");
OutPartTime(ADD);

   END AnotherDate;

PROCEDURE WriteDay(DayNumber:CARDINAL);
(* To write the day when given the enumeration number *)
BEGIN
CASE DayNumber OF
   0: WriteString("Su") |
   1: WriteString("Mo") |
   2: WriteString("Tu") |
   3: WriteString("We") |
   4: WriteString("Th") |
   5: WriteString("Fr") |
   6: WriteString("Sa")
   END
   END WriteDay;

PROCEDURE Write3Day(DayNumber:CARDINAL);
(* To write the day when given the enumeration number *)
BEGIN
CASE DayNumber OF
   0: WriteString("Sun") |
   1: WriteString("Mon") |
   2: WriteString("Tue") |
   3: WriteString("Wed") |
   4: WriteString("Thu") |
   5: WriteString("Fri") |
   6: WriteString("Sat")
   END
   END Write3Day;

PROCEDURE WriteLongDay(DayNumber:CARDINAL);
(* To write the day when given the enumeration number *)
BEGIN
CASE DayNumber OF
   0: WriteString("Sunday") |
   1: WriteString("Monday") |
   2: WriteString("Tuesday") |
   3: WriteString("Wednesday") |
   4: WriteString("Thursday") |
   5: WriteString("Friday") |
   6: WriteString("Saturday")
   END
   END WriteLongDay;

PROCEDURE Write1Day(DayNumber:CARDINAL);
(* To write a letter when given the enumeration number *)
BEGIN
CASE DayNumber OF
   0: Write("u") |
   1: Write("m") |
   2: Write("t") |
   3: Write("w") |
   4: Write("h") |
   5: Write("f") |
   6: Write("s")
   END
   END Write1Day;

PROCEDURE Write12(MthNumber:CARDINAL);
(* To write a letter when given the month number *)
BEGIN
CASE MthNumber OF
   1: Write("j") |
   2: Write("f") |
   3: Write("m") |
   4: Write("a") |
   5: Write("y") |
   6: Write("u") |
   7: Write("l") |
   8: Write("g") |
   9: Write("s") |
  10: Write("o") |
  11: Write("n") |
  12: Write("d")
   END
   END Write12;

PROCEDURE CheckName(VAR LocalName : ARRAY OF CHAR; From, To :CARDINAL;
                    CheckSum : LONGCARD);
   VAR
      ContinueChar : CHAR;
      TotalFromArray : LONGCARD
      Number : CARDINAL;
BEGIN
   TotalFromArray := 0;
   FOR  Number := From TO To DO
      TotalFromArray := TotalFromArray + LONG(ORD(LocalName[Number]) * 2) + 3;
      END;

   IF CheckSum <> TotalFromArray THEN
      WriteLn;
      IF To - From < 100 THEN
         WriteString(ProgramName);
      ELSE
         WriteString(InputFile);
         END;
      WriteString(" corrupted. Hit a key");
      WriteLn;
      Read(ContinueChar);
      WriteLn;
      IF ContinueChar="L" THEN
         FOR Number := From TO To DO Write(LocalName[Number]) END;
         WriteLn; WriteCard(To, 6); WriteCard(From, 6);
         WriteCard(TotalFromArray, 8);
         END;
      Usage;
   ELSE
      RETURN
      END;
   END CheckName;

(* =================================================================== *)
BEGIN
   GetDateTime(TR);
   IF TR.Year < YearAtLeast THEN
      WriteLn; WriteLn; WriteString("REM It's at least "); 
      WriteCard(YearAtLeast,1); WriteString(", not "); 
      WriteCard(TR.Year,1); WriteLn; END;

   InputFile   := "SETDATE.DOC";    CheckName(InputFile,   0, 10, 1597);
   ProgramName := "SETDATE.COM";    CheckName(ProgramName, 0, 10, 1615);
   MyName      := "Geoff Cutter";   CheckName(MyName,      0, 11, 2336);
   Ver         := "Version 1.C";    CheckName(Ver,         0, 10, 1905);
   S1          := "203 Como Pde";   CheckName(S1,          0, 11, 1820);
   S2          := " East       ";   CheckName(S2,          0, 11, 1342);
   S3          := "Parkdale";       CheckName(S3,          0,  7, 1632);
   S4          := " 3195";          CheckName(S4,          0,  4,  499);
   S5          := "Australia   ";   CheckName(S5,          0, 11, 2096);

(*
WriteString(S1);WriteLn;
WriteString(S2);WriteLn;
WriteString(S3);WriteLn;
WriteString(S4);WriteLn;
WriteString(S5);WriteLn;
Usage; *)

   GetParams(Param, Count);
   IF Count > 1 THEN
      WriteLn; WriteLn;
      WriteString("There are "); WriteInt(Count,1)
      WriteString(" parameters. Maximum of one allowed."); 
      WriteString(" Use quotes.");
      WriteLn;
      WriteString("You may use one parameter e.g. SETDATE ");Write(42C);
      WriteString("TODAY AD3 -90 P1 7 18"); WriteLn; WriteLn;
      Usage;
      END;

   IF Count = 1 THEN
      GetNames(Param[0]^.Chars,Names,NameCount);
      J := -1;
      REPEAT 
         INC(J);
         CharMatrix[J] := Param[0]^.Chars[J];
         UNTIL (CharMatrix[J] = "=") OR (J >= JMax);
      CharMatrix[J] := 0x;

ELSE

reply:=Connect(InStream, InputFile, input);
IF reply <> 0 THEN
   WriteLn;
   WriteString("Run ");
   WriteString(ProgramName); WriteString(" from the directory where ");
   WriteString(InputFile); WriteString(" is "); WriteLn;
   WriteString("or use the DOS APPEND command. "); WriteLn; WriteLn;
   Usage; END;

(* read the whole DOC file *)
J := -1;
REPEAT 
   INC(J);
   ReadChar(InStream, AllDOC[J]);
   UNTIL (AllDOC[J] = "#");
DOC2 := J;
Disconnect(InStream,TRUE);

(* transfer part into character matrix to be analysed *)
J := -1;
REPEAT 
   INC(J);
   CharMatrix[J] := AllDOC[J];
   UNTIL (CharMatrix[J] = "=") OR (J >= JMax);
CharMatrix[J] := 0x;

(* find locations of strings and check the DOC file *)
DOC1 := Pos(InputFile,   (AllDOC),   0);
CheckName(AllDOC, DOC1, DOC2, 271687);
      END;

GetDateTime(TR);

(* if TODAY is at the start of the documentation file *)

IF Pos("TODAY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   (* Clear so DAY will not be found from this *)
   ClearFromHere := Pos("TODAY",(CharMatrix),0);
   CL := 4;   RmoveVr;
   WrSET;
   WriteString("TODAY=");
(*   WriteCard(((LONG(TR.Year) MOD 100)*10000 
              + LONG(TR.Month*100) + LONG(TR.Day)),1); *)
   IF LONG(TR.Year) MOD 100 < 10 THEN Write("0") END;
   WriteCard(LONG(TR.Year) MOD 100,1);
   IF TR.Month < 10 THEN Write("0") END;
   WriteCard(LONG(TR.Month),1);
   IF TR.Day < 10 THEN Write("0") END;
   WriteCard(LONG(TR.Day),1);
   WriteLn;
   END;

IF Pos("YR",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("YR",(CharMatrix),0);
   CL := 1;   RmoveVr;
   WrSET;
   WriteString("YR=");
   OutPartTime(TR.Year MOD 100);
   END;

IF Pos("TMTH",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("TMTH",(CharMatrix),0);
   CL := 3;   RmoveVr;
   WrSET;
   WriteString("TMTH=");
   WriteCard((TR.Month DIV 10),1);
   WriteLn;
   END;

IF Pos("UMTH",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("UMTH",(CharMatrix),0);
   CL := 3;   RmoveVr;
   WrSET;
   WriteString("UMTH=");
   WriteCard((TR.Month MOD 10),1);
   WriteLn;
   END;

IF Pos("MTH",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("MTH",(CharMatrix),0);
   CL := 2;   RmoveVr;
   WrSET;
   WriteString("MTH=");
   OutPartTime(TR.Month);
   END;

IF Pos("MX",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("MX",(CharMatrix),0);
   CL := 1;   RmoveVr;
   WrSET;
   WriteString("MX=");
   IF TR.Month < 10 THEN WriteCard(TR.Month,1);END;
   IF TR.Month = 10 THEN Write("A");END;
   IF TR.Month = 11 THEN Write("B");END;
   IF TR.Month = 12 THEN Write("C");END;
   WriteLn;
   END;

IF Pos("THU",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("THU",(CharMatrix),0);
   CL := 2;   RmoveVr;
   WrSET;
   WriteString("THU=");
   WriteCard((TR.Hundredth DIV 10),1);
   WriteLn;
   END;

IF Pos("UHU",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("UHU",(CharMatrix),0);
   CL := 2;   RmoveVr;
   WrSET;
   WriteString("UHU=");
   WriteCard((TR.Hundredth MOD 10),1);
   WriteLn;
   END;

IF Pos("HTH",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("HTH",(CharMatrix),0);
   CL := 2;   RmoveVr;
   WrSET;
   WriteString("HTH=");
   OutPartTime(TR.Hundredth);
   END;

IF Pos("TDAY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("TDAY",(CharMatrix),0);
   CL := 3;   RmoveVr;
   WrSET;
   WriteString("TDAY=");
   WriteCard((TR.Day DIV 10),1);
   WriteLn;
   END;

IF Pos("UDAY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("UDAY",(CharMatrix),0);
   CL := 3;   RmoveVr;
   WrSET;
   WriteString("UDAY=");
   WriteCard((TR.Day MOD 10),1);
   WriteLn;
   END;

FOR Ind := 0 TO 9 DO     (* P (Period) *)
   PerdSt := "P%"; PerdSt[1] := CHR(Ind+ORD("0"));
   IF Pos(PerdSt,(CharMatrix),0) <= HIGH(CharMatrix) THEN; Perd; END;
   END;

FOR Ind := 0 TO 9 DO     (* AD (Another Date)   *)
   ADSt := "AD%"; ADSt[2] := CHR(Ind+ORD("0"));
   IF Pos(ADSt,(CharMatrix),0) <= HIGH(CharMatrix) THEN; 
      AnotherDate(ADY, ADM, ADD); END;
   END;

IF Pos("NM",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("NM",(CharMatrix),0);
   CL := 1;   RmoveVr;
   NMin := TR.Minute+TR.Hour*60;
   WrSET;
   WriteString("NM=");
   IF  NMin < 1000 THEN Write("0") END;
   IF  NMin <  100 THEN Write("0") END;
   IF  NMin <   10 THEN Write("0") END;
   WriteCard(NMin, 1);
   WriteLn;
   END;

IF Pos("WOM",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("WOM",(CharMatrix),0);
   CL := 2;   RmoveVr;
   WrSET;
   WriteString("WOM=");
   WriteCard(((TR.Day-1) DIV 7) + 1, 1);
   WriteLn;
   END;

IF Pos("DAY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("DAY=");
   OutPartTime(TR.Day);
   END;

IF Pos("HR",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("HR=");
   OutPartTime(TR.Hour);
   END;

IF Pos("TH",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("TH=");
   WriteCard((TR.Hour DIV 10),1);
   WriteLn;
   END;

IF Pos("UH",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("UH=");
   WriteCard((TR.Hour MOD 10),1);
   WriteLn;
   END;

IF Pos("12H",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("12H=");
   IF TR.Hour < 13 THEN
      WriteCard((TR.Hour),1);
   ELSE;
      WriteCard((TR.Hour-12),1);
      END; 
   WriteLn;
   END;

IF Pos("MIN",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("MIN=");
   OutPartTime(TR.Minute);
   END;

IF Pos("TM",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("TM=");
   WriteCard((TR.Minute DIV 10),1);
   WriteLn;
   END;

IF Pos("UM",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("UM=");
   WriteCard((TR.Minute MOD 10),1);
   WriteLn;
   END;

IF Pos("NS",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("NS=");
   NSec := LONG(TR.Second) + LONG(TR.Minute)*60 + LONG(TR.Hour)*60*60;
   IF NSec < 10000 THEN Write("0") END;
   IF NSec <  1000 THEN Write("0") END;
   IF NSec <   100 THEN Write("0") END;
   IF NSec <    10 THEN Write("0") END;
   WriteCard(NSec, 1);
   WriteLn;
   END;

IF Pos("SEC",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("SEC=");
   OutPartTime(TR.Second);
   END;

IF Pos("TS",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("TS=");
   WriteCard((TR.Second DIV 10),1);
   WriteLn;
   END;

IF Pos("US",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("US=");
   WriteCard((TR.Second MOD 10),1);
   WriteLn;
   END;

IF Pos("LY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("LY=");
   WriteCard((TR.Year-1),1);
   WriteLn;
   END;

IF Pos("NY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("NY=");
   WriteCard((TR.Year+1),1);
   WriteLn;
   END;

IF Pos("CENT",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("CENT=");
   WriteCard((TR.Year DIV 100),1);
   WriteLn;
   END;

IF Pos("DOW",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("DOW=");
   WriteDay(ORD(TR.DayNo));
   WriteLn;
   END;

IF Pos("D3",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("D3=");
   Write3Day(ORD(TR.DayNo));
   WriteLn;
   END;

IF Pos("DL",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("DL=");
   WriteLongDay(ORD(TR.DayNo));
   WriteLn;
   END;

IF Pos("CD",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("CD=");
   Write1Day(ORD(TR.DayNo));
   WriteLn;
   END;

IF Pos("CM",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   WrSET;
   WriteString("CM=");
   Write12(TR.Month);
   WriteLn;
   END;

DayNumberYEARSTART := GetNumberOfDay(TR.Year, 1, 1);
DayNumberYEAREnd := GetNumberOfDay(TR.Year+1, 1, 1) - 1;
DayNumberToday := GetNumberOfDay(TR.Year, TR.Month, TR.Day);
NumbSinceJan1 := DayNumberToday - DayNumberYEARSTART + 1;

IF Pos("DFS",(CharMatrix),0) <= HIGH(CharMatrix) THEN; (* DFS Day From Start of year  *)
   WrSET;
   WriteString("DFS=");
   IF NumbSinceJan1 < 100 THEN Write("0") END;
   IF NumbSinceJan1 <  10 THEN Write("0") END;
   WriteCard(NumbSinceJan1, 1);WriteLn;
   END;

IF Pos("WOY",(CharMatrix),0) <= HIGH(CharMatrix) THEN;
   ClearFromHere := Pos("WOY",(CharMatrix),0);
   CL := 2;   RmoveVr;
   WrSET;
   WriteString("WOY=");
   IF ((NumbSinceJan1 - 1) DIV 7) + 1 < 10 THEN Write("0") END;
   WriteCard(((NumbSinceJan1-1) DIV 7)+1, 1);
   WriteLn;
   END;

IF Pos("DTE",(CharMatrix),0) <= HIGH(CharMatrix) THEN; (* DTE Day To End of year  *)
   NumbToGo := DayNumberYEAREnd - DayNumberToday;
   WrSET;
   WriteString("DTE=");
   IF NumbToGo < 100 THEN Write("0") END;
   IF NumbToGo <  10 THEN Write("0") END;
   WriteCard(NumbToGo, 1);WriteLn;
   END;

   END SETDATE.
