	PAGE	60,132
NAME	Grade
	TITLE	Grade version 1.3 RG 96/04/04
COMMENT |

 Grade 1.3 ۲
Copyright (C) 1990,1996
Roedy Green
Canadian Mind Products
POB 707 Quathiaski Cove
Quadra Island BC Canada
V0P 1N0
(250) 285-2954
Internet Roedy@Bix.Com

This program may be freely copied and used for any purpose
except military.  The one exception is U.N. sanctioned
peacekeeping missions.

Usage:

Grade C:\MySub\MyFile.Ext  1024
REM Must test big errorlevels first
IF     ERRORLEVEL 2 GOTO Error
IF     ERRORLEVEL 1 GOTO BigOrEqual
IF     ERRORLEVEL 0 GOTO Small

Grade grades files into two classes depending on whether the
file is smaller than the given limit or not.

Grade also sets the ERRORLEVEL to 0 for smaller, 1 for equal, 1
for larger and 2 for no such file.

It displays a messages telling whether the file is small or
large.	Files equal to the limit are also considered big.  Using
pipes you can redirect this message to file for further
processing.

Grade does not change the size of the file or create files.  If
you need to create an empty file, try EMPTY.COM.  If you need to
create one of a certain size, try RESIZE.COM.

Uses for Grade

1.  Checking when it is time to reindex Magellan.  When the secondary
    index gets too large, you can rebuild the primary index.

2.  Warning when files are getting too big for efficiency and need to
    be split.

3.  Preparing lists of small or large files that can then be massaged
    with the FIND command or a text processor to create bat files to
    operate only on the small or large files.

Note this version of GRADE uses only two categories, small and
large.	The code has been written is such a way it could be
easily changed to generate small, equal and big.

Version 1.3 1996 October 25
- embed POB 707 Quathiaski Cove address

| ;

;==============================================================

SAY	MACRO	Msg
;	display message on screen
	LEA	DX,&Msg 	; use LEA rather than
				; MOV Offset for more generality
	MOV	AH,09h
	INT	21h
	ENDM

;==============================================================

stack	segment stack		; keep MS link happy by providing null stack
stack	ends

CODE	SEGMENT PARA		; start off in code.

;==============================================================

data	segment byte		; provide a separate DATA segment

; VARIABLES

Limit		DW	0,0	; Limit on size of file in bytes 32 bits

FileSize	DW	0,0	; Current Length of file

FileNameAd	DW	0	; address first char of filename
FileNameLen	DW	0	; len of filename, not counting trailing null

LimitAd 	DW	0	; address of Limit string
LimitLen	DW	0	; length of Limit string

Handle		DW	0	; handle for the file

ErrorLevel	DB	0	; errorlevel to exit with

; MESSAGES
;==============================================================

NoSuchFileMsg	LABEL BYTE
	DB	'No such file',13,10,'$'

FileMsg 	LABEL	BYTE
	DB	'File: ','$'

SmallMsg	LABEL	BYTE			; for smaller than limit
	DB	' is small',13,10,'$'

EqualMsg	LABEL	BYTE			; for equal to the limit
						; use same message as big
BigMsg		LABEL	BYTE			; for bigger than limit
	DB	' is large',13,10,'$'

TroubleMsg	LABEL BYTE
	DB	'Usage is:',13,10
	DB	'Grade C:\MySub\MyFile.Ext 9999999',13,10
	DB	'to see if file is smaller than 9999999 bytes long',13,10
	DB	'  error ERRORLEVEL=2',13,10
	DB	' larger ERRORLEVEL=1',13,10
	DB	'  equal ERRORLEVEL=1',13,10
	DB	'smaller ERRORLEVEL=0',13,10
	DB	13,10
	DB	' Grade 1.3 ۲',13,10
	DB	'Copyright (c) 1990,1996 Roedy Green',13,10
	DB	'Canadian Mind Products',13,10
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	'This program may be freely copied and used for any purpose except military.',13,10,'$'
data	ends

;==============================================================

com	group	code,data	; force data segment to go at the end!

	ASSUME	CS:com,DS:com,ES:com,SS:com
				; seg regs cover everything
	ORG	100H		; in Code segment


Main	PROC	Near

START:
	Call	Parse		; Parse the Command for the two parameters:
				; FileNameAd and Limit.

	Call	Openfile	; Open the file

	Call	GetFileSize	; get length of file

	Say	FileMsg 	; display "File: "

	Call	SayFileName	; display the file name

; Compare 32-bit files size with the limit.

	MOV	AX,FileSize	; current size = DX:AX
	MOV	DX,FileSize+2
				; limit size   = Limit
	CMP	AX,Limit
	JNE	NotEqual
	CMP	DX,Limit+2
	JNE	NotEqual

Equal:
	MOV	Errorlevel,1	; Equal to limit, set ERRORLEVEL=1
	Say	EqualMsg	; for now, treat as large.
	JMP	short Done

NotEqual:
	SUB	AX,Limit
	SBB	DX,Limit+2
;	BE CAREFUL, JL works after 32 bit compare, JG JE will not.
	JL	IsSmaller

IsBigger:
	MOV	Errorlevel,1	; Bigger that limit; set ERRORLEVEL=1
	Say	BigMsg
	JMP	short Done

IsSmaller:
	MOV	Errorlevel,0	; Smaller than limit; set ERRORLEVEL=0
	Say	SmallMsg
Done:

	Call	CloseFile	; Close the file

QUIT:
	MOV	AL,Errorlevel
	MOV	AH,04CH 	; EXIT back to DOS
	INT	21H

;==============================================================
; ERROR HANDLERS

NoSuchFile:
;	Could not open file
	mov	ErrorLevel,2	; trouble, set ERRORLEVEL=2
	Say	NoSuchFileMsg
	JMP	short QUIT

Trouble:
;	Some problem, give standard Error message.
;	More detail would probably just confuse
	mov	ErrorLevel,2	; trouble, set ERRORLEVEL=2
	Say	TroubleMsg
	JMP	short QUIT

;==============================================================
OpenFile	Proc	Near
; Open the file
				; or entry FileNameAd points to
				; ASCIIZ filename.
				; on exit Handle has file handle
	MOV	DX,FileNameAd
	XOR	CX,CX		; CX=0 is attribute
	MOV	AL,0h		; read-only access
	MOV	AH,3Dh		; DOS open
	INT	21h
	JC	NoSuchFile
	MOV	Handle,AX	; save handle
	RET
OpenFile	ENDP

;==============================================================

CloseFile	Proc	Near
; Close the file
	MOV	BX,Handle	; on entry Handle has file handle
	MOV	AH,3Eh
	INT	21h		; DOS close
	JC	Trouble
	RET
CloseFile	ENDP

;==============================================================

GetFileSize	Proc	Near
; How long is file right now?
	MOV	BX,Handle	; On entry Handle contains file handle
				; on exit FileSize contains Size.
	XOR	DX,DX		; CX:DX is 0 offset from end
	MOV	CX,DX
	MOV	AL,2		; relative to end style seek
	MOV	AH,42h
	INT	21h		; DOS seek
	JC	Trouble
	MOV	FileSize,AX	; save file length
	MOV	FileSize+2,DX
	RET
GetFileSize	ENDP
;==============================================================

SayFileName	PROC	NEAR
;	Displays the filename on the screen
	MOV	BX,1		; prefined file handle 1 = screen
	MOV	DX,FileNameAd	; DS:DX points to Current file name
	MOV	CX,FileNameLen	; CX is file name length
	MOV	AH,40H		; WRITE HANDLE
	INT	21H
	RET
SayFileName	ENDP

;==============================================================

Parse	Proc	Near
;	Parse the command line to get the filename and the limit

; Get the filename
	Call	ParseFileName	; create ASCIIZ string

; Get the limit we compare the file length against

	Call	ParseLimit	; find the ascii string
	MOV	CX,Limitlen	; length in ASCII chars of Limit
	MOV	SI,LimitAd
	CALL	ASCIItoBin	; limit size = DX:AX
	MOV	Limit,AX	; save in Limit
	MOV	Limit+2,DX
	RET

ParseTrouble:			; just give generic trouble
				; message if any trouble parsing
	JMP	Trouble

Parse	ENDP

;==============================================================

; PARSE FILENAME
ParseFileName	PROC
				; Exit with ASCIIZ filename string
				; pointed to by FileNameAd:FileNameLen
				; and with DI pointing to string remdr
				; and CX counting its length
				; To start,
				; counted string at HEX 80
				; contains command line.
				; It has no trailing null.
				; Name of file we want is
				; preceded and followed by
				; unwanted spaces.
	XOR	CH,CH
	MOV	CL,DS:80h	; CX contains length of command
	MOV	BX,CX
	MOV	AL,20h
	MOV	[BX+81h],AL	; store trailing blank on command
	INC	CX		; and increase string length.
				; to simplify parsing
	MOV	DI,81h
	JCXZ	ParseTrouble
	REPE	SCASB		; scan for start file name
				; DI points one past it.
	MOV	DX,DI		; DS:DX point to file
	DEC	DX
	MOV	FileNameAd,DX	; Save pointer for future ref.
	JCXZ	ParseTrouble
	REPNE	SCASB		; scan to end of file name
				; DI points one past trail blank
				; DONT DISTURB DI, we need it later!
				; patch in trail null after filename
	MOV	BYTE PTR [DI-1],0
	MOV	DX,DI
	DEC	DX
	SUB	DX,FileNameAd	; calculate string length
	MOV	FileNameLen,DX	; store len for future ref
	RET
ParseFileName	ENDP
;==============================================================

; PARSE LIMIT, find the string for the limit Limit on the command line

ParseLimit	PROC
				; DS:DI points to blanks before
				; number.  CX is remdr of command len.
				; Store addr:len in LimitAd:LimitLen
	JCXZ	ParseTrouble
	MOV	AL,020h
	REPE	SCASB		; scan for first digit of Limit
	MOV	DX,DI		; point to Limit start
	DEC	DX
	MOV	LimitAd,DX	; Save location start Limit for
				; future ref.
	JCXZ	ParseTrouble
	REPNE	SCASB		; scan for blank at end of Limit
	SUB	DI,DX		; calculate length of Limit string
	DEC	DI
	JLE	ParseTrouble	; had better be positive
	MOV	LimitLen,DI	; save length for future ref.
	RET

ParseLimit	ENDP

;==============================================================

ASCIIToBin	PROC
;	on entry DS:SI points to start of decimal ASCII string of digits.
;	String should contain only the decimal digits 0..9.
;	CX contains length of string > 0
;	On exit DX:AX contains binary equivalent of string.
	XOR	AX,AX
	MOV	DX,AX		; accumulate in DX:AX

OneDigitLoop:

; multiply accumulated number by 10
				; Works because 10*X = 2*X + 8*X
				; use DI:BX as working register
	SHL	AX,1
	RCL	DX,1		; DX:AX = x*2
	MOV	BX,AX
	MOV	DI,DX
	SHL	BX,1
	RCL	DI,1
	SHL	BX,1
	RCL	DI,1		; DI:BX = x*8
	ADD	BX,AX
	ADC	DI,DX		; DI:BX = x*2 + x*8

; add on the next digit
	XOR	DX,DX
	MOV	AH,DH
	LODSB			; get next digit in AL
	SUB	AL,"0"		; convert 1 digit ASCII to bin
	JL	NumTrouble	; ensure 0..9
	CMP	AL,9
	JG	NumTrouble
	ADD	AX,BX		; add it onto accumulated product
	ADC	DX,DI

	LOOP	OneDigitLoop	; loop once for each digit

				; restore regs
	RET
NumTrouble:
;	Some problem, give standard Error message.
	JMP	Trouble

;
ASCIIToBin	ENDP

;==============================================================

Main	ENDP

CODE	ENDS
	END	START		; Start is the entry point. Must be 100H
