	IDEAL
	P386
	MODEL USE32 SMALL

include "lib.asi"

	PUBLIC	_OSPutChar,_OSPutExtendedChar, _OSPutText, _OSClearTextScreen
	PUBLIC	_OSSetTextAttribute,_OSSetTextCursor
	PUBLIC	_OSGetTextAttribute,_OSGetTextCursor
	PUBLIC	_OSBlankScreen, _OSUnblankScreen
SEGMENT	_TEXT
;
;* void OSPutChar(char item);
;
PROC	_OSPutChar
	ARG	ITEM : DWORD
	ENTER	0,0
	mov	dl,[BYTE PTR ITEM]
	OS	VF_CHAR
	LEAVE
	ret
ENDP	_OSPutChar
;
;* void OSPutExtendedChar(char item);
;
PROC	_OSPutExtendedChar
	ARG	ITEM : DWORD
	ENTER	0,0
	mov	dl,[BYTE PTR ITEM]
	OS	VF_CHAR
	LEAVE
	ret
ENDP	_OSPutExtendedChar
;
;* void OSPutText(char *text);
;
PROC	_OSPutText
	ARG	ITEM : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[ITEM]
	OS	VF_TEXT
	pop	ebx
	LEAVE
	ret
ENDP	_OSPutText
;
;* void OSClearTextScreen(void);
;
PROC	_OSClearTextScreen
	OS	VF_CLEARSCREEN
	ret
ENDP	_OSClearTextScreen
;
;* void OSSetTextAttribute(int attribute);
;
PROC	_OSSetTextAttribute
	ENTER	0,0
	ARG	ATTRIBUTE : DWORD
	mov	al,[BYTE PTR ATTRIBUTE]
	OS	VF_SETATTRIBUTE
	LEAVE
	ret
ENDP	_OSSetTextAttribute
;
;* void OSSetTextCursor(int row, int col);
;
PROC	_OSSetTextCursor
	ENTER	0,0
	ARG	ROW : DWORD, COL : DWORD
	push	ebx
	mov	bh,[BYTE PTR ROW]
	mov	bl,[BYTE PTR COL]
	OS	VF_SETCURPOS
	pop	ebx
	LEAVE
	ret
ENDP	_OSSetTextCursor
;
;* int OSGetTextAttribute(void);
;
PROC	_OSGetTextAttribute
	OS	VF_GETATTRIBUTE
	cbw
	cwde
	ret
ENDP	_OSGetTextAttribute
;
;* void OSGetTextCursor(int *row, int *col);
;
PROC	_OSGetTextCursor
	ENTER	0,0
	ARG	ROW : DWORD, COL : DWORD
	OS	VF_GETCURPOS
	mov	ecx,eax
	cbw
	cwde
	mov	edx,[COL]
	mov	[edx],eax
	mov	eax,ecx
	cbw
	cwde
	mov	edx,[ROW]
	mov	[edx],eax
	LEAVE
	ret
ENDP	_OSGetTextCursor
;
;* void OSBlankScreen(void);
;
PROC	_OSBlankScreen
	OS	VF_BLANKSCREEN
	ret
ENDP	_OSBlankScreen
;
;* void OSUnblankScreen(void);
;
PROC	_OSUnblankScreen
	OS	VF_UNBLANKSCREEN
	ret
ENDP	_OSUnblankScreen 
ENDS	_TEXT
END