	IDEAL
	P386
	MODEL USE32 SMALL

include "lib.asi"

	PUBLIC	_OSVGATextMode, _OSVGAGraphicsMode, _OSVGAClearScreen
	PUBLIC	_OSVGATextChar, _OSVGAWideTextChar, _OSVGATallTextChar
	PUBLIC	_OSVGAHorizBar, _OSVGAVertBar, _OSVGAFillCorner
SEGMENT	_TEXT
;
;* void OSVGATextMode(void);
;
PROC	_OSVGATextMode
	OS	GR_TEXTMODE
	ret
ENDP	_OSVGATextMode
;
;* void OSVGAGraphicsMode(void);
;
PROC	_OSVGAGraphicsMode
	OS	GR_GRAPHMODE
	ret
ENDP	_OSVGAGraphicsMode
;
;* void OSVGAClearScreen(void);
;
PROC	_OSVGAClearScreen
	OS	GR_CLEARSCREEN
	ret
ENDP	_OSVGAClearScreen
PROC	GetTextParms
	ARG	POS : DWORD, CHAR : DWORD, FG : DWORD, BG: DWORD, FONT : DWORD
	push	ds
	pop	gs
	mov	esi,[FONT]
	mov	edi,[POS]
	or	esi,esi
	jnz	short usethis
	mov	esi,[CHAR]
	shl	esi,4
	OS	GR_SYSFONTBASE
	add	esi,eax
usethis:
	mov	bh,[BYTE PTR FG]
	mov	bl,[BYTE PTR BG]
	ret
ENDP	GetTextParms
;
;* void OSVGATextChar(int pos, int achar, int fg, int bg, unsigned char *font);
;
PROC	_OSVGATextChar
	ENTER	0,0
	push	gs
	push	esi
	push	edi
	call	GetTextParms
	OS	GR_TEXTCHAR
	pop	edi
	pop	esi
	pop	gs
	LEAVE
	ret
ENDP	_OSVGATextChar
;
;* void OSVGAWideTextChar(int pos, int achar, int fg, int bg, unsigned char *font);
;
PROC	_OSVGAWideTextChar
	ENTER	0,0
	push	gs
	push	esi
	push	edi
	call	GetTextParms
	OS	GR_WIDETEXTCHAR
	pop	edi
	pop	esi
	pop	gs
	LEAVE
	ret
ENDP	_OSVGAWideTextChar
;
;* void OSVGATallTextChar(int pos, int achar, int fg,int bg, unsigned char *font);
;
PROC	_OSVGATallTextChar
	ENTER	0,0
	push	gs
	push	esi
	push	edi
	call	GetTextParms
	OS	GR_TALLTEXTCHAR
	pop	edi
	pop	esi
	pop	gs
	LEAVE
	ret
ENDP	_OSVGATallTextChar
;
;* void OSVGAHorizBar(int pos, int fg, int len);
;
PROC	_OSVGAHorizBar
	ARG	POS : DWORD, FG : DWORD, LEN : DWORD
	ENTER	0,0
	push	edi
	push	ebx
	mov	ecx,[LEN]
	mov	bl,[BYTE PTR FG]
	mov	edi,[POS]
	OS	GR_HORIZBAR
	pop	ebx
	pop	edi
	LEAVE
	ret
ENDP	_OSVGAHorizBar
;
;* void OSVGAVertBar(int pos, int fg, int width, int len);
;
PROC	_OSVGAVertBar
	ARG	POS : DWORD, FG : DWORD, VWIDTH : DWORD, LEN : DWORD
	ENTER	0,0
	push	edi
	push	ebx
	mov	edi,[POS]
	mov	bl,[BYTE PTR FG]
	mov	bh,[BYTE PTR VWIDTH]
	mov	ecx,[LEN]
	OS	GR_VERTBAR
	pop	ebx
	pop	edi
	LEAVE
	ret
ENDP	_OSVGAVertBar
;
;* void OSVGAFillCorner(int pos, int fg, int offset);
;
PROC	_OSVGAFillCorner
	ARG	pos : DWORD, FG : DWORD, VOFFSET : DWORD
	ENTER	0,0
	push	edi
	push	ebx
	mov	edi,[POS]
	mov	bl,[BYTE PTR FG]
	mov	dl,[BYTE PTR VOFFSET]
	OS	GR_FILLCORNER
	pop	ebx
	pop	edi
	LEAVE
	ret
ENDP	_OSVGAFillCorner
ENDS	_TEXT

END