	IDEAL
	P386
	MODEL USE32 SMALL

include "lib.asi"

	PUBLIC	_OSRunProgram,_OSRunProgramAndWait,_OSSpawnChild
	PUBLIC	_OSSpawnChildAndWait,_OSPause,_OSEndTask,_OSRundownOS

SEGMENT	_TEXT
;
;* int OSRunProgram(char *name);
;
PROC	_OSRunProgram
	ARG	FILENAME : DWORD
	ENTER	0,0
	push	esi
	push	edi
	sub	esi,esi
	sub	edi,edi
	mov	ebx,[FILENAME]
	OS	TA_NEW
	jc	short getout
okrun:
    	sub	eax,eax
getout:
	pop	edi
	pop	esi
	LEAVE
	ret
ENDP	_OSRunProgram
	
;
;* int OSRunProgramAndWait(char *name);
;
PROC	_OSRunProgramAndWait
	ARG	FILENAME : DWORD
	ENTER	0,0
	push	esi
	push	edi
	push	ebx
	sub	esi,esi
	sub	edi,edi
	mov	ebx,[FILENAME]
	OS	TA_NEWWAIT
	pop	ebx
	jnc	okrun
	pop	edi
	pop	esi
	LEAVE
	ret
ENDP	_OSRunProgramAndWait
;
;* int OSSpawnChild(int address);
;
PROC	_OSSpawnChild
	ARG	ADDRESS : DWORD
	ENTER	0,0
	push	esi
	push	edi
	sub	esi,esi
	sub	edi,edi
	push	ebx
	mov	ebx,[ADDRESS]
	OS	TA_SPAWN
	pop	ebx
	jnc	okrun
	pop	edi
	pop	esi
	LEAVE
	ret
ENDP	_OSSpawnChild
;
;* int OSSpawnChildAndWait(int address);
;
PROC	_OSSpawnChildAndWait
	ARG	ADDRESS : DWORD
	ENTER	0,0
	push	esi
	push	edi
	sub	esi,esi
	sub	edi,edi
	push	ebx
	mov	ebx,[ADDRESS]
	OS	TA_SPAWNWAIT
	pop	ebx
	jnc	okrun
	pop	edi
	pop	esi
	LEAVE
	ret
ENDP	_OSSpawnChildAndWait
;
;* void OSPause(void);
;
PROC	_OSPause
	OS	TA_PAUSE
	ret
ENDP	_OSPause
;
;
;* void OSEndTask(int endval);
;
PROC	_OSEndTask
	OS	TA_END
	ret
ENDP	_OSEndTask
;
;* void OSRundownOS(void);
;
PROC	_OSRundownOS
	OS	TA_EXIT
	ret
ENDP	_OSRundownOS

ENDS	_TEXT
END