	IDEAL
	P386
	MODEL USE32 SMALL

include "lib.asi"

	PUBLIC	_OSSerialEnable,_OSSerialDisable,_OSSerialPutChar
	PUBLIC	_OSSerialGetChar,_OSSerialSetMode,_OSSerialGetMode
	PUBLIC	_OSSerialClearTransmit, _OSSerialClearReceive
	PUBLIC	_OSSerialTransmitStatus, _OSSerialReceiveStatus

SEGMENT	_TEXT
;
;* void OSSerialEnable(int line);
;
PROC	_OSSerialEnable
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS 	SP_ENABLE
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialEnable
;
;* void OSSerialDisable(int line);
;
PROC	_OSSerialDisable
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_DISABLE
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialDisable
;
;* void OSSerialPutChar(int line, unsigned char theChar);
;
PROC	_OSSerialPutChar
	ARG	LINE : DWORD, THECHAR : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	mov	dl,[BYTE PTR THECHAR]
	OS	SP_PUTCHAR
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialPutChar
;
;* unsigned char OSSerialGetChar(int line);
;
PROC	_OSSerialGetChar
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_GETCHAR
	jc	short retneg1
	pop	ebx
	LEAVE
	ret
retneg1:
	sub	eax,eax
	dec	eax
	LEAVE
	ret
ENDP	_OSSerialGetChar
;
;* void OSSerialSetMode(int line, int modes, int baudrate);
;
PROC	_OSSerialSetMode
	ARG	LINE : DWORD, MODES : DWORD, BAUDRATE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	mov	ecx,[BAUDRATE]
	mov	edx,[MODES]
	OS	SP_SETMODE
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialSetMode
;
;* int OSSerialGetMode(int line);
;
PROC	_OSSerialGetMode
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS      SP_GETMODE
	pop	ebx
	LEAVE	
	ret
ENDP	_OSSerialGetMode
;
;* void OSSerialClearTransmit(int line);
;
PROC	_OSSerialClearTransmit
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_CLEARXMIT
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialClearTransmit
;
;* void OSSerialClearReceive(int line);
;
PROC	_OSSerialClearReceive
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_CLEARRCV
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialClearReceive
;
;* int OSSerialTransmitStatus(int line);
;
PROC	_OSSerialTransmitStatus
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_XMITSTATUS
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialTransmitStatus
;
;* int OSSerialReceiveStatus(int line);
;
PROC	_OSSerialReceiveStatus
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_RCVSTATUS
	pop	ebx
	LEAVE
	ret
ENDP	_OSSerialReceiveStatus
ENDS	_TEXT
END