	IDEAL
	P386
	MODEL USE32 SMALL

include "lib.asi"

	PUBLIC	_OSGetTicks,_OSConvertToMS,_OSConvertToTicks
	PUBLIC	_OSSetDate,_OSGetDate,_OSSetTime,_OSGetTime
	PUBLIC	_OSEnableWatchDog, _OSDisableWatchDog,_OSResetWatchDog
	PUBLIC  _OSGetVersion

SEGMENT	_TEXT
;
;* unsigned OSGetTicks(void);
;
PROC	_OSGetTicks
	OS	MI_TIMER
	ret
ENDP	_OSGetTicks
;
;* unsigned OSConvertToMS(unsigned value);
;
PROC	_OSConvertToMS
	arg	VALUE : DWORD
	ENTER	0,0
	mov	eax,[VALUE]
	OS	MI_CVTTOMS
	LEAVE
	ret
ENDP	_OSConvertToMS
;
;* unsigned OSConvertToTicks(unsigned value);
;
PROC	_OSConvertToTicks
	arg	VALUE : DWORD
	ENTER	0,0
	mov	eax,[VALUE]
	OS	MI_CVTFROMMS
	LEAVE
	ret
ENDP	_OSConvertToTicks
;
;* void OSSetDate(int day, int month, int year);
;
PROC	_OSSetDate
	ARG	DAY : DWORD, MONTH : DWORD, YEAR : DWORD
	ENTER	0,0
	push	ebx
	mov	bh,[BYTE PTR DAY]
	mov	bl,[BYTE PTR MONTH]
	mov	ecx,[YEAR]
	OS	MI_SETDATE
	pop	ebx
	LEAVE
	ret
ENDP	_OSSetDate
;
;* void OSSetTime(int hr, int min, int sec);
;
PROC	_OSSetTime
	ARG	HR : DWORD, MIN : DWORD, SEC : DWORD
	ENTER	0,0
	push	ebx
	mov	bh,[BYTE PTR HR]
	mov	bl,[BYTE PTR MIN]
	mov	cl,[BYTE PTR SEC]
	OS	MI_SETTIME
	pop	ebx
	LEAVE
	ret
ENDP	_OSSetTime
;
;* void OSGetDate(int *day, int *month, int *year);
;
PROC	_OSGetDate
	ARG	DAY : DWORD, MONTH : DWORD, YEAR : DWORD
	ENTER	0,0
	push	ebx
	OS	MI_GETDATE
	mov	edx,[DAY]
	movzx	eax,bh
	mov	[edx],eax
	mov	edx,[MONTH]
	movzx	eax,bl
	mov	[edx],eax
	mov	edx,[YEAR]
	mov	[edx],ecx
	pop	ebx
	LEAVE
	ret
ENDP	_OSGetDate
;
;* void OSGetTime(int *hr, int *min, int *sec);
;
PROC	_OSGetTime
	ARG	HR : DWORD, MIN : DWORD, SEC : DWORD
	ENTER	0,0
	push	ebx
	OS	MI_GETTIME
	mov	edx,[HR]
	movzx	eax,bh
	mov	[edx],eax
	mov	edx,[MIN]
	movzx	eax,bl
	mov	[edx],eax
	mov	edx,[SEC]
	mov	[edx],ecx
	pop	ebx
	LEAVE
	ret
ENDP	_OSGetTime
;
;* void OSEnableWatchDog(void);
;
PROC	_OSEnableWatchDog
	OS	MI_ENABLEWATCHDOG
	ret
ENDP	_OSEnableWatchDog
;
;* void OSDisableWatchDog(void);
;
PROC	_OSDisableWatchDog
	MOV	EBX,WATCHDOGVERIFY
	OS	MI_DISABLEWATCHDOG
	ret
ENDP	_OSDisableWatchDog
;
;* void OSResetWatchDog(void);
;
PROC	_OSResetWatchDog
	OS	MI_RESETWATCHDOG
	ret
ENDP
;
;* int OSGetVersion(void);
;
PROC	_OSGetVersion
	OS	MI_VERSION
	ret
ENDP	_OSGetVersion
ENDS	_TEXT
END