	IDEAL
	P386
	MODEL USE32 SMALL

include	"lib.asi"

	PUBLIC	_OSMakeFS, _OSFlushBuffers, _OSOpenFile,_OSCreateFile
	PUBLIC	_OSCloseFile, _OSDeleteFile, _OSTruncateFile
	PUBLIC	_OSRenameFile, _OSReadFile, _OSWriteFile, _OSFileSetPosition
	PUBLIC	_OSFileGetPosition
	PUBLIC	_OSFilePositionAtEOF, _OSFileSetTime, _OSFileGetTime
	PUBLIC	_OSGetStdHandle, _OSGetHandleType, _OSGetLastError

SEGMENT	_TEXT
;
;* int OSMakeFS(int drive);
;
noerror:
	sub	eax,eax
	LEAVE
	ret
PROC	_OSMakeFS
	ARG	DRIVE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	OS	FS_MAKEFS
	pop	ebx
	jnc	short noerror
	LEAVE
	ret
ENDP	_OSMakeFS
;
;* int OSFlushBuffers(void);
;
PROC	_OSFlushBuffers
	ENTER	0,0
	OS	FS_FLUSHBUFFERS
	jnc	noerror
	LEAVE
	ret
ENDP	_OSFlushBuffers
;
;* int OSOpenFile(int drive, char *filename, int *handle);
;
PROC	_OSOpenFile
	ARG	DRIVE : DWORD, FILENAME : DWORD, HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[FILENAME]
	OS	FS_OPEN
	mov	edx,[HANDLE]
	mov	[EDX],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSOpenFile
;
;* int OSCreateFile(int drive, char *filename, int *handle);
;
PROC	_OSCreateFile
	ARG	DRIVE : DWORD, FILENAME : DWORD, HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[FILENAME]
	OS	FS_CREATE
	mov	ebx,[HANDLE]
	mov	[ebx],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSCreateFile
;
;* int OSCloseFile(int handle);
;
PROC	_OSCloseFile
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_CLOSE
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSCloseFile
;
;* int OSDeleteFile(int drive, char *filename);
;
PROC	_OSDeleteFile
	ARG	DRIVE : DWORD, FILENAME : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[FILENAME]
	OS	FS_DELETE
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSDeleteFile
;
;* int OSTruncateFile(int handle);
;
PROC	_OSTruncateFile
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_TRUNCATE
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSTruncateFile
;
;* int OSRenameFile(int drive, char *orig, char*new);
;
PROC	_OSRenameFile
	ARG	DRIVE : DWORD, ORIG : DWORD, NEW : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	mov	ecx,[ORIG]
	mov	edx,[NEW]
	OS	FS_RENAME
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSRenameFile
;
;* int OSReadFile(int handle, int size, unsigned char *buffer, int*sizeread);
;
PROC	_OSReadFile
	ARG	HANDLE : DWORD, BUFSIZE : DWORD, BUFFER : DWORD, SIZEREAD : DWORD
	ENTER	0,0
	push	ebx
	push	esi
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	esi,[BUFFER]
	OS	FS_READ
	mov	ebx,[SIZEREAD]
	mov	[ebx],ecx
	pop	esi
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSReadFile
;
;* int OSWriteFile(int handle, int size, unsigned char *buffer, int *sizeread);
;
PROC	_OSWriteFile
	ARG	HANDLE : DWORD, BUFSIZE : DWORD, BUFFER : DWORD, SIZEREAD : DWORD
	ENTER	0,0
	push	ebx
	push	esi
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	esi,[BUFFER]
	OS	FS_WRITE
	mov	ebx,[SIZEREAD]
	mov	[ebx],ecx
	pop	esi
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSWriteFile
;
;* int OSFileSetPosition(int handle, int position, int method);
;
PROC	_OSFileSetPosition
	ARG	HANDLE : DWORD, POSITION : DWORD, METHOD : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	ecx,[METHOD]
	mov	edx,[POSITION]
	OS	FS_SETPOSITION
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSFileSetPosition
;
;* int OSFileGetPosition(int handle, int *position);
;
PROC	_OSFileGetPosition
	ARG	HANDLE : DWORD, POSITION : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_GETPOSITION
	mov	ebx,[POSITION]
	mov	[ebx],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSFileGetPosition
;
;* int OSFilePositionAtEOF(int handle);
;
PROC	_OSFilePositionAtEOF
	
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_POSEOF
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSFilePositionAtEOF
;
;* int OSFileSetTime(int handle, int time);
;
PROC	_OSFileSetTime
	ARG	HANDLE : DWORD, TIME : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	edx,[TIME]
	OS	FS_SETIME
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSFileSetTime
;
;* int OSFileGetTime(int handle, unsigned *time);
;
PROC	_OSFileGetTime
	ARG	HANDLE : DWORD, TIME : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_GETIME
	mov	ebx,[TIME]
	mov	[ebx],eax
	pop	ebx
	jnc	noerror
	LEAVE
	ret
ENDP	_OSFileGetTime
;
;* int OSGetStdHandle(int htype);
;
PROC	_OSGetStdHandle
	ARG	HTYPE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HTYPE]
	OS	FS_GETSTDHANDLE
	pop	ebx
	LEAVE
	ret
ENDP	_OSGetStdHandle
;
;* int OSGetHandleType(int handle);
;
PROC	_OSGetHandleType
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FS_GETHANDLETYPE
	pop	ebx
	LEAVE
	ret
ENDP	_OSGetHandleType
;
;* int OSGetLastError(void);
;
PROC	_OSGetLastError
	OS	FS_GETLASTERROR
	ret
ENDP	_OSGetLastError
ENDS	_TEXT
END