	IDEAL
	P386
	MODEL USE32 SMALL

include	"lib.asi"

   	PUBLIC	_OSDosOpenFile,_OSDosCreatFile,_OSDosCloseFile
	PUBLIC	_OSDosReadFile,_OSDosWriteFile,_OSDosPositionFile

SEGMENT	_TEXT
;
;* int OSDosOpenFile(char *filename, unsigned mode);
;
PROC	_OSDosOpenFile
	ARG	FILENAME : DWORD, MODE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[FILENAME]
	mov	dl,[BYTE PTR MODE]
	OS	FI_OPEN
	pop	ebx
	jc	short zeroreturn
	LEAVE
	RET
zeroreturn:
	xor	eax,eax
	LEAVE
	ret
ENDP	_OSDosOpenFile
;
;* int OSDosCreatFile(char *filename);
;
PROC	_OSDosCreatFile
	ARG	FILENAME : DWORD, MODE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[FILENAME]
	sub	ecx,ecx
	OS	FI_CREAT
	pop	ebx
	jc	zeroreturn
	LEAVE
	RET
ENDP	_OSDosCreatFile
;
;* int OSDosCloseFile(int handle);
;
PROC	_OSDosCloseFile
	ARG	HANDLE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[HANDLE]
	OS	FI_CLOSE
	pop	ebx
	jnc	zeroreturn
	LEAVE
	ret
ENDP	_OSDosCloseFile
;
;* int OSDosReadFile(int handle, unsigned char *buffer, int size, int *sizeret);
;
PROC	_OSDosReadFile
	ARG	HANDLE : DWORD, BUFFER : DWORD, BUFSIZE : DWORD, SIZERET : DWORD
	ENTER 0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	edx,[BUFFER]
	OS	FI_READ
	mov	ebx,[SIZERET]
	mov	[ebx],ecx
	pop	ebx
	jc	zeroreturn
	LEAVE
	ret
ENDP	_OSDosReadFile
;
;* int OSDosWriteFile(int handle, unsigned char *buffer, int size, int *sizeret);
;
PROC	_OSDosWriteFile
	ARG	HANDLE : DWORD, BUFFER : DWORD, BUFSIZE : DWORD, SIZERET : DWORD
	ENTER 0,0
	push	ebx
	mov	ebx,[HANDLE]
	mov	ecx,[BUFSIZE]
	mov	edx,[BUFFER]
	OS	FI_WRITE
	mov	ebx,[SIZERET]
	mov	[ebx],ecx
	pop	ebx
	jc	zeroreturn
	LEAVE
	ret
ENDP	_OSDosWriteFile
;
;* int OSDosPositionFile(int handle, int position);
;
PROC	_OSDosPositionFile
	ARG	HANDLE : DWORD, POSITION : DWORD
	ENTER	0,0
	push	ebx
	mov	edx,[POSITION]
	mov	ebx,[HANDLE]
	OS	FI_POSITION
	pop	ebx
	XOR	EAX,EAX
	LEAVE
	ret
ENDP	_OSDosPositionFile
ENDS	_TEXT
END