; Obsolete file
;
; This file does not work with VGA graphics mode !
;
; Vidisr.asm
;
; Function : 60 Hz interrupt
;   Handles the EGA vertical isr, incrementing a counter each time it is processed
;
	IDEAL
        P386

	PUBLIC	_visr_enable, _visr_disable, _tickcount, _videoisr

include "segs.asi"
include "pic.asi"
include "ints.asi"
include "prints.ase"
include "iodelay.asi

VIDINT	EQU	2
CASCADE EQU	4
CRTSTATUS EQU	03c2h
CRTC	EQU	3d4h
CLEARVIDINT EQU	0cfh
SETVIDLATCH EQU 10h
INTSTATUS EQU	80h

SEGMENT seg386data
_tickcount	dd	0
LABEL	DefaultVREnd	word
VREndReg db	11h
VREndVal db	0
ENDS	seg386data

;
; the 16-bit register usage is deliberate in this code
;
SEGMENT	seg386
	assume	ds:nothing, es:nothing
;
; Video ISR which does nothing but increment a clock
;
PROC	_videoisr
	push	eax			; save regs
	push	edx
	mov	dx,CRTSTATUS		; See if really interrupted
	in	al,dx			;
	and	al,INTSTATUS
	jz	short noint		; Exit if not

	push	ds       		; Get system data seg
	assume	ds:dgroup
	mov	ax,DS386
	mov	ds,ax

	inc	[_tickcount]		; Increment tick counter

	mov	dx,CRTC			; Read CRT address reg so we
	in	al,dx                  ;   can restore it later
	push	eax			;

	mov	ax,[DefaultVREnd]       ; Get default video output
	and	ah,NOT SETVIDLATCH      ; but bring video latch low
	out	dx,ax			;

	push	eax			; Acknowledge the interrupt
	PICACK	PIC1ADR			;   while we are waiting
	PICACK
	pop     eax                     ;

	and	ah,CLEARVIDINT          ; Enable the interrupt again
	or	ah,SETVIDLATCH		; But bring video latch high
	out	dx,ax

	pop	eax			; Restore the CRT address reg
	out	dx,al			;
	pop	ds			; Restore the data seg
noint:
	pop	edx			; Restore wiped regs
	pop	eax			;
	iretd                           ; All done
ENDP	_videoisr
;
; call this to enable the ISR
;   Since we are not using BIOS the video interrupt does not get redirected
;   to int 0ah and we have to get it straight off the second controller,
;   second interrupt
;
PROC 	_visr_enable
	assume	ds:dgroup, fs:absdata
	ret
	cli
	PICREAD	1,PIC1ADR		; Enable ISR 9
	and	al,NOT VIDINT		; 
	PICWRITE 1,PIC1ADR		;
	PICREAD	1			; Enable ISR 2
	and	al,NOT CASCADE		;
	PICWRITE 1			;
	mov	dx,CRTC         ; Find out what CRTC address to use
	mov	al,[VREndReg]		; Get old contents of end reg
	out	dx,al			;
	inc	dl 			;
	in	al,dx                  ;
	mov	[VREndVal],al           ;

	dec	dl
	mov	ax,[DefaultVREnd]	; Enable the interrupt
	and	ah,CLEARVIDINT		; but bring latch low
	out	dx,ax			;
	IODELAY			; wait
	or	ah,SETVIDLATCH		; Bring latch high
 	out	dx,ax			;
	sti
	ret
ENDP	_visr_enable
;
; call this to disable it
;
PROC	_visr_disable
	assume	ds:dgroup
	cli
	mov	ax,[DefaultVREnd]	; Restore end reg to original value
	mov	dx,CRTC			;
;	out	dx,ax			;
	sti
	ret
ENDP	_visr_disable
ENDS	seg386

end
	