;
; These routines have not been extensively debugged
;
; Video.ASM
;
; Function : Provide CRT text-mode services
;   handle video mode OS calls
;   handle screen position and attributes
;   handle scrolling
;   handle rudimentary ASCII control codes
;   handle interaction with bios to keep state-smart
;   handle clearscreen
;
;   passes off most drawing functions to VGA.ASM if in graphics mode,
;      however VGA scrolling is done here
;
;   Assumes a VGA compatible color monitor (monochrome won't work)
;   Assumes Video mode 3 is selected

	IDEAL
	P386

include "segs.asi"
include "os.asi"
include "dispatch.ase"
include "video.asi"
include "beep.ase"
include "vgaini.ase"
include "prints.ase"

GCR = 3ceh
SEQUENCER = 3c4h
BLANKREG = 1
BLANKBIT = 20h
	PUBLIC	_videohandler, video_enable, video_disable, chars, lines, screenbase

SEGMENT	seg386data
screenbase	dd	0b8000h		; Screen base address
screenofs	dd	0		; Screen offset
					; Keep in sync with row & col
lines		db	DEFROWSPERSCREEN; Rows on the screen
chars		db	CHARSPERROW     ; characters on the screen
attrib		db	0		; Screen color
row		db	0		; Current row
col		db	0		; Current col
ENDS	seg386data

;
; Access BIOS data segment
;
SEGMENT absdata
	org	450h
curpos	dw	?			; Page 0 cursor position
	org	463h
crtc	dw	?
ENDS	absdata

SEGMENT	seg386
;
; Handler for OS VIDEO output
;
	assume ds:dgroup, es:nothing, fs:absdata, gs:nothing
;
; Routine initializes video subsystem by getting bios states
;
PROC	video_enable
	mov	bx,[curpos]		; Get BIOS cursor position
	call	SetCursorPos		; Make it our own
	mov	[attrib],0eh		; Set color to yellow on black
	ret
ENDP	video_enable
;
; Routine informs BIOS what we have done
;
PROC	video_disable
	call	GetCursorPos		; Get our cursor
	mov	[curpos],ax		; Make it the bios's
	ret
ENDP	video_disable
;
; Routine puts the hardware cursor in place
;
PROC	putcursor
	test	[theGraphicsMode],1
	jnz	short nocursor
	mov	dx,[crtc]		; Get CRTC
	mov	ebx,[screenofs]		; Get screenofs
	shr	ebx,1			; CP is in chars
	mov	al,0eh			; Cursor pos hi register 
	mov	ah,bh			; cursor pos hi byte
	out	dx,ax			; Out the high byte
	inc	al			; Cursor pos lo register
	mov	ah,bl			; cursor pos lo byte
	out	dx,ax			; out the lo byte
nocursor:
	ret
ENDP	putcursor
;
; Routine to output a character.  Also handles basic control functions
;
PROC	ochar
	cmp	al,' '			; See if control
	jc	oc_control		; Yes, go there
purechar:
	mov	ah,[attrib]		; Otherwise grab attrib
	test	[theGraphicsMode],1
	jnz	short ocharvga
	mov	ebx,[screenbase]	; Get screen position
	add	ebx,[screenofs]		;
	mov	[fs:ebx],ax             ; Put char on screen
	jmp	short pluscursor
ocharvga:
	mov	dl,al			; Char in dl
	mov	bl,ah			; Color in bx
	mov	bh,ah			;
	and	bh,0fh			;
	shr	bl,4			;
	movzx	eax,[row]		; Get row * 1280
	push	edx			;
	mov	cx,80*16		;
	mul	cx			;
	pop	edx			;
	movzx	edi,[col]		; + col
	add	edi,eax			; in edi
	call	SysTextChar		; Print char
pluscursor:
	cli				; Keep cursor update indivisible
	inc	[col]			; Next col
	add	[screenofs],2		;
	mov	al,[col]		; Jump to new line?
	cmp	al,[chars]		;
	jc	oc_done			; No, get out
	mov	[col],0			; Else mark it
	inc	[row]                   ; Next row
	mov	al,[row]		; Off Screen?
	cmp	al,[lines]              ;
	jc	oc_done			; no, get out
	sti				; Interrupts back on
	dec	[row]			; Else bump back
	movzx	eax,[chars]		;
	shl	eax,1			;
	sub	[screenofs],eax		;
	mov	bx,0			; scroll the screen up one line
	mov	ch,[lines]		;
	mov	cl,[chars]		;
	mov	al,1			;
	call	scrollup		;

oc_done:
	call	putcursor
	sti				; Interrupts back on
	clc
	ret
	
oc_control:     
	cmp	al,8
	jz	short oc_bkspc
	cmp	al,13			; CR?
	jz	short oc_cr		; yes - go handle it
	cmp	al,0ah			; LF?
	jz	short oc_linefeed	; yes - go handle it
	cmp	al,7
	jz	short oc_beep
	clc
	ret
oc_bkspc:
	movzx	eax,[col]		; See if at left
	or	eax,eax			;
	jz	short nobkspc		; Yes, no backspace
	dec	[col]			; Else decrement position
	sub	[screenofs],2		;
	call	putcursor		; Put the cursor
nobkspc:
	clc
	ret
oc_cr:
	movzx	eax,[col]		; for CR, just go back to start of line
	shl	eax,1			;
	sub	[screenofs],eax		;
	mov	[col],0			;
	call	putcursor		; Put the new cursor
	clc
	ret
oc_linefeed:
	movzx	eax,[col]               ; LF, put us at start of line
	shl	eax,1			;
	sub	[screenofs],eax         ;
	mov	al,[chars]              ; Now put us at last char of line
	dec	al			;
	mov	[col],al		;
	sub	ah,ah			;
	shl	eax,1                   ;
	add	[screenofs],eax         ;
	jmp	pluscursor              ; Now increment the cursor address
oc_beep:
	inc	[beepcount]
	clc
	ret
ENDP	ochar
;
; Routine outputs a null terminated string of text
;
PROC	outext
	mov	al,[gs:ebx]		; Get next char from user
	or	al,al			; See if done
	jz	notext			; yes - quit
	push	ebx			; Else save pointer
	call	ochar			; output one char
	pop	ebx			; Restore pointer
	inc	ebx			; point to next char
	jmp	outext			; get next char
notext:
	clc
	ret
ENDP	outext
;
; Routine sets the screen color
;
PROC	setattrib
	mov	[attrib],al		; Store screen color
	clc
	ret
ENDP	setattrib
;
; Routine returns the screen color
;
PROC	getattrib
	mov	al,[attrib]		; Grab screen color
	clc
	ret
ENDP	getattrib
;
; Set cursor position
;
PROC	setcursorpos
	cmp	bh,[lines]		; Can't set if out of range
	jnc	noset
	cmp	bl,[chars]
	jnc	noset
	mov	[row],bh		; Else set row & col
	mov	[col],bl		;
	mov	al,[chars]		; Calculate screen offset
	mul	bh			;
	sub	bh,bh			;
	add	ax,bx			;
	cwde				;
	shl	eax,1			; 2 bytes per char
	mov	[screenofs],eax		;
	call	putcursor
noset:
	clc
	ret
ENDP	setcursorpos
;
; Return cursor position
;
PROC	getcursorpos
	mov	ah,[row]		; Get cursor position
	mov	al,[col]		;
	clc
	ret
ENDP	getcursorpos
;
; Clear the screen
; 
PROC	clearscreen
	sub	ebx,ebx			; Home cursor
	mov	[row],bl		;
	mov	[col],bl		;
	mov	[screenofs],ebx		;
	call	SetCursorPos		;
	test	[theGraphicsMode],1
	jnz	short doVGA
	movzx	eax,[lines]		; Get length of screen in chars
	mul	[chars]			;
	mov	ecx,eax			;
	mov	edi,[screenbase]	; Get base address
	push	es			; ES = absdata
	push	fs			;
	pop	es			;
	mov	ah,[attrib]		; Get attrib and blank
	mov	al,' '			;
	cld				; Set dir
	rep	stosw			; Empty the screen
	pop	es			; Restore es
	clc
	ret
dovga:
	call	ClearVGA
	ret
ENDP	clearscreen
;
; Calculate scroll region parameters
;
PROC	scrollparms
	cmp	bl,cl			; First make sure the lower bounds
	jnc	sperr		; are actually lower
	cmp	bh,ch			;
	jnc	sperr		;
	cmp	bh,[lines]		; Now make sure we are on screen
	ja	sperr		;
	cmp	ch,[lines]		;
	ja	sperr		;
	cmp	bl,[chars]		;
	ja	sperr		;
	cmp	cl,[chars]		;
	ja	sperr		;
	mov	dl,ch                   ; Now get number of rows in region
	sub	dl,bh			;
	mov	dh,al                   ; dh gets rows to blank
	cmp	al,dl			; See if blanking entire region
	jc	short noclearall	; no, calculate rows to scroll
	mov	dh,dl			; yes, dh gets lines to blank
	sub	dl,dl			; no rows to scroll
	jmp	short cleared
noclearall:
	sub	dl,al			; dl gets rows to scroll
cleared:
	mul	[chars]			; Calculate offset between
	cwde				;   first row and row to move there
	test	[theGraphicsMode],1
	jz	short sp_text0
	shl	eax,3
sp_text0:
	shl	eax,1			;   = blank lines * chars/line * 2
	mov	esi,eax			;   in ESI
	mov	al,bh			; now calculate position of
	mul	[chars]			;   first char to overwrite
	cwde
	test	[theGraphicsMode],1
	jz	short sp_text1
	shl	eax,4
sp_text1:
	xchg	eax,ebx
	cbw
	cwde
	add	eax,ebx
	test	[theGraphicsMode],1	;
	jz	short sp_text2
	add	eax,0a0000h
	jmp	short sp_gotbase
sp_text2:
	shl	eax,1                   ;
	add	eax,[screenbase]        ; Add in the screen base
sp_gotbase:
	add	esi,eax                 ; Adjust the offset to the last line
	mov	edi,eax                 ; point to first char
	mov	al,cl                   ; now calculate characters/row *2
	sub	al,bl                   ;
	cbw                             ;
	cwde                            ;
	mov	ecx,eax                 ;   in cx
	test	[theGraphicsMode],1
	jz	short sp_text3
	shl	ecx,3
sp_text3:
	shl	ecx,1
	mov	al,[chars]              ; calculate offset between rows
	cbw                             ; = chars/row * 2
	cwde                            ;
	test	[theGraphicsMode],1
	jz	short sp_text4
	shl	eax,3
sp_text4:
	shl	eax,1                   ;
	mov	ebx,eax                 ;   in bx
	mov	al,' '                  ; ah,al = blank attrib/char
	mov	ah,[attrib]             ;
	clc
	cld
	ret
sperr:
	stc
	ret
ENDP	scrollparms
;
; Scroll a region up
;
PROC	scrollup
	call	scrollparms		; Get region parms
	jc	short noscrup		; quit if bad
	test	[theGraphicsMode],1
	jz	short scrup_novga
	push	eax
	push	edx
	mov	dx,GCR
	mov	ax,0105h
	out	dx,ax
	pop	edx
	pop	eax
scrup_novga:
	push	es			; save Sregs
	push	ds			;

	push	DSABS			; load ES,DS up with abs data
	push	DSABS
	pop	ds
	pop	es

	or	dl,dl			; See if any lines to scroll
	jz	short suc1		; branch if not
sul:
	push	esi			; else push scroll pointers
	push	edi			;
	push	ecx			;
	cld
	rep	movsb			; Do one line
	pop	ecx			; pop scroll pointers
	pop	edi			;
	pop	esi			;
	add	esi,ebx			; index to next line
	add	edi,ebx			;
	dec	dl			; See if done
	jnz	sul			; loop while not
suc1:
     	or	dh,dh			; See if any lines to blank
	jz	short suc2		; branch if not
sud:
	push	edi			; save scroll pointers
	push	ecx			;
	cld
	test	[theGraphicsMode],1
	jz	short suto_txt
	push	dx
	mov	ax,305h
	mov	dx,GCR
	out	dx,ax
	pop	dx
	sub	eax,eax
	rep	stosb			; blank out a line
	jmp	short suto_done
suto_txt:
	shr	ecx,1
	rep	stosw
suto_done:
	pop	ecx			; restore scroll pointers
	pop	edi			;
	add	edi,ebx			; index to next line
	dec	dh			; see if done
	jnz	sud			; loop while not
suc2:
	pop	ds			; restore Sregs
	pop	es			;
noscrup:
	test	[theGraphicsMode],1
	jz	short scrup_novga2
	mov	dx,GCR
	mov	ax,5h
	out	dx,ax
scrup_novga2:
	clc
	ret
ENDP	scrollup
PROC	scrolldown
	ret
	call	scrollparms
	jc	short noscrud
	push	eax
	xchg	esi,edi
	mov	al,dh
	add	al,dl
	dec	al
	mul	[chars]
	cwde
	add	edi,eax
	push	ebx
	movzx	ebx,[chars]
	sub	eax,ebx
	sub	eax,ebx
	pop	ebx
	add	esi,eax
	pop	eax
	push	es
	push	ds
	push	DSABS
	push	DSABS
	pop	ds
	pop	es
	cli
	or	dl,dl
	jz	short sdc1
sdl:
	push	esi
	push	edi
	push	ecx
	cld
	rep	movsb
	pop	ecx
	pop	edi
	pop	esi
	sub	esi,ebx
	sub	edi,ebx
	dec	dl
	jnz	sdl
sdc1:
	or	dh,dh
	jz	short sdc2
sdd:
	push	edi
	push	ecx
	cld
	rep	stosb
	pop	ecx
	pop	edi
	sub	edi,ebx
	dec	dh
	jnz	sdd
sdc2:
	sti
	pop	ds
	pop	es
noscrud:	
	clc
	ret
ENDP	scrolldown
;
; Blank the screen
;
PROC	BlankScreen
	mov	dx,SEQUENCER		; Accessing sequencer
	mov	al,BLANKREG		; Get blankout register
	out	dx,al			;
	inc	dx			;
	in	al,dx			; Read what is there
	or	al,BLANKBIT		; Add in the screen off bit
	out	dx,al			; Write it back
	ret
ENDP	BlankScreen
;
; Unblank the screen
;
PROC	UnBlankScreen
	mov	dx,SEQUENCER		; Accessing Sequencer
	mov	al,BLANKREG		; Get blankout register
	out	dx,al			;
	inc	dx			;
	in	al,dx			; Read what is there
	and	al,NOT BLANKBIT		; Get rid of screen off bit
	out	dx,al			; Write it back
	ret
ENDP	UnBlankScreen
;
; video dispatcher
;
PROC	_videohandler
	assume	ds:nothing,es:nothing
	push	ebx		; Push regs we want to save
	push	ecx		;
	push	edx		;
	push	edi		;
	push	esi		;
	push	gs		;
	push	fs		;
	push	ds
	push	es

	push	ds		; GS gets user data seg
	pop	gs		;
	push	DS386		; DS gets system code seg
	pop	ds		;
	push	DSABS		; FS gets absolute data seg
	pop	fs		;

	push	edx		; edx will appear in EAX to routines
	call	TableDispatch	; Dispatch the subroutine
	dd	13
	dd	ochar
	dd	purechar
	dd	outext
	dd	nofunction
	dd	nofunction
	dd	clearscreen
	dd	setattrib
	dd	setcursorpos
	dd	getattrib
	dd	getcursorpos
	dd	scrollup
	dd	scrolldown
	dd	blankscreen
	dd	unblankscreen

	pop	es
	pop	ds		; Pop all regs
	pop	fs		;
	pop	gs		;
	pop	esi		;
	pop	edi		;
	pop	edx		;
	pop	ecx		;
	pop	ebx		;
	ret			; Back to dispatcher
ENDP	_videohandler
ENDS	seg386
END