;
; Vga.asm
;
; Function: VGA graphics mode functionality
;   Handles text output to VGA subsystem
;
	IDEAL
	P386
LBLACK	= 7

include "segs.asi"
include "vga.asi"
include "vga.mac"

	PUBLIC _VertBar, _HorizBar, _FillCorner
	PUBLIC _DrawTextChar, _Underline
	PUBLIC _DrawWideChar, _DrawTallChar

SEGMENT	seg386data
	; These are specific to one black line
select	dw	0
right	db	2,6,0eh,1eh,3eh,7eh,0feh
left	db	07fh,7eh,7ch,78h,70h,60h,40h
ENDS	seg386data

SEGMENT	seg386
PROC	_HorizBar
	push	es
	GETGCR
	GETSEG
	WRMODE2
	add	edi,GRAPHBASE
	mov	al,bl
@@bllp2:
	PUTCOLOR
	LOOP	@@bllp2
	WRMODE0
	pop	es
	ret
ENDP	_HorizBar
PROC	_VertBar
	push	es
	GETGCR
	WRMODE2
	GETSEG
	add	edi,GRAPHBASE
	SETMASK	bh

	mov	al,bl

@@bllp2:
	PUTCOLOR	LATCH
	add	edi,79
	LOOP	@@bllp2
	SETMASK	0ffh
	WRMODE0
	pop	es
	ret
ENDP	_VertBar
PROC	_FillCorner
	push	es
	add	edi,GRAPHBASE
	mov	esi,offset right
	and	dl,0ffh
	test	dl,-1
	jz	@@right
	mov	esi,offset left
	add	esi,edx
@@right:
	GETGCR
	GETSEG
	WRMODE3
	SETCOLOR bl
	SETMASK	0ffh
@@lp:
	mov	al,[es:edi]
	movsb
	add	edi,79
	loop	@@lp
	WRMODE0
	pop	edi
	pop	esi
	pop	ebp
	ret
ENDP	_FillCorner

PROC	_DrawTextChar
	push	es
	GETGCR					; put is in write mode 3
	WRMODE3
	GETSEG
	add	edi,GRAPHBASE
	SETCOLOR bl
	PUTBG
	SETCOLOR bh
	mov	ecx,16
@@lp:
	movsb
	add	edi,79
	loop	@@lp

	WRMODE0
	pop	es
	ret
ENDP	_DrawTextChar
PROC	_DrawWideChar
	push	es
	GETGCR					; put is in write mode 3
	WRMODE3
	GETSEG
	add	edi,GRAPHBASE
	SETCOLOR bl
	PUTBG
	SETCOLOR bh
	mov	ebx,16
@@lp:
	push	ebx
	lodsb
	mov	ecx,8
@@lp1:
	shr	al,1
	pushf
	rcr	bx,1
	popf
	rcr	bx,1
	loop	@@lp1
	mov	al,bh
	stosb
	mov	al,bl
	stosb
	add	edi,78
	pop	ebx
	dec	ebx
	jnz	@@lp

	WRMODE0
	pop	es
	ret
ENDP	_DrawWideChar
PROC	_DrawTallChar
	push	es
	GETGCR					; put is in write mode 3
	WRMODE3
	GETSEG
	add	edi,GRAPHBASE
	SETCOLOR bl
	PUTBG
	SETCOLOR bh
	mov	ebx,16
@@lp:
	push	ebx
	lodsb
	mov	ecx,8
@@lp1:
	shr	al,1
	pushf
	rcr	bx,1
	popf
	rcr	bx,1
	loop	@@lp1
	mov	al,bh
	stosb
	mov	al,bl
	stosb
	add	edi,78
	mov	al,bh
	stosb
	mov	al,bl
	stosb
	add	edi,78
	pop	ebx
	dec	ebx
	jnz	@@lp

	WRMODE0
	pop	es
	ret
ENDP	_DrawTallChar
PROC	_Underline
	ret
ENDP	_Underline
;
ENDS	seg386

END