;
; traps.asm
;
; Function : Dynamic changing of trap vectors
;
;
	IDEAL
	P386

include "segs.asi"
include "descript.ase"
include "boot.ase"
include "gdt.asi"

	PUBLIC GetTrapVect, SetTrapVect
SEGMENT	seg386
PROC	GetTrapVect
	push	edi
	shl	edi,3
	add	edi,offset tIDT
	call	GetDescriptorType
	or	al,al
	jns	novector
	and	al,0fh
	cmp	al,ST_TRAPGATE
	jnz	novector
	call	GetGateOffset	
	mov	ebx,eax
	call	GetGateSelector
	mov	edx,eax
	sub	eax,eax
	clc
	pop	edi
	ret
novector:
	stc
	pop	edi
	ret
ENDP	GetTrapVect
PROC	SetTrapVect
	push	edi
	shl	edi,3
	add	edi,offset tIDT
	mov	[edi + GATEDESC.TYPE],DT_PRESENT OR DT_DPL3 OR ST_TRAPGATE
	mov	[edi + GATEDESC.COUNT],0
	mov	eax,edx
	call	SetGateSelector
	mov	eax,ebx
	call	SetGateOffset
	sub	eax,eax
	pop	edi
	ret
ENDP	SetTrapVect
ENDS	seg386
END