;
; Timer.asm
;
; Function: Timed interrupt functions come through here
;   Handles keeping BIOS up to date
;   Handles high-speed (72.8Hz) interrupts
;
	IDEAL              
	P386

include "sys.mac"
include "segs.asi"

include "pic.asi"
include "ints.asi"
include "ints.ase"
include "tss.ase"
include "beep.ase"
include "kb.ase"
include "floppy.ase"
include "mouse.ase"
include "iodelay.asi"

	PUBLIC	_timerenable, _timerdisable, _timerisr, _tickcount
TIMER0CTL = 34h
TIMERCTLPORT = 43h
TIMER0DATAPORT = 40h

SEGMENT	seg386data
_tickcount dd	0	; Total number of ticks
ENDS	seg386data

segment absdata
	org	46ch
biosticks dd	?
biosoverrun db	?
ENDS	absdata
SEGMENT	seg386
;
; Interrupt subroutine
;
PROC	_timerisr
	push	eax	; Save regs
	push	ds
	push	DS386	; Switch to OS data
	pop	ds
	inc	[_tickcount]	; Int tickcount
	test	[_tickcount],3	; Every fourth tick call BIOS
	jnz	short noreal		;
	call	kb_timer	; Resend if kb timeout
	call	beepint		; Do any beeps
	call	floppyTimerInt	; Handle floppy timeouts
	call	MouseIntr	; Mouse interrupt
	push	fs
	push	dsabs
	pop	fs
	inc	[biosticks]
	cmp	[biosticks],1800b0h
	jc	short nooverrun
	inc	[biosoverrun]
	mov	[biosticks],0
nooverrun:
	pop	fs
noreal:
	PICACK			; Acknowledge int if not calling BIOS
quit:
	call	TaskSwitch
	pop	ds
	pop	eax
	iretd
ENDP	_timerisr
;
; Set the speed of the interrupt timer
;
PROC	_timerintinit
	push	eax
	mov	al,34h		; Select timer 0
	out	TIMERCTLPORT,al	;
	pop	eax
	out	TIMER0DATAPORT,al	; Put out low byte of speed
	IODELAY
	mov	al,ah
	out	TIMER0DATAPORT,al	; Put out hi byte of speed
	ret
ENDP	_timerintinit
;
; Set high freq timer (72.8 Hz)
;
PROC	_timerenable
	mov	ax,4000h     		; Multiply timer freq by 4 (10000 / 4000)
	call	_timerintinit		; Init it
	ret
ENDP	_timerenable
;
; Set lo freq timer (18.2 Hz)
;
PROC	_timerdisable
	pushfd				; Set interrupts
	sti
lp1:
	test	[_tickcount],3		; Wait till odd count
	jz	lp1
lp2:
	test	[_tickcount],3		; Wait till even count
	jnz	lp2
	popfd
	mov	ax,0			; Multiply timer freq by 1 (10000 / 10000)
	call	_timerintinit
	ret
ENDP	_timerdisable
ENDS	seg386
END