;
; Sems.asm
;
; Function: Waiting tasks on semaphores
;
	IDEAL
	P386

include "segs.asi"
include "os.asi"
include "descript.ase"
include "page.asi"
include "tss.asi"
include "sems.asi"
include "sys.mac"
include "boot.ase"

	PUBLIC	WaitSem, UnwaitSem, SemBlock

SEGMENT	seg386
;
; Set to wait on a semaphore
;
PROC	WaitSem
	str	ax			; Get task TSS
	call	DescriptorAddress	;
	call	GetDescriptorBase	;
	ZA	edi			;
	mov	[edi + TSS.RESOURCE] , ebx	; Bool to wait on
	mov	[edi + TSS.STATE],SEM_WAITRUE	; Wait condition
	ret
ENDP	WaitSem
;
; Stop waiting on a semaphore
;
PROC	UnwaitSem
	str	ax			; Get task TSS
	call	DescriptorAddress	;
	call	GetDescriptorBase	;
	ZA	edi			;
	mov	[edi + TSS.STATE], SEM_NOWAIT ; No waiting
	ret
ENDP	UnwaitSem
;
; Block if a resource in use
;
SBP_RESOURCE = ebp + 8
PROC	SemBlock
	ENTER	0,0
	push	eax			; Save regs
	push	ebx			;
	push	edi			;
	mov	ebx,[SBP_RESOURCE]	; Get resource
chkblock:
	btr	[dword ptr ebx],0	; Mark resource in use and get old state
	jc	short blocked		; Get out if blocked
	call	WaitSem			; Else set up to wait on sem
	os	TA_PAUSE		; Return to task handler
	jmp	chkblock		;
blocked:
	pop	edi			; Restore regs
	pop	ebx			;
	pop	eax			;
	leave
	ret	04
ENDP	SemBlock	

	
ENDS	seg386
END