;
; Pageall.asm
;
; Function: Allocate/deallocate a page of physical memory
;   Handles managing the page allocation map
;   Handles counting base memory
;
	IDEAL
	P386

include "segs.asi"
include "sys.mac"
include "ints.asi"
include "os.asi"
include "ints.ase"
include "page.asi"
include "page.ase"
include "pageall.asi"
include "boot.ase"
include "prints.ase"

	PUBLIC	PageAllocInit,PageAlloc,PageDealloc, CountBaseMem
	PUBLIC memmap
SEGMENT seg386data
memmap	db	PG_MB * (PG_MEMSIZE SHR 12) / 8 / PG_MBPERTABLE DUP (0) ; Map of used pages
ENDS	seg386data

SEGMENT	seg386
;
; Count amount of base memory available
;
PROC	CountBaseMem
	sub	edx,edx			; Count = 0
	mov	esi,offset memmap	; Get memory map and count
	mov	ecx,(PG_STARTOFEXTMEM SHR PG_SHIFTSIZE) / 8 / PG_MBPERTABLE
cblp:
	lodsd				; Get 32 bits
	push	ecx			; Set to count through these
	mov	ecx,32			;
cblp2:
	shr	eax,1			; This bit set?
	jnc	short nobit		; No, continue
	inc	edx			; Yes, inc count
nobit:
	loop	cblp2			; Loop through 32 bits
	pop	ecx			;
	loop	cblp			; Loop through lower 1MB
	ret
ENDP	CountBaseMem
;
; Alocate a page
;   entry: ax = TRUE do system pages as well
;   exit : ax = page address
;
PROC	PageAlloc
	push	esi
	push	ecx
	push	ebx
	mov	esi,offset memmap - 4	; Start at beginning
	mov	ecx,PG_MB * (PG_MEMSIZE SHR PG_SHIFTSIZE) / 8 /PG_MBPERTABLE / 4
	or	al,al			; If NZ
	jnz	short anymem			; search lower 640K first
	add	esi,(PG_STARTOFEXTMEM SHR PG_SHIFTSIZE) / 8	; Else only search ext
	sub	ecx,(PG_STARTOFEXTMEM SHR PG_SHIFTSIZE) / 8 / PG_MBPERTABLE
anymem:
	add	esi,4			; Next word
	bsf	eax,[dword ptr esi]	; See if any bits set
	loopz	anymem			; Loop while not
	or	ecx,ecx			; Quit if nothing found
	jz	short notfound		;
	btr	[esi],eax		; Else reset the bit
	sub	esi,offset memmap	; Find the dword address
	mov	ebx,esi			; Make it a relative bit #
	shl	ebx,3			; ebx is 32 * WORD #			;
	add	eax,ebx			; Add the bit within the word
	shl	eax,PG_SHIFTSIZE	; Make it  an address
	clc
	pop	ebx
	pop	ecx
	pop	esi
	ret
notfound:
	pop	ebx
	pop	ecx	
	pop	esi
	sub	eax,eax 		; Nothing found
	stc
	ret		
ENDP	PageAlloc
;
; Deallocate a page
;
PROC	PageDealloc
	shr	eax,PG_SHIFTSIZE	; Get the page number
	bts	[dword ptr memmap],eax	; Set the bit of this page
	ret				; Done
ENDP	PageDealloc
;
; Initialize the page alloc scheme
;
PROC	PageAllocInit
	mov	eax,offset dgroup:eom	; Get end of program space
	add	eax,[zero]		; Make absolute
	add	eax,PG_SIZE -1		; Index to next whole page
	shr	eax,PG_SHIFTSIZE	; Make it a page address
	shl	eax,PG_SHIFTSIZE	;
$$lp:
	cmp	eax,PT_SYSTEMDIR	; Quit when we hit system page dir
	jz	short $$dn2		;
	push	eax			; Else dealloc the page
	call	PageDealloc		;
	pop	eax			;
	add	eax,PG_SIZE		; Next page
	jmp	$$lp			; Loop
$$dn2:
	mov	ecx,[mempages]		; Now get number of ext pages
	mov	eax,PG_STARTOFEXTMEM	; Get address of ext pages
$$lp3:
	push	eax			;Dealloc the page
	call	PageDealloc		;
	pop	eax			;
	add	eax,PG_SIZE		; Next page
	loop	$$lp3			; Continue till done
	ret
ENDP	PageAllocInit
ENDS	seg386
end