;
; Misc.asm
;
; Function: Miscellaneous OS functions
;

	IDEAL
	P386

include "segs.asi"
include "os.asi"
include	"vidisr.ase"
include "dispatch.ase"
include	"cmos.ase"
include "boot.asi"

	PUBLIC	_mischandler
TIMER_MUL = 10000
TIMER_DIV = 728

SEGMENT	seg386
;
; Handles miscellaneous OS functions
;
PROC	GetVersion
	mov	al,VERID / 100
	mov	ah,VERID MOD 100
	ret
ENDP	GetVersion
PROC	toms
	push	edx
	push	ecx
	mov	ecx,TIMER_MUL
	mul	ecx
	mov	ecx,TIMER_DIV
	idiv	ecx
	pop	ecx
	pop	edx
	clc
	ret
ENDP	toms
PROC	fromms
	push	edx
	push	ecx
	mov	ecx,TIMER_DIV
	mul	ecx
	mov	ecx,TIMER_MUL
	idiv	ecx
	pop	ecx
	pop	edx
	clc
	ret
ENDP	fromms
PROC	reticks
	mov	eax,[_tickcount]
	clc
	ret
ENDP	reticks
PROC	EnableWatchDog
	ret
ENDP	EnableWatchDog
PROC	DisableWatchDog
	cmp	ebx,WATCHDOGVERIFY
	jnz	short nodisable
nodisable:
	ret
ENDP	DisableWatchDog
PROC	KickWatchDog
	ret
ENDP	KickWatchDog
PROC	_mischandler
	assume	ds:nothing,es:nothing
	push	ds
	push	ds386
	pop	ds
	push	edx
	call	TableDispatch
	dd	11
	dd	reticks
	dd	reticks
	dd	toms
	dd	fromms
	dd	SetDate
	dd	GetDate
	dd	SetTime
	dd	GetTime
	dd	EnableWatchDog
	dd	DisableWatchDog
	dd	KickWatchDog
	dd	GetVersion
	pop	ds
	ret
ENDP	_mischandler
ENDS	seg386
END