;
; Pause does not work
;
;
; KB.ASM
;
; Function: low level keyboard driver
;   Handles keyboard interrupt
;   Handles translation: we do NOT return BIOS scan codes!!!
;   Handles LEDs
;   Handles KB OS calls
;
	IDEAL
	P386

include "segs.asi"
include "os.asi"
include "pic.asi"
include "dispatch.ase"
include "prints.ase"
include "tss.ase"
include "boot.ase"
include "kb.asi"
include "beep.ase"
include "prints.ase"
include "iodelay.asi"

;
; States for LED update
;
NOLEDCOM = 0	; no command in progress
WAITACK1 = 1	; Waiting for ack from the set led command
GOTACK1 = 2	; Got it
WAITACK2 = 3	; Waiting for ack from the led status byte
GOTACK2 = 4	; got it

MAXTIMEOUT = 3	; Clock ticks before led command resend
MAXREPEAT = 4	; Number of tries to resend before error

	PUBLIC	_kbhandler, kbint, kb_enable, kb_disable, kb_timer

SEGMENT seg386data
ifdef	PAUSE
pausing	dd	0
endif
buffer	dd	KB_BUFMAX DUP (0)	; keyboard buffer
bufptr	dd	0			; Index to keyboard
capslockable db	0,0, 0ffh,0f3h, 0feh,0fh, 0e0h,0, 0,0	; Indicate which
					; keys are affected by caps lock
kbstatus dd	0			; Current status bits
ledstatus db	0			; Current led output bits
kbresend db	0                       ; Non-zero if command sent
kbtimeout db	0			; Number of interrupts before timeout
kbcommand db	0			; Command to send on timeout
ledstate db	0			; State of LED output command

;
; keytable for unshifted keys
;
normtab	db	0, 1bh,"1234567890-=",8,9
	db	"qwertyuiop[]",0dh,0,"as"
	db	"dfghjkl;'`",0,"\zxcv"
	db	"bnm,./",0,"*",0," ",0,81h,82h,83h,84h,85h
	db	86h,87h,88h,89h,8ah,0,0,"789-456+1"
	db	"230",9dh,0,0,0,8bh,8ch
;
; Key table for shifted keys
;
shiftab	db	0, 1bh,"!@#$%^&*()_+",8,9
	db	"QWERTYUIOP{}",0dh,0,"AS"
	db	"DFGHJKL:",022h,"~",0,"|ZXCV"
	db	"BNM<>?",0,09ch,0," ",0,81h,82h,83h,84h,85h
	db	86h,87h,88h,89h,8ah,0,0,97h,98h,99h,09ah,94h,95h,96h,9bh,91h
	db	92h,93h,90h,9ch,0,0,0,8bh,8ch
;
; Key table for control keys
;
ctrltab	db	0, 1bh,0,0,0,0,0,1eh,0,0,0,0,1fh,0,8,9
	db	11h,17h,05h,12h,14h,19h,15h,09h,0fh,10h,1bh,1dh,0dh,0,01h,13h
	db	04h,06h,07h,08h,0ah,0bh,0ch,0,0,0,0,1ch,1ah,18h,03h,16h
	db	02h,0eh,0dh,0,0,0,0,0,0,0,0,81h,82h,83h,84h,85h
	db	86h,87h,88h,89h,8ah,0,0,0,0,0,0,0,0,0,0,0
	db	0,0,0,9dh,0,0,0,8bh,8ch
ENDS	seg386data

;
; Access the BIOS data space
;
SEGMENT absdata
	org	417h
kbshift	db	?		; BIOS shift flags
	org	497h
kbleds	db	?		; BIOS LED flags
ENDS	absdata
SEGMENT	seg386
;
; Grab bios LED states and make them ours
;
PROC	kb_enable
	mov	ah,[kbleds]	; Get LED states
	and	ah,7		;
	mov	[ledstatus],ah  ; Ours
	sub	al,al		;
	cwde			;
	shl	eax,8		; Convert to status bits
	mov	[kbstatus],eax	;
	ret
ENDP	kb_enable
;
; Make our LED states the bios's
;
PROC	kb_disable
	mov	eax,[kbstatus]	; Get status
	shr	eax,8		; Get lock flags
	and	ah,7		;
;
; WE're going to let the bios update the leds just in case
;
	shl	ah,4		;
	and	[kbshift], NOT 70h; But tell it shift states
	or	[kbshift],ah	;
	ret
ENDP	kb_disable
PROC	kb_timer
	test	[kbresend],-1	; See if command in progress
	jz	short ktdone	; No, quit
	test	[kbtimeout],-1	; Else see if timeout is done
	jz	short uptimeout	;
	dec	[kbtimeout]	; No, dec it
	jmp	short ktdone	; and get out
uptimeout:
	mov	[kbtimeout],MAXTIMEOUT	; Else put it back up
ocommand:
	dec	[kbresend]	; Dec resend count
	jnz	short sendchar	; Send the control command if not dead
	mov	al,KBC_ERROR	; Else send an error
	mov	[ledstate],0	;
	jmp	short	sendit	;
sendchar:
	mov	al,[kbcommand]  ; Get command
sendit:
	call	writekey	; Write it
ktdone:
	ret
ENDP	kb_timer
;
; Put something in keyboard buffer
;
PROC	statustobuffer
	sub	al,al		; Assume 0
chartobuffer:
	mov	ebx,[bufptr]	; Get buf ptr
	cmp	ebx,KB_BUFMAX * 4	; See if full
	jnc	short lostchar	; Beep if so
	sub	ah,ah		; Else or in the status flags
	cwde			;
	or	eax,[kbstatus]	;
	mov	[ebx + buffer],eax ;put in buffer
	add	[bufptr],4	;
	ret
lostchar:
	bt	[kbstatus],KBS_BREAK
	jc	nobeep
	or	al,al
	jz	nobeep
       	inc	[beepcount]
nobeep:
	ret
ENDP	statustobuffer
;
; Get something from keyboard buffer
;
PROC	charfrombuffer
	mov	ecx,[bufptr]	; Get buf ptr
	or	ecx,ecx		; Quit if nothing there
	jz	short nokeys	;
	push	es		; Save regs
	push	esi		;
	push	edi		;
	push	ecx		;
	pushfd			; No interrupts
	push	ds		;
	pop	es		;
	cli			;
	mov	eax,[buffer]	; Get char from buffer
	sub	ecx,4		; Dec buf count
	mov	[bufptr],ecx	;
	or	ecx,ecx		; Quit if nothing left
	jz	noneleft	;

	mov	esi,offset buffer + 4 ; Else shift everything down
	mov	edi,offset buffer;
	shr	ecx,2		;
	cld
	rep	movsd		;
noneleft:
	popfd
	pop	ecx		; Restore regs
	pop	edi		;
	pop	esi		;
	pop	es		;
	clc			; Success
	ret
nokeys:     
	stc			; Failure
	ret			;
ENDP	charfrombuffer
;
; UPDATE the LEDs
;
PROC	updateleds
	push	eax		; See if anything changed
	mov	eax,[kbstatus]	;
	shr	eax,8		;
	xor	ah,[ledstatus]	;
	and	ah,7		;
	jz	nosend		; no -exit
	mov	al,[ledstate]	; See if command in progress
	or	al,al		;
	jnz	short	chkack1 ; Yes, see where
	mov	al,KBC_SETLED	; Else send command byte
	mov	[ledstate],WAITACK1	; And mark command in progress
	jmp	short	bytetosend	;
chkack1:
	cmp	[ledstate],GOTACK1	; See if got acked for command
	jnz	short chkack2		;
	mov	eax,[kbstatus]		; Yes, get new LED state
	shr	eax,16			;
	and	al,7			;
	mov	[ledstate],WAITACK2	; And mark waiting for ack
	jmp	short bytetosend	;
chkack2:
	cmp	[ledstate],GOTACK2	; See if acked for LED state
	jnz	short nosend		; no, exit
ok:
	mov	eax,[kbstatus]		; Else set led status
	shr	eax,8			;
	and	ah,7			;
	mov	[ledstatus],ah		;
	mov	[ledstate],0		; Mark done
	mov	[kbresend],0		; Kill timer intr
	jmp	short nosend		;
bytetosend:
	pushfd
	cli                             ;
	mov	[kbcommand],al		; set command
	mov	[kbresend],MAXREPEAT	; Set max repeats
	mov	[kbtimeout],MAXTIMEOUT	; set timeouts
	call	writekey		; write command
	popfd
nosend:
	pop	eax			; Restore ax and exit
	ret
ENDP	updateleds
;
; See if is a shift key
;
PROC	ishift
	cmp	al,LSHIFT		; Left shift?
	jnz	short chrs		;
	mov	al,KBS_LSHIFT		; Yes, get flag
	jmp	short mkbrksh		;
chrs:
	cmp	al,RSHIFT		; Right shift?
	jnz	short chalt		;
	mov	al,KBS_RSHIFT		; yes, get flag
	jmp	short mkbrksh		;
chalt:
	cmp	al,ALT			; Alt?
	jnz	short chctrl		;
	bt	[kbstatus],KBS_PREFIXED	; Yes, check if prefixed
	jnc	short altright		;
	mov	al,KBS_LALT		; Alt left if not
	jmp	short mkbrksh		;
altright:
	mov	al,KBS_RALT		; Else alt right
	jmp	short mkbrksh		;
chctrl:
	cmp	al,CTRL			; CTRL?
	jnz	short chlocks		;
	bt	[kbstatus],KBS_PREFIXED	; Yes, check prefix
	jnc	short ctrlright		;
	mov	al,KBS_LCTRL		; Left if none
	jmp	short mkbrksh		;
ctrlright:
	mov	al,KBS_RCTRL		; CTRL-right if one
	jmp	short mkbrksh
chlocks:
	bt	[kbstatus],KBS_BREAK	; See if break is set
	jnc	short isdone		; no, toggle locks only on break code
	cmp	al,CAPSLOCK		; yes, see if it is capslock break
	jnz	chnum			;
	mov	al,KBS_CAPS		; yes, get caps flag
	jmp	short	togsh		;
chnum:
	cmp	al,NUMLOCK		; Numlock?
	jnz	short chscroll		;
	mov	al,KBS_NUM              ; Yes, get flag
	jmp	short togsh		;
chscroll:
	cmp	al,SCROLLOCK		; Scroll lock?
	jnz	short isdone		;
	mov	al,KBS_SCROLL		; yes, get flag
	jmp	short togsh		;
	
mkbrksh:
	cbw				; Convert code to dword
	cwde				;
	bt	[kbstatus],KBS_BREAK	; If it is break we turn it off
	jc	short isbreak		; 
	bts	[kbstatus],eax          ; Else turn it on
	call	statustobuffer		; Put a zero in the buffer
	clc				; Finished with code found
	ret				;
isbreak:
	btr	[kbstatus],eax		; turn offf the bit
	call	statustobuffer		; put a zero in the buffer
	clc				; finished with code found
	ret
togsh:
	sub	ecx,ecx			; ECX will get bit for toggle
	cbw				; make EAX a dword
	cwde				;
	bts	ecx,eax			; Set ECX
	xor	[kbstatus],ecx		; XOR the bit
	call	updateleds		; update the leds
	call	statustobuffer		; put a zero in the buffer
	clc				;
	ret
isdone:
IFDEF	CTRLALTDEL
	cmp	al,DEL			; Nothing found, check delete
	jnz	finaldone		; quit if not
	test	[kbstatus],KBS_CTRL	; Else see if we have both ctrl & alt
	jz	short finaldone		;
	test	[kbstatus],KBS_ALT	;
	jz	short finaldone		;
	cli				; Yes, clean up
	PICACK				;
	call	ackkey			;
	jmp	_exit			; And hit the exit routine
					; note multitasking already disabled
					; at this point
finaldone:
ENDIF
	stc				; Didn't find anything
	ret
ENDP	ishift
;
; Translate key code to ASCII
;
PROC	xlate
	test	[kbstatus],KBS_CTRL	; CTRL in effet?
	jnz	short xlatcontrol	; yes, xlate on control table
fullxlat:
	mov	ebx,offset shiftab	; else get shift
	mov	ecx,offset normtab	; and normal tables
	cmp	al,KEYPAD		; See if on keypad
	jnc	short xlatkeypad	; branch if so
	bt	[kbstatus],KBS_CAPS	; See if capslock
	jnc	nocapslock		; no, continue
	sub	ah,ah			; else test if capslockable
	bt	[word ptr capslockable],ax	;
	jnb	nocapslock		; no, continue
	xchg	ebx,ecx			; get normal table
nocapslock:
	test	[kbstatus],KBS_SHIFT	; check shift key
	jnz	short doxlat		; no, just xlate
	mov	ebx,ecx			; else get shift table
	jmp	short doxlat		; go xlate
xlatkeypad:
	bt	[kbstatus],KBS_PREFIXED	; keypad key, see if prefixed
	jc	doxlat			; just xlate it if so
	bt	[kbstatus],KBS_NUM	; See numlock
	jnc	doxlat			; xlate it if not
	mov	ebx,ecx			; Get normal table
doxlat:
	xlat                    	; Xlate
	call	chartobuffer		; Put in buffer
	ret
xlatcontrol:
	push	eax			; xlate control, save ax
	mov	ebx,offset ctrltab	; Get control tab
	xlat				; xlate
	or	al,al			; if zero
	jnz	transfer		;
	pop	eax                     ; Do a fuller translation
	jmp	fullxlat		;
transfer:
	call	chartobuffer            ; else just put char in buffer
	pop	eax			;
	ret
ENDP	xlate
;
; Keyboard interrupt
;
PROC	kbint
	push	eax			; save regs
	push	ebx			;
	push	ecx			;
	push	ds			;
	push	DS386			; Get system seg
	pop	ds			;
	inc	[canmultitask]		; Turn off multitasking
	call	readkey			; Get key value
	cmp	al,KBR_PUP1		; See if power-up
	jnz	short nopup		;
    	mov	[ledstatus],0		; PUP, pretend leds never sent
	call	updateleds		; Now update leds
	jmp	short ack2		; And get out
nopup:
	cmp	al,KBR_ACK		; See if ack
	jnz	short testpause		; check pause if not
	test	[ledstate],-1		; Check if updating leds
	jz	short ack2		; quit if not
	inc	[ledstate]		; Else mark acknowledge
	call	updateleds		; Update leds
	jmp	short ack2		; quit
testpause:
	cmp	al,PAUSEPREFIX		; Is the pause prefix?
ifdef	PAUSE
	jz	short dopause		; Do pause if so
	mov	[byte ptr pausing],0	; Clear pause mode
else
	jz	ack			; or Ignore if no pause support
endif
	cmp	al,PREFIX		; Is the normal prefix
	jnz	short testkey		; No, go test key
	bts	[kbstatus],KBS_PREFIXED	; Else set the prefix bit
	jmp	short ack		; Get out
testkey:
	
	btr	[kbstatus],KBS_BREAK	; Clear the break code bit
	or	al,al			; See if is break code
	jns	short nobreak		;
	bts	[kbstatus],KBS_BREAK	; Yes, set the bit
nobreak:
	call	updateleds		; Update leds
	and	al,7fh			; Get rid of break code bit
	call	ishift			; Check if is shift
	jnc	short ack2		; Get out if so
	call	xlate			; Translate key
ack2:
	btr	[kbstatus],KBS_PREFIXED	; Clear the prefixed bit
ack:
	call	ackkey			; Acknowledge the key
	PICACK				; Acknowledge the interrupt
done:
	dec	[canmultitask]		; Enable multitasking
	pop	ds			; Restore regs
	pop	ecx			;
	pop	ebx			;
	pop	eax			;
	iretd				; Get out
ifdef	PAUSE
dopause:
	mov	ecx,5			; Five trailing chars for pause
dpl:
	push	ecx			; Read them all
	call	readkey			;
	pop	ecx			;
	loop	dpl			;
	call	ackkey			; Turn on keyboard
	PICACK				; Acknowledge interrupt
	inc	[byte ptr pausing]		; Enable pausing
dpw:
	test	[byte ptr pausing],-1	; Wait till pause done
	jnz	short dpw		;
	jmp	done			; Exit
ENDIF
ENDP	kbint
;
; Write a value to the keyboard
;
PROC	writekey
	push	ecx			; Save ECX throughout
	mov	ah,al  			;
	call	waitinp 		; Wait for ready
	mov	al,ah			;
	out     KB_DATAPORT,al		; Write the value
	pop	ecx			;
	ret
ENDP	writekey
;
; Read a value from the keyboard
;
PROC	readkey
	call	waitinp			; Wait for ready
	mov	al,KBC_DISABLE		; Send read command
	out	KB_COMMANDPORT,al	;
	call	waitinp			; Wait for ready
	in	al,KB_DATAPORT		; Get key
	ret
ENDP	readkey
;
; Acknowledge key
;
PROC	ackkey
	call	waitinp			; Wait for ready
	mov	al,KBC_ENABLE		; Send acknowledge command
	out	KB_COMMANDPORT,al	;
	sti
	ret
ENDP	ackkey
;
; Wait for ready
;
PROC	waitinp
	cli
	mov	ecx,100000h		; Loop this long
wi1:
	IODELAY
	in	al,KB_COMMANDPORT	; Read status
	test	al,2			; Test ready bit
	loopnz	wi1			; loop while not
	ret
ENDP	waitinp
;
; Get a character function
;
PROC	getachar
	call	getextchar		; Get char from buffer
	or	al,al			; ignore if shift code
	jz	short getachar		;
	bt	eax,KBS_BREAK		; Ignore if break code
	jc	short getachar		;
	ret
ENDP	getachar
;
; Get extended char function
;
PROC	getextchar
	call	charfrombuffer		; Get a char
	jnc	gotchar			; Quit if got
	os	TA_PAUSE		; Otherwise wait
	jmp	getextchar		;
gotchar:
	ret
ENDP	getextchar
;
; Get keyboard ready status
;
PROC	getstatus
	sub	eax,eax
	mov	ecx,[bufptr]		; ANything in buffer?
	shr	ecx,2			;
	jecxz	gs_none
	sub	ebx,ebx			;
gs_lp:
	bt	[dword ptr ebx + buffer],KBS_BREAK; See if is break code
	jc	short incbreak		; Yes, inc break count
	inc	al			; Else inc make count
	jmp	short gs_test		; Go to loop
incbreak:
	inc	ah			; Inc break count
gs_test:
	add	ebx,4			; Next key
	loop	gs_lp
gs_none:
	ret
ENDP	getstatus
;
; KB handler
;
PROC	_kbhandler
	assume	ds:nothing,es:nothing
	push	ebx			; save regs
	push	ecx			;
	push	ds			;
	push	fs			;

	push	DS386			; DS gets system data seg
	pop	ds
	push	DSABS			; FS gets absolute seg
	pop	fs
	
	push	0			; ax gets 0 on function start
	call	TableDispatch		; Dispatch the function
	dd	2	
	dd	getachar
	dd	getextchar
	dd	getstatus

	pop	fs      		; Restore regs
	pop	ds			;
	pop	ecx			;
	pop	ebx			;
	ret
ENDP	_kbhandler
ENDS	seg386
END