;
; Not tested for LARGE files
;
;
; Files.asm
;
; Function: files support for the file system
;   Handles allocating, deallocating space from file space pages
;   Limits files to about 24MB
;   Handles OS file system calls
;
	IDEAL
	P386

include "page.asi"
include "os.asi"
include "errors.asi"
include "segs.asi"
include "floppy.asi"
include "fs.asi"
include "cmos.asi"
include "buffers.ase"
include "sys.mac"
include "descript.ase"
include "dirs.ase"
include "fs.ase"
include "cmos.ase"
include "remaps.ase"
include "dispatch.ase"
include "buffers.ase"
include "boot.ase"
include "sems.ase"

	PUBLIC	FileHandler, ClearFCBs
TRUE = 1
FALSE = 0
SEGMENT seg386data
	EXTRN	LastError : DWORD
fcbstart dd	BUFFEROFFSET * BUFFERCOUNT + PG_STARTOFEXTMEM
SemFile	dd	1
ENDS	seg386data

SEGMENT	seg386
;
; Initialize FCBs to the empty state
;
PROC	ClearFCBs
	push	ecx			;
	mov	ecx,NUMFCBs		; Number of FCBs
	mov	edi,[fcbstart]		; Adjust FCB start to segment
	ZA	edi			;
	mov	[fcbstart],edi		;
cfcb_next:
	mov	[edi + FCB.PAGE],0	; Set page to 0
	add	edi,FCBSIZE		; Next FCB
	loop	cfcb_next		; Loop till done
	pop	ecx			;
	ret
ENDP	ClearFCBs
;
; Compress time
;   Month : 4
;   Day : 5
;   Year MOD 128: 7
;   Hour : 5
;   Min : 6
;   Seconds/2 : 5
;
PROC	CompressTime
	push	ebx			; Save regs
	push	ecx			;
	call	GetDate			; Get date
	sub	eax,eax			;
	mov	al,bh			; EAX = month : 4
	shl	eax,5			;
	or	al,bl			; OR day : 5
	shl	eax,7                   ; Or Year : 7
	sub	ecx,YEARBIAS		;
	and	cl,07fh			;
	or	al,cl                   ;
	push	eax			;
	call	GetTime			; Get time
	pop	eax			;
	shl	eax,5			; Or hours : 5
	or	al,bh			;
	shl	eax,6			; OR Mins : 6
	or	al,bl			;
	shr	cl,1			; OR Seconds : 5
	shl	eax,5			;
	or	al,cl			;
	pop	ecx			; Restore regs
	pop	ebx			;
	ret
ENDP	CompressTime
;
; Move file name to stack
;
PROC	MoveNameToStack
	push	ds			; Get user data seg
	push	fs			;
	pop	ds			;
	cmp	[byte ptr 2 +esi],':'	; Have a drive spec?
	jne	mns_go			; No, go
	mov	al,[esi]		; Get Drive spec
	and	al,NOT 20h		; Make LC
	sub	al,'A'			; Convert to int
	cmp	al,NUMDRIVES		; Quit if in range
	jnc	short mns_go		;
	inc	esi                     ; Update ptr past drive spec
	inc	esi			;
	sub	ah,ah			;
	cwd				;
	mov	ebx,eax			; Select drive
mns_go:
	mov	ecx,FILENAMELEN		; Length of name
mns_mvlp:
	lodsb				; Get a char
	or	al,al			; If zero, go do padding
	jz	short mns_fill		;
	stosb				; Else save char
	loop	mns_mvlp		; Loop
	pop	ds			; Restore user data seg
	ret
mns_fill:
	mov	al,' '			; Fill rest of buffer with spaces
	cld				;
	rep	stosb			;
	pop	ds			; Restore user data seg
	ret
ENDP	MoveNameToStack
;
; Create a file
;
CFP_NAME = ebp - DIRENTRYSIZE		; Name buffer
PROC	CreateFile
	ENTER	DIRENTRYSIZE,0		; Save space for variables
	push	ecx			; Move name to stack
	mov	esi,ecx			;
	lea	edi,[CFP_NAME]		;
	call	MoveNameToStack		;
	lea	edx,[CFP_NAME]		;
	call	SearchForFileName	; See if name exists
	jnc	short cf_oldfile	; Yeah, go truncate it
	cmp	al,ERR_FILENOTFOUND	; Else see if not found
	jnz	short cf_error		; No, service other errors
	call	AllocSector		; Else allocate the file sector
	jc	short cf_error		;
	mov	edx,eax			; Read it in
	call	ReadSector		;
	jc	short cf_error		;
	call	DirtyBuffer		; Dirty buffer
	mov	edi,esi			; Blank it to zeros
	sub	eax,eax			;
	mov	ecx,SECTORSIZE/4	;
	rep	stosd			;
	push	esi			; Move the name to it
	lea	edi,[esi + FILEPAGE.NM]	;
	lea	esi,[CFP_NAME]		;
	push	esi			;
	mov	ecx,FILENAMELEN / 4	;
	rep	movsd			;
	pop	esi			; Save file page in dir entry
	mov	[esi + DIRENTRY.ENTRY],edx;
	mov	[dword ptr esi + DIRENTRY.uu],0 ; Clear other dir params
	mov	[byte ptr esi + DIRENTRY.FLAGS],0;
	mov	[dword ptr esi + DIRENTRY.MORE],0;
	xchg	esi,[esp]		;
	call	CompressTime		; Get compressed time
	mov	[esi + FILEPAGE.TIME],eax ; Fill in time and signature
	mov	[esi + FILEPAGE.SIG],FPSIGNATURE;
	call	InsertFileName		; Go insert the file name
	jc	short cf_error		;
cf_openfile:
	pop	ecx			; Open the file
	call	OpenFile		;
	leave				;
	ret
cf_error:
	pop	ecx			;
cf_error2:
	stc
	leave
	ret
cf_oldfile:
	pop	ecx			; Old file, open it
	call	OpenFile		;
	mov	ebx,eax
	jc	cf_error2		;
	push	eax
	call	TruncateFile		; Truncate it
	pop	ebx
	jnc	short cf_ok		;
	push	ebx
	push	eax
	call	CloseFile		;
	pop	ebx			; Doing a swap with pops
	pop	eax
	stc
cf_ok:
	mov	eax,ebx			;
	leave
	ret
ENDP	CreateFile
;
; Find a free FCB
;
PROC	GetFCB
	push	ecx			; Save ECX
	mov	ecx,NUMFCBs		; Number of FCBs and FCB base
	mov	edi,[fcbstart]		;
gfcb_next:
	test	[dword ptr edi + FCB.PAGE],-1 ; See if alloctaed
	jz	short gfcb_gotone	; No, get it
	add	edi,FCBSIZE		;
	loop	gfcb_next		; Loop till found
	stc				; None found, error
	mov	al,ERR_NOFCBs		;
	pop	ecx			;
	ret
gfcb_gotone:
	clc
	pop	ecx
	ret
ENDP	GetFCB
;
; Open a file
;
PROC	OpenFile
	ENTER	DIRENTRYSIZE,0		; Leave space for name
	mov	esi,ecx			; Get name to stack
	lea	edi,[CFP_NAME]		;
	call	MoveNameToStack		;
	call	GetFCB			; Find a free FCB
	jc	short of_error		;
	lea	edx,[CFP_NAME]		; Search for file
	push	edi			;
	call	SearchForFileName	;
	pop	edi			;
	jc	short of_error		;
	mov	edx,eax			; Read the file block
	call	ReadSector		;
	jc	short of_error		;
	mov	eax,[esi + FILEPAGE.LEN]; Get len to FCB
	mov	[edi + FCB.BYTES],eax	;
	and	[edi + FCB.BYTES],SECTORSIZE-1;
	shr	eax,SECTORSHIFT		;
	mov	[edi + FCB.PAGES],eax	;
	mov	[edi + FCB.DRIVE],bl	; Drive to FCB
	mov	[edi + FCB.PAGE],edx	; File page to FCB
	mov	[edi + FCB.POSBYTES],0	; Position = start of file
	mov	[edi + FCB.POSPAGES],0	;
	mov	[edi + FCB.CURRENTPAGE],0; Current page not loaded
	mov	eax,edi			; Calculate FID
	sub	eax,[fcbstart]		;
	sub	edx,edx			;
	mov	edi,FCBSIZE		;
	div	edi			;
	add	eax,BASEFCBs		; Convert to FID
	clc				;
	leave
	ret
of_error:
	mov	[dword ptr edi + FCB.PAGE],0
	leave
	ret
ENDP	OpenFile
;
; Calculate FCB address from FID
;
PROC	CalFCB
	sub	ebx,BASEFCBs		; Subtract out basic FCB
	cmp	ebx,NUMFCBs		; See if too big
	jnc	short cfcb_bad		; Error if so
	mov	eax,ebx			; Else Mul by size
	mov	ebx,FCBSIZE		;
	push	edx			;
	mul	ebx			;
	pop	edx			;
	add	eax,[fcbstart]		; Add to start
	test	[dword ptr eax],-1	; See if in use
	jz	short cfcb_bad		; No, error
	mov	edi,eax			;
	clc				;
	ret
cfcb_bad:
	mov	al,ERR_BADFCB
	stc
	ret
ENDP	CalFCB
;
; Close a file
;
PROC	CloseFile
	call	CalFCB			; Calculate FCB address
	jc	short	cfi_error		;
	mov	edi,eax			;
	mov	edx,[edi + FCB.PAGE]	; Read file page
	movzx	ebx,[edi + FCB.DRIVE]	;
	call	ReadSector		;
	jc	short cfi_error		;
	call	DirtyBuffer		; Dirty it
	mov	eax,[edi + FCB.BYTES]	; Update file length
	mov	ebx,[edi + FCB.PAGES]	;
	shl	ebx,SECTORSHIFT		;
	add	eax,ebx			;
	mov	[esi + FILEPAGE.LEN],eax;
	mov	[edi + FCB.PAGE],0	; Release FCB
	call	FlushBuffers		; Flush buffers on close
	jc	short cfi_error		;
	ret
cfi_error:
	stc
	ret
ENDP	CloseFile	
;
; Truncate a file
;
PROC	Truncate
	call	ReadSector		; Read file page
	jc	t_error			;
	mov	[dword ptr esi + FILEPAGE.LEN],0 ; Mark len 0
	call	DirtyBuffer		; Dirty buffer
	mov	ecx,FPDIRECTENTRIES-1	; Number of direct entries to run through
t_singles:
	mov	eax,[esi + 4 * ecx + FILEPAGE.SINGLES] ; Current entry
	or	eax,eax			; Zero entry is unallocated
	jz	short t_snodeall	;	
	mov	[esi + 4 * ecx + FILEPAGE.SINGLES],0; Else mark unallocated
	call    DeallocSector		; Deallocate
	jc	short t_error		;
t_snodeall:
	dec	ecx			; Next entry
	jns	t_singles		;
	mov	ecx,FPINDIRENTRIES-1	; Number of indirect entries to run through
t_doubles:
	push	ecx			;
	push	edx			; Save file page
	mov	edx,[esi + 4 * ecx + FILEPAGE.DOUBLES] ; Get a double
	or	edx,edx			; If none allocated don't deallocate
	jz	short t_nodoubledeall	;
	mov	[esi + 4 * ecx + FILEPAGE.DOUBLES],0; Get entry
	
	call	ReadSector		; Read the sector
	jc	short t_error		;
	call	DirtyBuffer		; Dirty it
	mov	eax,edx			; Deallocate the sector itself
	call	DeallocSector		;
	jc	short t_error		;
	mov	ecx,SECTORSIZE / 4	; Number of items in a sector
t_doubledeall:
	mov	eax,[esi + 4 * ecx]	; Get one
	or	eax,eax			;
	jz	short t_tnodeall	; Don't deallocate if not allocated
	mov	[dword ptr esi + 4 * ecx],0 ; Else mark deallocated
	call	DeallocSector		; And deallocate it
	jc	short t_error		;
t_tnodeall:
	dec	ecx             	; Next item this sector
	jns	t_doubledeall		;
t_nodoubledeall:
	pop	edx			; Back to file page
	pop	ecx			;
	call	ReadSector		;
	jc	short t_error		;
	call	DirtyBuffer		; Dirty it
	dec	ecx			; Next indirect buffer
	jns	t_doubles		;
	clc
	ret
t_error:
	stc
	ret
ENDP	Truncate
;
; Delete a file
;
PROC	DeleteFile
	ENTER	DIRENTRYSIZE,0
	mov	esi,ecx		; Move name to stack
	lea	edi,[CFP_NAME]	;
	call	MoveNameToStack	;
	lea	edx,[CFP_NAME]	; Search for name
	call	SearchForFileName	;
	jc	short df_error	;
	mov	edx,eax		; Truncate the file
	call	Truncate	;
	jc	short df_error	;
	mov	eax,edx		; Deallocate file page
	call	DeallocSector	;
	jc	short df_error	;
	push	0		; Delete the name from the dir
	lea	edi,[CFP_NAME]	;
	push	edi		;
	call	DeleteFileName	;
	jc	short df_error	;
	call	FlushBuffers	; Flush buffers
	jc	short df_error	;
	leave
	ret
df_error:
	stc
	leave
	ret
ENDP	DeleteFile
;
; Truncate a file
;
PROC	TruncateFile
	call	calfcb		; Get FCB
	jc	short tf_error	;
	mov	edx,[edi + FCB.PAGE]	; Truncate
	movzx	ebx,[edi + FCB.DRIVE]	;
	call	Truncate		;
	jc	short tf_error		;
	mov	[dword ptr edi + FCB.PAGES],0	; Reset position and length
	mov	[dword ptr edi + FCB.POSPAGES],0;
	mov	[dword ptr edi + FCB.BYTES],0	;
	mov	[dword ptr edi + FCB.POSBYTES],0;
	clc
	ret
tf_error:
	ret
ENDP	TruncateFile
;
; Rename a file
;
RFP_NEWNAME	=	ebp - DIRENTRYSIZE
RFP_OLDNAME	=	ebp - 2*DIRENTRYSIZE
PROC	RenameFile
	ENTER	2*DIRENTRYSIZE,0
	mov	esi,ecx				; Move names to stack
	lea	edi,[RFP_OLDNAME]		;
	call	MoveNameToStack			;
	mov	esi,edx				;
	lea	edi,[RFP_NEWNAME]		;
	call	MoveNameToStack			;
	mov	[RFP_NEWNAME + DIRENTRY.FLAGS],0; Set params of new entry
	mov	[RFP_NEWNAME + DIRENTRY.MORE],0	;
	lea	edx,[RFP_OLDNAME]		; Get old entry File Page
	call	SearchForFileName		;
	jc	short rnf_error			;
	mov	[RFP_NEWNAME + DIRENTRY.ENTRY],eax ; Save in new entry
	lea	edi,[RFP_NEWNAME]		; Insert new file name
	push	edi				;
	call	InsertFileName			;
	jc	short rnf_error			;
	push	0				; Delete old file name
	lea	edi,[RFP_OLDNAME]		;
	push	edi				;
	call	DeleteFileName			;
	jc	short rnf_error			;
	mov	edx,[RFP_NEWNAME + DIRENTRY.ENTRY]; Get the file page
	call	ReadSector			;
	jc	short rnf_error			;
	call	DirtyBuffer			; Dirty it
	lea	edi,[esi + FILEPAGE.NM]		; Change the name in the file page
	lea	esi,[RFP_NEWNAME]		;
	mov	ecx,FILENAMELEN/4		;
	rep	movsd				;
	call	FlushBuffers			; Flush to disk
	jc	short rnf_error			;
	leave					;
	ret
rnf_error:
	leave
	ret
ENDP	RenameFile
;
; Calculate block to read or write at
;
PROC	CalBlock
	mov	edx,[edi + FCB.PAGE]		; Read file page
	movzx	ebx,[edi + FCB.DRIVE]		;
	call	ReadSector			;
	jc	short cb_error			;
	mov	eax,[edi + FCB.POSPAGES]	; See if within direct entries
	cmp	eax,FPDIRECTENTRIES		;
	jc	short cb_single			; Yes- get block directly
	sub	eax,FPDIRECTENTRIES		; Else offset to first indir entry
	push	eax				;
	shr	eax,SECTORSHIFT-2		; Divide by Entries per page
	mov	edx,[esi + eax*4 + FILEPAGE.DOUBLES] ; Find indir page
	call	ReadSector			; Read it
	pop	eax				;
	jc	short cb_error			;
	and	eax,SECTORSIZE/4-1		; Mod is entry this page
	mov	edx,[esi + eax*4]		; Target is indicated page
	jmp	short cb_readtarget		;
cb_single:
	mov	edx,[esi + eax*4 + FILEPAGE.SINGLES] ; Read from direct entry table
cb_readtarget:                                    
	mov	[edi + FCB.CURRENTPAGE],edx	; Save as current page
	call	ReadSector			; Read sector
	jc	short cb_error
	clc
	ret
cb_error:
	ret
ENDP	CalBlock
;
; Calculate position to read or write at, and length to read or write
;
GPBP_WRITING = ebp + 8				; True if should dirty buffer
PROC	GetPosBuffer
	enter	0,0
	push	edi				;
	push	edx				;
	mov	edi,edx				;
	mov	edx,[edi + FCB.CURRENTPAGE]	; Page number cached?
	or	edx,edx				;
	jz	short grpb_readpage		; No- go calculate
	movzx	ebx,[edi + FCB.DRIVE]		; Else read cached page
	call	ReadSector			;
	jc	short grpb_error		;
	jmp	short grpb_gotpage		;
grpb_readpage:
	call	CalBlock			; Calculate page
	jc	short grpb_error		;
grpb_gotpage:
	test	[byte ptr GPBP_WRITING],-1	; See if writing
	jz	short grpb_notwriting		; No, don't dirty
	call	DirtyBuffer			; Else dirty
grpb_notwriting:
	add	esi,[edi + FCB.POSBYTES]	; Calculate amount left
	mov	eax,SECTORSIZE			;
	sub	eax,[edi + FCB.POSBYTES]	;
	cmp	eax,ecx				; Greater than request?
	jc	short grpb_restofbuf		;
	mov	eax,ecx				; Yes, use request
grpb_restofbuf:
	add	[edi + FCB.POSBYTES],eax	; Update position
	cmp	[dword ptr edi + FCB.POSBYTES],SECTORSIZE; See if at end
	jc	short grpb_notnew		;
	mov	[dword ptr edi + FCB.CURRENTPAGE],0; No cached page
	sub	[dword ptr edi + FCB.POSBYTES],SECTORSIZE; Update position
	inc	[dword ptr edi + FCB.POSPAGES]	; to next sector
grpb_notnew:
	pop	edx
	pop	edi
	clc
	leave
	ret	04
grpb_error:
	pop	edx
	pop	edi
	leave
	ret	04
ENDP	GetPosBuffer
;
; Read from file
PROC	ReadFile
	cmp	ecx,SECTORSIZE			; Get out if request too big
	ja	short rf_cant			;
	or	ecx,ecx				;
	jz	short rf_done2			;
	call	CalFCB				; Calculate FCB
	jc	rf_error			;
	push	edx				;
	mov	edx,[edi + FCB.POSPAGES]	; Calculate amount left
	shl	edx,SECTORSHIFT			;
	or	edx,[edi + FCB.POSBYTES]	;
	mov	eax,[edi + FCB.PAGES]		;
	shl	eax,SECTORSHIFT			;
	or	eax,[edi + FCB.BYTES]		;
	sub	eax,edx				;
	pop	edx				;
	cmp	eax,ecx				; See if enough to satisfy request
	jnc	short rf_ok			;
	mov	ecx,eax				; No, lower request
rf_ok:
	or	ecx,ecx				; See if any to get
	jz	short rf_eof			; EOF if none
	push	ecx				; Push total length
	mov	edx,edi				; EDX = FCB
	mov	edi,esi				;
	push	FALSE				; Reading
	call	GetPosBuffer			; Get position
	jc	rf_error2			;
	push	es				; Move to user buffer
	push	fs				;
	pop	es				;
	push	ecx				;
	mov	ecx,eax				;
	rep	movsb				;
	pop	ecx				;
	sub	ecx,eax				; Subtract length moved
	pop	es 				;
	jz	short rf_done			; Quit if done
	push	FALSE				; Else reading again
	call	GetPosBuffer			; Get position to read from
	jc	short rf_error2			;
	push	es            			; Move to user buffer
	push	fs				;
	pop	es				;
	push	ecx				;
	mov	ecx,eax				;
	rep	movsb				;
	pop	ecx				;
	pop	es				;
rf_done:
	pop	ecx				; Restore length of request
rf_done2:
	clc					; Get out
	ret					;
rf_error2:
	pop	ecx
rf_error:
	stc
	ret
rf_cant:
	stc
	mov	al,ERR_INVALIDREADWRITELEN
	ret
rf_eof:
	sub	ecx,ecx				; EOF returns a zero count
	ret
ENDP	ReadFile
;
; Read A large number of bytes
;
RFLP_BYTES EQU EBP -4
PROC	ReadFileLong
	ENTER	4,0
	cmp	ebx,STDIN
	jz	short rfl_stdin
	mov	[WORD PTR RFLP_BYTES],0		; Bytes read = 0
rfl_loop:
	cmp	ecx,SECTORSIZE		; Just one sector?
	jc	short rfl_last		; Yeah, go do it
	push	ecx			; Save count and position
	push	esi			;
	mov	ecx,SECTORSIZE		; Read in a sector
	push	ebx
	call	ReadFile		;
	pop	ebx
	jc	short rflp_getout	; If error get out
	add	[RFLP_BYTES],ecx	; Else update read count
	pop	esi			; Update position
	add	esi,ecx			;
	cmp	ecx,SECTORSIZE		; See if full read
	pop	ecx			; 
	jnz	short rflp_ok		; Get out if not
	sub	ecx,SECTORSIZE		; Decrement amount left
	jmp	rfl_loop                ; Loop again
rfl_last:
	call	ReadFile		; Read last sector.  Sector routine
					; Checks for 0 bytes
	jc	short rflp_getout	; Error, get out
	add	[RFLP_BYTES],ecx	; Add number of bytes read to rv
rflp_ok:
	clc
rflp_getout:
	mov	ecx,[RFLP_BYTES]	;
	LEAVE
	ret
rfl_stdin:
	push	ecx
getkeys:
	OS	KB_CHAR
	mov	[fs:esi],al
	inc	esi
	loop	getkeys
	pop	ecx
	clc
	LEAVE
	ret
ENDP	ReadFileLong
;
; Extend a file by one page
;
PROC	ExtendFile
	mov	edx,[edi + FCB.PAGE]		; Read file page
	movzx	ebx,[edi + FCB.DRIVE]		;
	call	ReadSector			;
	jc	ef_error			;
	mov	eax,[edi + FCB.POSPAGES]	; Get position to allocate at
	cmp	eax,FPDIRECTENTRIES		; See if in direct entries
	jc	short ef_single
	sub	eax,FPDIRECTENTRIES		; NO, offset to first indir entry
	push	eax				;
	shr	eax,SECTORSHIFT-2		;
	lea	edx,[esi + eax*4 + FILEPAGE.DOUBLES]; Point at relevant indir entry
	test	[dword ptr edx],-1		; See if allocated
	jnz	short ef_noalloc		; Yeah, don't allocate
	push	ecx				; No, allocate
	push	edx				;
	call	AllocSector			;
	pop	edx				;
	pop	ecx				;
	jc	short ef_error2			;
	call	DirtyBuffer			; Dirty file page
	mov	[edx],eax			; Save allocated
	mov	edx,eax				; Get allocated page
	call	WriteBuffer			; Going to wipe it out
	jc	short ef_error2			;
	call	DirtyBuffer			; Dirty it
	push	ecx				;
	mov	edi,esi				; Zero it out
	sub	eax,eax				;
	mov	ecx,SECTORSIZE/4		;
	rep	stosd				;
	pop	ecx				;
	jmp	short ef_noalloc2		;
ef_noalloc:
	mov	edx,[edx]			; Get previously allocated indir sector
ef_noalloc2:
	call	ReadSector			; Read it
	pop	eax				;
	jc	short ef_error2			;
	pop	eax				;
	and	eax,SECTORSIZE/4-1		; Find the entry in it
	lea	edx,[esi + eax*4]		; Point to it
	jmp	short ef_readtarget		;
ef_single:
	lea	edx,[esi + eax*4 + FILEPAGE.SINGLES]; Point to singles entry
ef_readtarget:
	mov	eax,[edx]			; Get it
	or	eax,eax				; Already allocated?
	jnz	short ef_exit			; yes- Get out
	push	ecx				; Otherwise allocated
	push	edx				;
	push	edi				;
	push	esi				;
	call	AllocSector			;
	pop	esi				;
	pop	edi				;
	pop	edx				;
	pop	ecx				;
	jc	short ef_error			;
	call	DirtyBuffer			; Dirty the buffer
	mov	[edx],eax			; Save allocated sector
ef_exit:
	clc
	ret
ef_error2:
	add	esp,4
ef_error:

	ret
ENDP	ExtendFile
;
; Write to a file
;
WFP_UEOF	= ebp - 4			; Extending EOF if true
PROC	WriteFile
	ENTER	4,0
	cmp	ecx,SECTORSIZE			; Get out if too big request
	ja	rf_cant				;
	mov	[dword ptr WFP_UEOF],0		; Assume not extending EOF
	push	ecx				;
	or	ecx,ecx         		; Quit if no request
	jz	wf_done				;
	call	CalFCB				; Calculate FCB
	jc	wf_error2			;
	mov	eax,[edi + FCB.PAGES]		; See if extending
	shl	eax,SECTORSHIFT			;
	add	eax,[edi + FCB.BYTES]		;
	mov	edx,[edi + FCB.POSPAGES]	;
	shl	edx,SECTORSHIFT			;
	add	edx,[edi + FCB.POSBYTES]	;
	add	edx,ecx				;
	cmp	eax,edx				;
	jnc	short wf_tomiddle		; No, write to middle
	inc	[byte ptr WFP_UEOF]		; Else extending EOF
	push	[dword ptr edi + FCB.POSPAGES]	; Save position
	push	[dword ptr edi + FCB.POSBYTES]	;
	mov	eax,[edi + FCB.POSBYTES]
	add	[edi + FCB.POSBYTES],ecx	; Find last page
	or	eax,eax
	jz	short wf_alloc
	cmp	[dword ptr edi + FCB.POSBYTES],SECTORSIZE;
	jbe	short wf_noalloc		;
	inc	[dword ptr edi + FCB.POSPAGES]	;
wf_alloc:
	push	esi				; Allocate the page
	call	ExtendFile			;
	pop	esi				;
wf_noalloc:
	pop	[dword ptr edi + FCB.POSBYTES]	; Restore position
	pop	[dword ptr edi + FCB.POSPAGES]	;
wf_tomiddle:
	mov	edx,edi				;
	mov	edi,esi				;
	push	TRUE				; Writing
	call	GetPosBuffer			; Get position to write to
	jc	short wf_error2			;
	push	ds				; Move data from user buffer
	push	fs				;
	pop	ds				;
	xchg	esi,edi				;
	push	ecx				;
	mov	ecx,eax				;
	rep	movsb				;
	pop	ecx				;
	xchg	esi,edi				;
	pop	ds				;
	sub	ecx,eax				; Subtract amount moved
	jz	short wf_done			; Get out if done
	push	TRUE				; Writing
	call	GetPosBuffer			; Get position to write to
	jc	short wf_error2			;
	push	ds				; Write data from user buffer
	push	fs				;
	pop	ds				;
	xchg	esi,edi				;
	mov	ecx,eax				;
	rep	movsb				;
	pop	ds				;
wf_done:
	pop	ecx				; Get length moved
	mov	edi,edx				;
	test	[byte ptr WFP_UEOF],-1		; See if changing EOF
	jz	short wf_noupdateeof		; No, get out
	mov	edx,[edi + FCB.PAGE]		; Read file page
	call	ReadSector			;
	jc	short wf_error			;
	call	DirtyBuffer			; Dirty it
	mov	eax,[edi + FCB.POSPAGES]	; Get final position
	mov	[edi + FCB.PAGES],eax		; Update FCB len
	mov	edx,eax				;
	shl	edx,SECTORSHIFT			;
	mov	eax,[edi + FCB.POSBYTES]	;
	mov	[edi + FCB.BYTES],eax		;
	or	edx,eax				;
	mov	[esi + FILEPAGE.LEN],edx	; Update file page len
wf_noupdateeof:
	clc
	leave
	ret	
wf_error2:
	pop	ecx
wf_error:
	stc
	leave
	ret
ENDP	WriteFile
;
; Write A large number of bytes
;
WFLP_BYTES EQU EBP -4
PROC	WriteFileLong
	ENTER	4,0
	cmp	ebx,STDOUT
	jz	short wfl_stdout
	mov	[WORD PTR WFLP_BYTES],0		; Bytes Written = 0
wfl_loop:
	cmp	ecx,SECTORSIZE		; Just one sector?
	jc	short wfl_last		; Yeah, go do it
	push	ecx			; Save count and position
	push	esi			;
	mov	ecx,SECTORSIZE		; Write in a sector
	push	ebx
	call	WriteFile		;
	pop	ebx
	jc	short wflp_getout	; If error get out
	add	[WFLP_BYTES],ecx	; Else update Write count
	pop	esi			; Update position
	add	esi,ecx			;
	pop	ecx			; Decrement amount left
	sub	ecx,SECTORSIZE		;
	jmp	wfl_loop                ; Loop again
wfl_last:
	call	WriteFile		; Write last sector.  Sector routine
					; Checks for 0 bytes
	jc	short wflp_getout	; Error, get out
	add	[WFLP_BYTES],ecx	; Add number of bytes Written to rv
	clc
wflp_getout:
	mov	ecx,[WFLP_BYTES]
	LEAVE
	ret
wfl_stdout:
	push	ecx
vidlp:
	mov	dl,[fs:esi]
	inc	esi
	OS	VF_CHAR
	LOOP	vidlp
	pop	ecx
	clc
	LEAVE
	ret
ENDP	WriteFileLong
;
; Set file position
;
PROC	SetPosition
	call	CalFCB				; Calculate FCB
	jc	short sp_error			;
	or	ecx,ecx
	jz	short sp_loadcurrent
	dec	ecx
	jnz	short sp_doend
	mov	eax,[edi + FCB.POSPAGES]	; Get org position
	shl	eax,SECTORSHIFT			;
	or	eax,[edi + FCB.POSBYTES]	;
	add	edx,eax
	jmp	short sp_loadcurrent
sp_doend:
	mov	eax,[edi + FCB.PAGES]		; Get org position
	shl	eax,SECTORSHIFT			;
	or	eax,[edi + FCB.BYTES]		;
	add	edx,eax
sp_loadcurrent:
	mov	eax,[edi + FCB.PAGES]		; Get org position
	shl	eax,SECTORSHIFT			;
	or	eax,[edi + FCB.BYTES]		;
	cmp	edx,eax
	jc	short sp_doload
	mov	edx,eax
sp_doload:
	mov	[edi + FCB.POSBYTES],edx	; Set new position
	and	[edi + FCB.POSBYTES],SECTORSIZE-1;
	shr	edx,SECTORSHIFT			;
	mov	[edi + FCB.POSPAGES],edx	;
	mov	[edi + FCB.CURRENTPAGE],0	;
	clc					;
	ret
sp_error:
	ret
ENDP	SetPosition
;
; Get file position
;
PROC	GetPosition
	call	CalFCB				; Get FCB address
	jc	short gp_error			;
	mov	eax,[edi + FCB.POSPAGES]	; Load position
	shl	eax,SECTORSHIFT			;
	or	eax,[edi + FCB.POSBYTES]	;
	clc
	ret
gp_error:
	ret
ENDP	GetPosition
;
; Go to eof 
;
PROC	GoEOF
	call	CalFCB				; Calculate FCB
	jc	short go_error			;
	mov	eax,[edi + FCB.PAGE]		; Position to end
	mov	[edi + FCB.POSPAGES],eax	;
	mov	eax,[edi + FCB.BYTES]		;
	mov	[edi + FCB.POSBYTES],eax	;
	ret
go_error:
	ret
ENDP	GoEOF
;
; Update file time
;
PROC	FileSetTime
	push	edx
	call	CalFCB				; Calculate FCB
	pop	ecx
	jc	short st_error	
	push	ecx		;
	mov     edx,[edi + FCB.PAGE]		; Read file page
	movzx	ebx,[edi + FCB.DRIVE]		;
	call	ReadSector			;
	pop	ecx
	jc	short st_error			;
	call	DirtyBuffer			; Dirty it
	mov	[esi + FILEPAGE.TIME],ecx	; Save time file page
	ret
st_error:
	ret
ENDP	FileSetTime
;
; Get file time
;
PROC	FileGetTime
	call	CalFCB				; Calculate FCB
	jc	short gt_error			;
	mov	edx,[edi + FCB.PAGE]		; Read file page
	movzx	ebx,[edi + FCB.DRIVE]		;
	call	ReadSector			;
	jc	short gt_error			;
	mov	eax,[esi + FILEPAGE.TIME]	; Get time
	clc
	ret
gt_error:
	ret
ENDP	FileGetTime
;
; Return standard handles
;
PROC	GetStdHandle
	cmp	ebx,STD_INPUT_HANDLE
	mov	eax,STDIN
	jz	short gothandle
	mov	eax,STDOUT
gothandle:
	clc
	ret
ENDP	GetStdHandle
;
; Return handle type
;
PROC	GetHandleType
	cmp	ebx,BASEFCBs
	mov	eax,FILE_CHAR
	jc	short gotype
	mov	eax,FILE_DISK
gotype:
	ret
ENDP	GetHandleType
;
; Return last error
;
PROC	GetLastError
	mov	eax,[LastError]
	clc
	ret
ENDP	GetLastError
;
; File handler
;
PROC	FileHAndler
	push	esi				; Save regs
	push	edi				;
	push	edx				;
	push	ebx				;
	push	ds				;
	push	es				;
	push	fs				;

	push	ds				; FS = user data seg
	pop	fs				;
	
	push	ds386				; DS & ES = system data seg
	push	ds386				;
	pop	es				;
	pop	ds				;

	call	MapStackToSystem		; Map stack to system data space
	push	offset SemFile			; Block on a semaphore
	call	SemBlock			;

	push	0				; Dispatch file function
	call	TableDispatch			;
	dd	0fh
	dd	CreateFile
	dd	OpenFile
	dd	CloseFile
	dd	DeleteFile
	dd	TruncateFile
	dd	RenameFile
	dd	ReadFileLong
	dd	WriteFileLong
	dd	SetPosition
	dd	GetPosition
	dd	GoEOF
	dd	FileSetTime
	dd	FileGetTime
	dd	GetStdHandle
	dd	GetHandleType
	dd	GetLastError
	pushfd					; Save flags

ifdef DEBUG	
	pushfd
	push	eax				; Flush buffers if testing
	call	FlushBuffers			;
	pop	eax				;
	popfd
ENDIF
	bts	[SemFile],0			; Clear semaphore
	popfd					;
	
	call	UnmapStack			; Restore user position
	pop	fs				;
	pop	es				;
	pop	ds				;
	pop	ebx				;
	pop	edx				;
	pop	edi				;
	pop	esi				;
	ret					; Get out
ENDP	FileHandler
ENDS	Seg386
END