;
; RESTAMP algorythm not entirely tested
;
; Buffers.asm
;
; Function: Handle disk buffers
;   Handles swapping out least used buffer
;   Handles allocating buffer space in the expanded memory area
;   Handles low-level disk calls
;
	IDEAL
	P386

include "errors.asi"
include "segs.asi"
include "os.asi"
include "fs.ase"
include "floppy.asi"
include "fs.asi"
include "page.asi"
include "sys.mac"
include "pageall.asi"
include "prints.ase"
include "pageall.ase"
include "boot.ase"

	PUBLIC	GetSectors,ReadSector,WriteBuffer,DirtyBuffer,FlushBuffers
	PUBLIC	StampAsLatest
	PUBLIC	bufferInit,bufferstart

RETRIES = 3
BUF_PAGES_TO_ALLOC = 16

SEGMENT seg386data
badbuf	db	"Bad Buffer Alloc",0
bufferstart dd	0
numbuffers dd	BUFFERCOUNT
stamp	dw	0				; Usage stamp value
ENDS	seg386data

SEGMENT seg386
;
; Initialize a buffer
;
Proc	Init
	mov	[edi + BUFFER.FLAGS],0		; Mark it empty and clean
	bts	[dword ptr edi + BUFFER.FLAGS],BF_EMPTY ;
	ret
ENDP	Init
;
; Init all buffers
;
PROC	BufferInit
	ALLOCEXT				; External allocation
	call	PageAlloc			; Get a page
	jc	short badbufmsg			; Err if none
	cmp	eax,PG_STARTOFEXTMEM		; Err if not start of EXT mem
	jnz	short badbufmsg   			;
	ZA	eax
	mov	[bufferstart],eax		; Fill in buffer start
	mov	ecx,BUF_PAGES_TO_ALLOC-1	; Remainter of pages to alloc
alloc64K:		
	ALLOCEXT
	call	PageAlloc			; Alloc one
	loop	alloc64K                        ; Loop until all
	mov	edx,offset init			; Buffer init routine
	call	BufferRunThrough 		; Run through all buffers
	ret
badbufmsg:
	MESSAGE badbuf
	jmp	$
ENDP	BufferInit
;
; Return number of sectors
;
PROC	GetSectors
	os	DK_GETSECTORS			; Call the disk routine
	ret
ENDP	GetSectors
;
; Run through all buffers applying a function
;
PROC	BufferRunThrough
	mov	edi,[bufferstart]		; First buffer
	mov	ecx,[numbuffers]		; Numbre of buffers
br_lp:
	push	edx				; Save function
	call	edx				; Call function
	pop	edx				;
	jc	br_done				; Get out if function Carry
	add	edi,BUFFEROFFSET		; Next buffer
	loop 	br_lp				; Do next
	clc					; Finished all buffers
br_done:
	ret
ENDP	BufferRunThrough
;
; Flush a buffer
;
PROC	Flush
	bt	[dword ptr edi + BUFFER.FLAGS],BF_DIRTY	; See if dirty
	jnc	noflush				; Quit if clean
	movzx	ebx,[edi + BUFFER.DRIVE]	; Get drive & sector & buffer
	mov	edx,[edi + BUFFER.SECTOR]	;
	lea	esi,[edi + BUFFER.DATA]		;
	call	Write				; Write the buffer out
	jc	noflush				; Get out on error
	btr	[dword ptr edi + BUFFER.FLAGS],BF_DIRTY	; Clean buffer
	clc					; No error
noflush:
	ret
ENDP	Flush
;
; Flush all buffers
;
PROC	FlushBuffers
	push	esi				; Save all regs
	push	ebx				;
	push	ecx				;
	push	edx				;
	mov	edx,offset Flush		; Flush routine
	call	BufferRunThrough		; Do runthrough
	pop	edx				; Restore regs
	pop	ecx				;
	pop	ebx				;
	pop	esi				;
	ret
ENDP	FlushBuffers
;
; Invalidate a buffer
;
PROC	Invalidate
	cmp	[edi + BUFFER.DRIVE],al		; See if for this drive
	jnz	short inv_done			; Quit if not
	btr	[dword ptr edi + BUFFER.FLAGS],BF_DIRTY	; Else clean it
	bts	[dword ptr edi + BUFFER.FLAGS],BF_EMPTY	; Empty it
inv_done:
	clc					; No error
	ret
ENDP	Invalidate
;
; Invalidate all buffers for a given drive
;
PROC	InvalidateBuffers
	jnc	short noerror			; Get out if not error
	push	eax				; Save error
	pushfd					; Save err flag
	cmp	al,DERR_CHANGED			; See if changed
	jz	short goterr			; Yeah, go invalidate buffers
       	cmp	al,DERR_TIMEOUT			; See if missing
	jnz	short noinvalidate		; No, no invalidate
goterr:
	push	edi
	push	edx
	push	ecx
	mov	eax,ebx				; EAX = drive
	mov	edx,offset Invalidate		; Invalidate function
	call	BufferRunThrough		; Run through buffers
	pop	ecx
	pop	edx
	pop	edi
noinvalidate:
	popfd					; Restore err flag
	pop	eax				; And error
noerror:
	ret
ENDP	InvalidateBuffers
;
; Set a buffer stamp back to halfway mark
; Buffer stamps start at 0, progress to 65535, then start back at 32767
;
PROC	Restamp
	btr	[edi + BUFFER.STAMP],15		; Set us back
	clc					; No errors
	ret
ENDP	Restamp
;
; Restamp all buffers
;
PROC	RestampBuffers
	mov	edx,offset Restamp		; Restamp function
	call	BufferRunThrough		; Run through all buffers
	ret
ENDP	RestampBuffers
;
; Stamp a buffer with current time stap
;
PROC	StampBuffer
	mov	ax,[stamp]			; Get stamp
	mov	[edi + BUFFER.STAMP],ax		; Load buffer with stamp
	inc	[stamp]				; Next stamp
	jnz	short noRestamp			; Get out if no overflow
	push	edi				;
	push	edx				; 
	call	RestampBuffers			; Restamp all buffers
	pop	edx
	pop	edi				;
norestamp:
	ret
ENDP	StampBuffer
;
; See if a buffer is free or lowest stamp
;
PROC	IsFree
	bt	[dword ptr edi + BUFFER.FLAGS],BF_EMPTY	; See if empty
	jc	short gotfree			; Automatically free if empty
	movzx	eax,[edi + BUFFER.STAMP]	; Else get stamp
	cmp	eax,ebx				; See if is lowest stamp yet
	jnc	short notfree		 	; No, get out
	mov	ebx,eax				; Yes, make it lowest
	cmc
gotfree:
	mov	esi,edi				; ESI = found buffer
notfree:
	ret	
ENDP	IsFree
;
; Find a free buffer
;
PROC	FindFree
	mov	edx,offset IsFree		; Free function
	sub	ebx,ebx				; EBX = way high
	dec	ebx				;
	call	BufferRunThrough		; Get us a buffer
	mov	edi,esi				; in EDI
ifdef DEBUG
	push	eax				; Debugging, print buffer
	mov	eax,esi
	call	printdword
	call	printspace
	pop	eax
endif
	call	Flush				; MAke sure it is flushed
	jc	short writerr			; Get out if error
	btr	[dword ptr edi + BUFFER.FLAGS],BF_EMPTY	; Not empty
	call	stampBuffer			; Stamped
	clc
	ret
writerr:	
	ret
ENDP	FindFree
;
; See if this buffer matches the requested sector
;
PROC	Match
ifdef DEBUG
	push	eax				; Debugging, print a star
	push	edx
	mov	dl,'*'
	os	VF_CHAR
	pop	edx
	pop	eax
endif
	bt	[dword ptr edi + BUFFER.FLAGS],BF_EMPTY	; See if empty
	jc	short nomatch			; Can't match empty buffer
	cmp	bl,[edi + BUFFER.DRIVE]		; See if drive matches
	jnz	short nomatch			; No, get out
	cmp	eax,[edi + BUFFER.SECTOR]	; See if sector matches
	jnz	short nomatch			; No, get out
ifdef DEBUG
	push	eax      			; Debugging, just put output
	call	printbyte
	call	printspace
	pop	eax
endif
	stc					; Mark we found a match
	ret
nomatch:
	clc					; No match
	ret
ENDP	Match
;
; See if any buffers match the requested sector
;
PROC	FindMatch
	mov	eax,edx				; eax = sector
	mov	edx,offset Match		; Match function
	call	BufferRunThrough		; Run through all buffers
	ret
ENDP	FindMAtch
;
; Read a sector
;
PROC	Read
	cmp	ebx,NUMDRIVES
	jnc	short rdtoohigh
	push	ecx				; Save old ecx
	sub	ecx,ecx				;
	mov	cl,RETRIES			; MAX number of tries
rdlp:
	xchg	[esp],ecx			;
	os	DK_READ				; Read sector
	xchg	[esp],ecx			;
	jnc	short rdone			; Get out if no errors
	call	ClearNumSats			; Clear sat table if disk changed
	call	InvalidateBuffers		; Invalidate buffers if disk changed
	loop	rdlp				; Try again on error
rdone:
	pop	ecx				; Restore ecx
	ret
rdtoohigh:
	mov	al,ERR_INVALIDRIVE
	stc
	ret
ENDP	Read

;
; Write a sector
;
PROC	Write
ifdef DEBUG
	push	eax				; Debugging, display a %
	push	edx
	mov	dl,'%'
	os	VF_CHAR
	pop	edx
	pop	eax
endif
	cmp	ebx,NUMDRIVES
	jnc	short rdtoohigh
	push	ecx				; Save old ecx
	sub	ecx,ecx				;
	mov	cl,RETRIES			; Max number of tries
wrlp:
	xchg	[esp],ecx			; WRITE function gets old CX
	os	DK_WRITE			; Go write
	xchg	[esp],ecx			;
	jnc	short wdone                     ; Get out, noerr
	call	ClearNumSats			; Clear sat table if disk change
	call	InvalidateBuffers		; Invalidate buffers if disk change
	loop	wrlp				
wdone:
	pop	ecx
	ret
ENDP	Write
;
; Mark a buffer as dirty
;
PROC	DirtyBuffer
	push	esi				; Save esi
	sub	esi,DATAOFFSET			; Point to control info
	bts	[dword ptr esi + BUFFER.FLAGS],BF_DIRTY ; Mark buffer dirty
	clc					; In case multiple marks
	pop	esi				;           	
	ret
ENDP	DirtyBuffer
;
; Get a write buffer
;                                                             	
PROC	WriteBuffer
	push	edi				; Save regs
	push	edx				;
	push	ecx				;
	push	ebx				;
	call	FindMatch			; See if already there
	jnc	short getfree			; Not there, get free buffer
	call	Flush				; Flush it
	jc	short wb_err			; Err if flush failed
	jmp	short gotbuffer			; Else we have it
getfree:
	call	FindFree			; Else Get a free buffer
gotbuffer:
	pop	ebx				;
	pop	ecx				;
	pop	edx				;
	jc	short wb_err			; Get out if flush failed
	btr	[dword ptr edi + BUFFER.FLAGS],BF_DIRTY	; Never dirty
	mov	[edi + BUFFER.SECTOR],edx	; Save sector number
	mov	[edi + BUFFER.DRIVE],bl		; Save drive number
	lea	esi,[edi + BUFFER.DATA]		; Get buffer address
	pop	edi				;
	ret
wb_err:
	pop	edi
	ret
ENDP	WriteBuffer
;
; Get a sector off disk and return buffer
;
PROC	ReadSector
	push	edi				; Save regs
	push	edx				;
	push	ecx				;
	push	ebx				;
	call	FindMatch			; See if sector in buffer
	jc	short rs_found			; Yeah, go restamp it
	call	FindFree			; Else get a free buffer
	pop	ebx				;
	pop	ecx				;
	pop	edx				; Get out if flush failed
	jc	short rs_err				;
	mov	[edi + BUFFER.SECTOR],edx	; Save sector
	mov	[edi + BUFFER.DRIVE],bl		; Save drive
	lea	esi,[edi + BUFFER.DATA]		; Get buffer
	pop	edi				;
	call	Read				; Read a sector into it
	ret
rs_found:
	pop	ebx				; Restore regs
	pop	ecx				;
	pop	edx				;
	call	StampBuffer			; Restamp the buffer
	lea	esi,[edi + BUFFER.DATA]		; Return buffer address
	pop	edi
	clc
	ret
rs_err:
	pop	edi
	ret
ENDP	ReadSector
PROC	StampAsLatest
	push	edi
	sub	edi,DATAOFFSET
	call	StampBuffer
	pop	edi
	ret
ENDP	StampAsLatest
ENDS	seg386
END

	