#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "common.h"

extern uint prm_errcount;

/*
 * Issue an error, quit if too many encountered
 */
void Error( char *fmt, ... )
{
  va_list argptr;

  va_start( argptr, fmt);
  printf("Error: ");
  vprintf( fmt, argptr);
  va_end(argptr);
  putc('\n',stdout);
  if (--prm_errcount == 0) {
    printf("fatal: Too many errors or warnings encountered");
    exit(2);
  }
}