#include <stdio.h>
#include "common.h"
#include "test.h"

extern int errno;

char *usage_text = "<< a-c = a cat arg,\n d-f = a bool,\n g-i = a nocat,\n j-l = a switch >>";

ARGLIST ArgList[] = {
  { 'a', ARG_CONCATSTRING, catroutine },
  { 'b', ARG_CONCATSTRING, catroutine },
  { 'c', ARG_CONCATSTRING, catroutine },
  { 'd', ARG_BOOL, boolroutine },
  { 'e', ARG_BOOL, boolroutine },
  { 'f', ARG_BOOL, boolroutine },
  { 'g', ARG_NOCONCATSTRING, catroutine },
  { 'h', ARG_NOCONCATSTRING, catroutine },
  { 'i', ARG_NOCONCATSTRING, catroutine },
  { 'j', ARG_SWITCH, boolroutine },
  { 'k', ARG_SWITCH, boolroutine },
  { 'l', ARG_SWITCH, boolroutine },
  { 0, 0, 0, }
} ;

static void boolroutine(char select, BOOL arg)
{
  printf("BOOL: %c %d\n", select, arg);
}
static void catroutine(char select, char *arg)
{
  printf("CAT: %c %s\n", select, arg);
}

void main(int argc, char* argv[])
{
  int i;
  banner("Test program");

  if (argc < 2)
    usage(argv[0]);

  printf("%d\n", parse_args(&argc, argv, FALSE));
  for (i=0; i<argc; i++)
    printf("%s\n", argv[i]);

  if (argc > 1) {
    FILE *file;
    printf("dir %d\n",SetDir(argv[1], FALSE));
    file = fopen("junk","w");
    fputs("junk", file);
    fclose(file);
    printf("%d\n", errno);
  }

}

