#ifndef _COMMON_H
#define _COMMON_H

#define VMSG(ms) ms" Version %d.%02d "__DATE__,(VERSION)/100,(VERSION)%100

#include "utype.h"

// Directory buffer size
#define DIR_BUFFER 256

// Directory errors
#define DIR_OK 0
#define DIR_BADFORMAT 2
#define DIR_INVALID 3
#define DRIVE_INVALID 4

// Mode values for ARGLIST
#define ARG_CONCATSTRING 1
#define ARG_NOCONCATSTRING 2
#define ARG_BOOL 3
#define ARG_SWITCH 4

// Valid arg separators
#define ARG_SEPSWITCH '/'
#define ARG_SEPFALSE '-'
#define ARG_SEPTRUE '+'

// Return values for dispatch routine
#define ARG_NEXTCHAR 1
#define ARG_NEXTARG 2
#define ARG_NEXTNOCAT 3
#define ARG_NOMATCH 4
#define ARG_NOARG 5

typedef void (*FILEFUNC)(FILE *input, FILE *output, char *fname);

typedef void (* AFUNC)(char select,char *string);
typedef struct {
  char id;
  uchar mode;
  AFUNC routine;
} ARGLIST;

#ifdef __cplusplus
extern "C" {
#endif

#include "lproto.h"

#ifdef __cplusplus
}
#endif
#endif // _COMMON_H