#include	<stdio.h>
#include    <stdlib.h>
#define	DESCR_LEN 128

FILE *anim;

typedef struct tnode *pnode;

struct tnode {
		    char description[DESCR_LEN];
            pnode left,right;
            };

pnode maintree;

void logo(void); /* display logo */
void usage(void); /* display usage info */
unsigned char length(char *);
pnode newnode(void); /* allocate new node */
void write_trav(pnode); /* traverse the tree in root - left - right order */
pnode read_trav(void); /* traverse the tree in root - left - right order */
void read_in(void); /* read whole database from disk */
void write_to(void); /* write whole database to disk */
int leaf(pnode); /* check whether node n is leaf node */
void add(pnode); /* adds new node to an existing node */
void addnode(pnode,pnode); /* adds new node & updates tree */
void first_time(void); /* first-time database opening */
void query(void); /* query whole database */
void createdb(void); /* create standard database */
void opensdb(void); /* open standard database */

int main(int argc,char *argv[]) /* main function */
{
   logo();
   maintree=NULL;
   if(argc!=1)
      {
      if((anim=fopen(argv[1],"r+"))) read_in();
      else if(!(anim=fopen(argv[1],"w")))
         {
         printf("\n   Can't open specified file %s - opening standard database !",argv[1]);
         usage();
         opensdb();
         }
      }
   else opensdb();
   query();
   write_to();
   fclose(anim);
   return(0);
}

void logo(void) /* display logo */
{
   printf("\n                             Animals V1.00");
   printf("\n   Done by Solar Shadow / aka Predrag Bjelanovic. No rights reserved.\n");
   printf("\n    (Small) try on AI - player (you) imagines an animal and computer");
   printf("\n     needs to guess it, by asking player yes/no type of questions.\n");
}

void usage(void) /* display usage info */
{
   printf("\n   Use : ANIMALS.EXE <name of database>");
   printf("\n   If database of the given name does not exists, standard database");
   printf("\n   ANIMALS.ADB will be created - and automaticaly loaded next time.\n");
}

unsigned char length(char *txt)
{
unsigned char i;
for(i=0;txt[i];i++);
return(i);
}

pnode newnode(void) /* allocate new node */
{
pnode n;
if(!(n=(pnode)malloc(sizeof(struct tnode))))
   {
   printf("\n Memory allocation error ! Aborting ..\n");
   exit(1);
   }
return(n);
}

void write_trav(pnode n) /* traverse the tree in root - left - right order */
{
unsigned char nodes=0,len;
if(n->left) nodes=1;
if(n->right) nodes=2;
len=length(n->description);
fwrite(&len,sizeof(char),1,anim);
fwrite(&n->description,sizeof(char),len,anim);
fwrite(&nodes,sizeof(char),1,anim);
if(nodes>=1) write_trav(n->left);
if(nodes==2) write_trav(n->right);
free(n);
}

pnode read_trav(void) /* traverse the tree in root - left - right order */
{
pnode n;
unsigned char nodes,len;
n=newnode();
fread(&len,sizeof(char),1,anim);
fread(&n->description,sizeof(char),len,anim);
n->description[len]='\0';
fread(&nodes,sizeof(char),1,anim);
n->left=n->right=NULL;
if(nodes>=1) n->left=read_trav();
if(nodes==2) n->right=read_trav();
return(n);
}

void read_in(void) /* read whole database from disk */
{
maintree=read_trav();
}

void write_to(void) /* write whole database to disk */
{
fseek(anim,0L,0);
write_trav(maintree);
}

int leaf(pnode n) /* check whether node n is leaf node */
{
if(!(n->left) && !(n->right)) return(1);
else return(0);
}

void add(pnode tree) /* adds new node to an existing node */
{
pnode n;
n=newnode();
printf("\n\n   Name of animal : ");
gets(n->description);
n->left=n->right=NULL;
tree->right=n;
}

void addnode(pnode prevtree,pnode tree) /* adds new node & updates tree */
{
pnode nd,na;
nd=newnode();na=newnode();
printf("\n\n   Name of animal : ");
gets(na->description);
printf("\n   Description : Is it ... ");
gets(nd->description);
if(prevtree->left==tree) prevtree->left=nd;
else prevtree->right=nd;
nd->left=na;
nd->right=tree;
na->left=na->right=NULL;
}

void first_time(void) /* first-time database opening */
{
pnode n;
printf("\n Opening this database for the first time ... ");
printf("\n Please input first animal & its description.");
maintree=newnode();
n=newnode();
printf("\n\n   Name of animal : ");
gets(n->description);
printf("\n   Description : Is it ... ");
gets(maintree->description);
maintree->left=n;
n->left=n->right=maintree->right=NULL;
}

void query(void) /* query whole database */
{
pnode tree,prevtree;
unsigned char flag;
char answ[3];
if(!maintree) first_time();
do
   {
   tree=prevtree=maintree;
   flag=0;
   printf("\n Truying to guess an animal ...\n");
   while(tree)
      {
      printf("\n Is it %s ? ",tree->description);
      gets(answ);
      if(!leaf(tree)) prevtree=tree;
      else {flag=1;break;}
      if((answ[0]=='n') || (answ[0]=='N')) tree=tree->right;
      else tree=tree->left;
      }
   if((answ[0]=='y') || (answ[0]=='Y'))
      printf("\n AI succeds !!! Found such animal : %s",tree->description);
   else
      {
      printf("\n I cannot recognise such animal ...");
      if(!flag) add(prevtree);
      else addnode(prevtree,tree);
      }
   printf("\nDo you want to try again ? ");
   gets(answ);
   } while((answ[0]!='n') && (answ[0]!='N'));
}

void createdb(void) /* create standard database */
{
   if(!(anim=fopen("ANIMALS.ADB","w")))
      {
      printf("\n   Critical error : Couldn't open ANIMALS.ADB ! Terminating ...\n");
      exit(1);
      }
}

void opensdb(void) /* open standard database */
{
   if(!(anim=fopen("ANIMALS.ADB","r+"))) createdb();
   else read_in();
}
