\XREF.XPL	26-Jan-2006
\Cross-Reference Generator for XPL0 Programs
\ by Loren Blaney
\This program demonstrates the use of binary search trees and linked lists.
\ Ref:  Wirth, N., "Algorithms + Data Structures = Programs," (New Jersey:
\ Prentice-Hall, 1976), pp. 206-210.

\REVISIONS:
\V1.4, Included underline (_) as an identifier character, L.B.
\V1.8, Fix "memory full" bug caused by XED.XPL program (degenerate trees
\ recurse a lot), L.B.
\V1.9, Ported to IBM PC, L.F.
\V2.0, SEP-92, Many enhancements. All described in doc. L.F.
\V2.1, DEC-12-92, Added command-line switch (/I) to include "include" files. L.B.
\V2.2, FEB-03-93, Clean up for shareware example. L.B.
\V2.3, AUG-12-93, Updated for version 2.0 XPL, and fixed "E" bug. L.B.
\V2.4, FEB-16-94, Updated for version 2.1 XPL. Indent included files according
\ to level. L.B.
\V2.5, FEB-27-95, Updated for 16-char names.
\V2.6, 26-Jan-2006, Updated to support in-line assembly code. Entries in cross-
\ reference are no longer shifted to uppercase. Fix tiny bug: "ifFrog" is allowed

include C:\CXPL\CODESI;

def	TAB=$09, LF=$0A, FF=$0C, EOF=$1A, SP=$20;

def	IDLEN=16,	\Number of characters in an identifier (name)
	MAXREF=7,	\Maximum number of references per line in output
	NULL=0;		\Empty entry in tree

def	\TREEENTRY\	\Components of a tree entry:
	FIRST,		\Pointer to first entry in linked list
	LAST,		\Pointer to last entry in linked list
	LEFT,		\Pointer to left branch of tree
	RIGHT,		\Pointer to right branch of tree
	KEY;		\Identifier characters (must be last)
def	\LISTENTRY\	\Components of a linked-list entry:
	LNO,		\Line number of identifier
	NEXT;		\Pointer to next entry in the list

char	IDENT;		\Identifier character array
int	ROOT;		\Pointer to the start of the search tree
int	LEN,		\Index into IDENT array
	CHAR,		\The current character read by GETCH
	LINENO,		\Current line number of the listing
	TOPMEM,		\Top of memory space available to ALLOCATE
	AMT,		\Amount of memory available to ALLOCATE
	RAM,		\Pointer to base of unALLOCATEd memory space
	A1, A2, A3,	\First three characters of reserved word (for includes)
	Asm1, Asm2;	\Flags for in-line assembly code
\For DOS I/O:
int	CPUREG,		\Address of copy of CPU registers
	INHAND,		\Input file handle
	OUTHAND;	\Output file handle

\For include files:
int	INCLUDING,	\Flag: Include include files in cross-reference listing
	HANDINX,	\Index into HANDLES (level of include nesting)
	HANDLES;	\Array: Handles for (nested) include files
def	HANDMAX=8;	\Maximum number of include handles (nesting depth)



func	ToUpper(Ch);	\Convert character to uppercase
int	Ch;
return if Ch>=^a & Ch<=^z then Ch&$DF else Ch;



proc	GETCH;		\Get next character from input file and output it.
begin			\This filters out meta (^) characters.
CHAR:= CHIN(3);
if CHAR#EOF then CHOUT(3, CHAR);
if CHAR=^^ then
	begin
	CHAR:= CHIN(3);   CHOUT(3, CHAR);
	CHAR:= CHIN(3);   if CHAR#EOF then CHOUT(3, CHAR);
	end;
end;	\GETCH



proc	ERROR(S);	\Display error message
int	S;
begin
TEXT(0, S);
CRLF(0);
end;	\ERROR



proc	NEWLINE;	\Start a new line on the cross-reference listing
begin
LINENO:= LINENO+1;
INTOUT(3, LINENO);   CHOUT(3, TAB);
end;	\NEWLINE

\----------------------- ROUTINES TO HANDLE INCLUDE FILES ----------------------

proc	FALLBACK;	\Terminate include file and fall back to parent file
begin
FCLOSE(INHAND);
HANDINX:= HANDINX -1;
INHAND:= HANDLES(HANDINX);
\Only the main file gets the big buffer
FSET(INHAND, if HANDINX=0 then ^I else ^i);
end;	\FALLBACK



proc	DOINCLUDE;	\Open an include file for input
char	NAME;
def	NAMEMAX = 80;
int	NEWHAND, I;


	func	GETNAME;	\Read a file name
	int	EXTFLG, I, K;
	char	DEFEXT;
	begin
	DEFEXT:= ".XPL";
	EXTFLG:= false;

	\Eat leading spaces and control chars (tabs, carriage returns, etc.)
	while CHAR <= $20 do
		if CHAR = EOF then return false else GETCH;

	\Copy file name into NAME
	K:= 0;
	loop	begin
		case CHAR of
		  ^.:	EXTFLG:= true;
		  LF:	return false;
		  ^;:	quit
		other;

		NAME(K):= CHAR;
		K:= K +1;
		if K >= NAMEMAX then return false;
		GETCH;
		end;

	\Deal with empty file name
	if K = 0 then return false;

	if EXTFLG then NAME(K-1):= NAME(K-1) ! $80	\Terminate name
	else	begin					\Add default extension
		if (K+4) >= NAMEMAX then return false;
		for I:= 0, 3 do NAME(K+I):= DEFEXT(I);
		end;
	return true;		\Indicate success
	end;	\GETNAME


begin	\DOINCLUDE
NAME:= RESERVE(NAMEMAX);
if HANDINX >= HANDMAX then
	begin
	ERROR("Include files nested too deep. File ignored.");
	while CHAR#^; & CHAR#EOF do GETCH;
	return;
	end;

if not GETNAME then
	begin
	ERROR("Bad include file name.");
	while CHAR#^; & CHAR#EOF do GETCH;
	return;
	end;

if not INCLUDING then
	begin
	while CHAR#^; & CHAR#EOF do GETCH;
	return;
	end;

CRLF(3);
NEWLINE;

\Open include file
TRAP($FFFB);				\XPL bug: S/B: $FFF7
NEWHAND:= FOPEN(NAME, 0);
TRAP($FFFF);
if GETERR = 3 then
	begin
	TEXT(0, "Cannot open include file: ");
	TEXT(0, NAME);   CRLF(0);
	return;
	end;

HANDLES(HANDINX):= INHAND;		\Save old file handle in array
HANDINX:= HANDINX +1;
INHAND:= NEWHAND;

FSET(INHAND, ^i);			\Include files always use small buffers

TEXT(0, "INCLUDING: ");
for I:= 2, HANDINX do TEXT(0, "   ");
TEXT(0, NAME);   CRLF(0);
end;	\DOINCLUDE

\-------------------------------------------------------------------------------

func	ALLOCATE(AMOUNT);
\"Reserves" memory, but, unlike the reserve intrinsic, this procedure
\ doesn't return the space to the heap memory pool when the calling
\ procedure returns. In this respect allocate behaves like the Pascal
\ intrinsic "New."
int	AMOUNT;		\Number of bytes to allocate
int	TEMP;
begin
TEMP:= RAM;
RAM:= RAM + AMOUNT;	\Reserve bytes

if (RAM>>1) > (TOPMEM>>1) then
	begin
	CRLF(0);   TEXT(0, "Out of memory. File is too big.");
	CRLF(0);   exit;
	end;
return TEMP;
end;	\ALLOCATE



proc	SEARCH(ADDRTREEENTRY);
\Search the tree. If the identifier (IDENT) is not present then insert it.
\ Otherwise append the line number (LINENO) to the identifier's linked list.
int	ADDRTREEENTRY;	\Address of pointer to the tree entry
int	TREEENTRY,	\Pointer to the tree entry
	LISTENTRY,	\Pointer to the linked-list entry
	N;		\Scratch
char	ID;		\Identifier character string entry in tree
begin
TREEENTRY:= ADDRTREEENTRY(0);
if TREEENTRY = NULL then		\Key is not in tree so insert it
	begin
	TREEENTRY:= ALLOCATE(IDLEN+8);   LISTENTRY:= ALLOCATE(4);
	ID:= TREEENTRY + 2*KEY;		\Point ID to identifier
	for N:= 0, IDLEN-1 do ID(N):= IDENT(N);
	TREEENTRY(LEFT):= NULL;   TREEENTRY(RIGHT):= NULL;
	TREEENTRY(FIRST):= LISTENTRY;   TREEENTRY(LAST):= LISTENTRY;
	LISTENTRY(LNO):= LINENO;   LISTENTRY(NEXT):= NULL;
	ADDRTREEENTRY(0):= TREEENTRY;	\Link in new tree entry
	return;
	end;
ID:= TREEENTRY + 2*KEY;			\Point ID to identifier in tree entry
loop	begin
	for N:= 0, IDLEN-1 do if ToUpper(IDENT(N)) # ToUpper(ID(N)) then quit;
	LISTENTRY:= ALLOCATE(4);	\Identifier found
	LISTENTRY(LNO):= LINENO;	\Insert line number
	LISTENTRY(NEXT):= NULL;
	TREEENTRY(LAST,NEXT):= LISTENTRY;  \Link new entry into list
	TREEENTRY(LAST):= LISTENTRY;	   \Keep track of last entry
	return;
	end;
if ToUpper(IDENT(N)) < ToUpper(ID(N)) then SEARCH(TREEENTRY + 2*LEFT)
	\Pass the address of the pointer for the left branch
else \IDENT(N) > ID(N)\ SEARCH(TREEENTRY + 2*RIGHT);
end;	\SEARCH



proc	ENTRYOUT(TREEENTRY);
\Output the identifier name followed by all its line-number references.
\ In other words, output one tree entry.
int	TREEENTRY;
int	REFCNT,
	LISTENTRY,
	N;
begin
TEXT(3, "       ");
TEXT(3, TREEENTRY +2*KEY);	\Output identifier name
\Output the line no. references by following the list linkages
LISTENTRY:= TREEENTRY(FIRST);
REFCNT:= 0;
N:= 0;
repeat	if REFCNT >= MAXREF then
		[CRLF(3);   TEXT(3, "		");   REFCNT:= 0];
	REFCNT:= REFCNT +1;
	N:= N +1;
	CHOUT(3, TAB);   INTOUT(3, LISTENTRY(LNO));
	LISTENTRY:= LISTENTRY(NEXT);
until LISTENTRY = NULL;
if N = 1 then TEXT(3, " *");		\Flag name that is only used once
CRLF(3);
end;	\ENTRYOUT



proc	TREEOUT(TREEENTRY);
\Output the entire tree in (alphabetical) order. In other words, output
\ the cross-reference listing.
int	TREEENTRY;
begin
if TREEENTRY # NULL then
	begin
	TREEOUT(TREEENTRY(LEFT));
	ENTRYOUT(TREEENTRY);
	TREEOUT(TREEENTRY(RIGHT));
	end;
end;	\TREEOUT

\-------------------------------------------------------------------------------

func	DOSOPEN;	\Open I/O files, return false if syntax error
int	PSPSEG, DATASEG;
char	CMDTAIL;


	func	PARSE;
	\Parse command tail, set up INHAND & OUTHAND, and open I/O files.
	\Also outputs INCLUDING switch. Returns false if error.
	char	EXTIN, EXTOUT;
	int	P, I;
	begin
	\Handle INCLUDING switch then strip it out of command tail
	INCLUDING:= false;
	for P:= 1, CMDTAIL(0) do
		begin
		if CMDTAIL(P) = ^/ then
			begin
			CMDTAIL(P):= SP;  \Overwrite switch with spaces
			P:= P +1;
			if P > CMDTAIL(0) then return false;
			if CMDTAIL(P)=^I ! CMDTAIL(P)=^i then INCLUDING:= true
			else return false;
			CMDTAIL(P):= SP;
			end;
		end;

	EXTIN:= ".XPL";   EXTOUT:= ".XRF";	\Default extensions
	P:= 1;
	\Scan command tail for extension, if none then add default extension
	loop	begin
		if CMDTAIL(P) = ^. then quit;
		P:= P +1;
		if P > CMDTAIL(0) then
			begin
			for I:= 0, 3 do CMDTAIL(P+I):= EXTIN(I);
			quit;
			end;
		end;

	\Open input file
	TRAP($FFFB);			\XPL bug: S/B: $FFF7
	INHAND:= FOPEN(CMDTAIL+1, 0);
	TRAP($FFFF);
	if GETERR = 3 then return false;

	\Set output extension and open output file
	for I:= 0, 3 do CMDTAIL(P+I):= EXTOUT(I);
	TRAP($FFFB);			\XPL bug: S/B: $FFF7
	OUTHAND:= FOPEN(CMDTAIL+1, 1);
	TRAP($FFFF);
	if GETERR = 3 then return false;

	return true;
	end;	\PARSE


begin	\DOSOPEN
CMDTAIL:= RESERVE($80+4);		\Get command tail from PSP
CPUREG:= GETREG;
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);
BLIT(PSPSEG, $80, DATASEG, CMDTAIL, $80);

if not PARSE then return false;		\Parse command line and set handles

FSET(INHAND, ^I);			\Set handles for device 3
FSET(OUTHAND, ^O);
return true;				\Indicate success
end;	\DOSOPEN



proc	SHOWHELP;	\Display help info
begin
TEXT(0, "Cross Reference Utility for XPL0
Usage: XREF [/I] filename [.extension]
   /I: Include ^"include^" files
");
end;	\SHOWHELP

\-------------------------------------------------------------------------------

begin	\MAIN
IDENT:= RESERVE(IDLEN);
HANDLES:= RESERVE(HANDMAX*2);	\For include files

AMT:= FREE -2000;		\Available memory minus some working space
RAM:= RESERVE(AMT);
TOPMEM:= RESERVE(0) -10;

TEXT(0, "
-- CROSS REFERENCE, VER 2.6 --

");

ROOT:= NULL;   LINENO:= 0;   HANDINX:= 0;
Asm1:= false;  Asm2:= false;

if not DOSOPEN then [SHOWHELP;   exit];
OPENO(3);   OPENI(3);

NEWLINE;
GETCH;
loop	begin
	if CHAR = EOF then if HANDINX > 0 then FALLBACK else quit;
	if CHAR>=^0 & CHAR<=^9 then				\Number
		begin						\Skip it
		repeat	GETCH
		until CHAR<^0 ! CHAR>^9 ! CHAR#^.;
		if CHAR=^E ! CHAR=^e then GETCH;
		end
	else if CHAR>=^a & CHAR<=^z then			\Reserved word
		begin
		A1:= CHAR;   GETCH;   A2:= CHAR;   GETCH;   A3:= CHAR;
		while CHAR>=^a & CHAR<=^z do GETCH;		\Skip it
		if A1=^a & A2=^s & A3=^m then Asm1:= true;
		if A1=^i & A2=^n & A3=^c & not Asm1 & not Asm2 then
			[DOINCLUDE;   GETCH];	\ignore "asm inc ax" etc.
		end
	else if CHAR>=^A & CHAR<=^Z ! CHAR=^_ then		\Identifier
		begin
		LEN:= 0;
		repeat	if LEN < IDLEN then	\Put identifier into IDENT
				begin
				IDENT(LEN):= CHAR;
				LEN:= LEN+1;
				end;
			GETCH;
		until (CHAR<^a ! CHAR>^z) & (CHAR<^A ! CHAR>^Z) &
		      (CHAR<^0 ! CHAR>^9) & CHAR#^_;
						\Fill out IDENT with spaces
		for LEN:= LEN, IDLEN-1 do IDENT(LEN):= SP;
		IDENT(IDLEN-1):= IDENT(IDLEN-1) ! $80;	\Terminate string
		SEARCH(addr ROOT);
		end
	else	begin	   			\Skip strings, comments,
		case CHAR of			\ hex numbers, etc.
		  ^":	begin
			repeat	GETCH;
				if CHAR = EOF then quit;
				if CHAR = LF then NEWLINE;
			until CHAR = ^";
			GETCH;
			end;
		  ^':	begin
			repeat	GETCH;		\Compressed strings
				if CHAR = EOF then quit;
				if CHAR = LF then NEWLINE;
			until CHAR = ^';
			GETCH;
			end;
		  ^\:	begin
			repeat	GETCH;
				if CHAR = EOF then quit;
			until CHAR=^\ ! CHAR=LF;
			if CHAR=^\ then GETCH;
			end;
		  ^$:	begin
			repeat GETCH;
			until (CHAR<^0 ! CHAR>^9) & (CHAR<^A ! CHAR>^F) &
				(CHAR<^a ! CHAR>^f);
			end;
		  ^{:	[Asm2:= true; GETCH];
		  ^}:	[Asm2:= false; GETCH];
		  ^;:	begin			\Skip assembly comments
			if Asm1 ! Asm2 then 
				begin
				repeat	GETCH;
					if CHAR = EOF then quit;
				until CHAR=LF;
				end
			else	GETCH;		\Skip semicolon
			end
		other	GETCH;
		end;
	if CHAR = LF then [NEWLINE; Asm1:= false];
	end;

CRLF(3);
CHOUT(3, FF);
TREEOUT(ROOT);
CHOUT(3, EOF);

CLOSE(3);
FCLOSE(OUTHAND);
FCLOSE(INHAND);
end;	\MAIN
