\STDDEF.XPL	13-Feb-2006
\Standard Library Definitions

\REVISIONS:
\MAR-02-95, V2.2, Modified: WaitVB, TextIn, Box, and StrCmp; added StrNFill,
\ BCD2Str, Str2BCD and CallInt. Eliminate CpuReg names (AX, BX etc.)--use
\ CallInt instead.
\13-Feb-2006, Changed some comments, that's all.

\WARNINGS:
\Don't forget to set CpuReg in your main procedure, i.e: CpuReg:= Getreg;

inc	C:\CXPL\CODESI;		\Include code definitions for intrinsic routines

def	IntSize= 2,		\Number of bytes in an integer (2 or 4)
	MaxForSize=$7FFE;	\Largest limit in a for loop

def	Nul=$00, Bel=$07, BS=$08, Tab=$09, LF=$0A, FF=$0C,	\Control chars
	CR=$0D, EOF=$1A, Esc=$1B, Sp=$20, Ctrl=$40;

def	UpArrow=$48, DnArrow=$50, LfArrow=$4B, RtArrow=$4D,	\Scan codes
	PageUp=$49, PageDn=$51, Home=$47, End=$4F, Insert=$52, Delete=$53,
	Func1=$3B;

def	Black, Blue, Green, Cyan, Red, Magenta, Brown, White,	\Attribute colors
	Gray, LBlue, LGreen, LCyan, LRed, LMagenta, Yellow, BWhite; \ EGA palette

def	Pi = 3.14159265358979323846;

int	CpuReg,			\Address of CPU register array (from Getreg)
	Get100sec,		\100ths of seconds from GetTime function
	HaveMouse;		\A mouse driver is installed and mouse works

efunc	AHexToI(Str);		\Convert string of hex ASCII digits to integer
eproc	AlignPalette;		\Make palette regs correspond to VGA regs (DAC)
efunc real ALog(X);		\Antilog (or 10**X)
efunc	AtoI(Str);		\Convert string of ASCII digits to an integer
efunc real ATan(Y);		\Arc tangent
efunc real AtoF(Str);		\Convert string of ASCII digits to floating pt.
eproc	BCD2Str(From, To, Size);\Convert BCD string to ASCII string
eproc	Blink(On);		\Turn video blinking off and on (intense colors)
efunc	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt
eproc	Ctxt(X, Y, Str);	\Cursor to X,Y and display string on device 6
eproc	DateOut(Dev, Date);	\Output Date (MM-DD-YY) (Date is DOS format)
efunc real Deg(X);		\Convert radians to degrees
eproc	Delay(T);		\Delay T microseconds (T is unsigned)
eproc	DrawBox(X1, Y1, X2, Y2, T); \Draw a rectangle using type T box chars
efunc real Fact(X);		\Factorial of a positive real
efunc real FloatUnsign(N);	\Convert a 16-bit, unsigned integer to a real
efunc real Frac(X);		\Get fractional part of real number
eproc	FtoA(F, Str);		\Convert real number F to string of ASCII digits
efunc	GetCurShape;		\Get cursor shape
efunc	GetDate;		\Get current date in DOS packed format
efunc	GetKey;			\Get character from keyboard (wait if necessary)
efunc	GetMouseButton(N);	\Return true if mouse button is down (L=0, R=1)
efunc	GetMousePosition(N);	\Get position of mouse coordinate (X=0, Y=1)
efunc	GetPage;		\Get active video page
efunc	GetTime;		\Get current time in DOS packed format
efunc	GetVid;			\Get current video mode
eproc	Hex1out(Dev, N);	\Output a hex digit
eproc	Hex2out(Dev, N);	\Output two hex digits (a byte)
eproc	HLine(X1, Y1, X2, T);	\Draw a horizontal line using type T box chars
efunc real Hypot(X, Y);		\Hypotenuse of right triangle with sides X & Y
efunc real Int(X);		\Get integer part of real number
efunc	IntLen(N);		\Return number of digits in decimal integer N
efunc	IsAlnum(Ch);		\Is character alphanumeric?
efunc	IsAlpha(Ch);		\Is character alphabetic?
efunc	IsDigit(Ch);		\Is character a digit?
efunc	IsHexDigit(Ch);		\Is character a hexadecimal digit?
efunc	IsLower(Ch);		\Is character lowercase?
efunc	ISqrt(N);		\Square root of a positive integer N
efunc	ISqr(N);		\Square an integer N
efunc	IsUpper(Ch);		\Is character uppercase?
eproc	ItoAHex(I, Str); 	\Convert integer I to string of hex ASCII digits
eproc	ItoA(I, Str);		\Convert number I to a string of ASCII digits
eproc	Justout(Dev, N, Places, Fill); \Output a right-justified decimal integer
efunc	LookKey;		\Get next keystroke without reading it in
efunc	Max(A, B);		\Return the larger of the arguments
efunc	Min(A, B);		\Return the smaller of the arguments
eproc	MoveMouse(X, Y);	\Move mouse pointer to X,Y
efunc	OpenMouse;		\Initialize mouse; return 'false' if no mouse
efunc real Power(X, Y);		\X raised to the Y power
efunc real Rad(X);		\Convert degrees to radians
efunc	ReadChar(X, Y);		\Get character and attribute at X,Y
eproc	RloutComma(Dev, X);	\Output a real with commas (e.g: 12,345,678.90)
efunc	Rol(N, C);		\Rotate N left C bits
efunc	Ror(N, C);		\Rotate N right C bits
eproc	SecOut(Dev);		\Output seconds from GetTime (:ss.ss)
eproc	SetBorder(C);		\Set border color register
eproc	SetColReg(N, R, G, B);	\Set VGA color register (DAC) N
eproc	SetCurShape(Shape);	\Set cursor shape ($000D = solid block)
eproc	SetPage(P);		\Set video page for writing and viewing
eproc	SetPalReg(N, C);	\Set palette register
efunc	ShiftKey;		\Returns 'true' if a shift key is down
eproc	ShowCursor(On);		\Turn flashing cursor off and on
eproc	ShowMouse(On);		\Turn mouse pointer on or off
eproc	SpOut(Dev, N);		\Output N spaces to specified device
efunc real Sqr(N);		\Square a real
eproc	Str2BCD(From, To, Size);\Convert string of ASCII digits to BCD string
eproc	StrCat(S1, S2);		\Append terminated strings S2 onto S1
efunc	StrChr(Str, Chr);	\Get address of Chr in Str; return 0 if none
efunc	StrCmp(A, B);		\Compare terminated string A to string B
eproc	StrCopy(A, B);		\Copy terminated string: A -> B
efunc	StrLen(Str);		\Get number of characters in a terminated string
efunc	StrNAdd(A, B, N);	\Multiprecision add ASCII string: A + B -> B
efunc	StrNCmp(A, B, N);	\Compare string A to string B up to N bytes long
eproc	StrNCopy(A, B, N);	\Copy string that is N bytes long: A -> B
eproc	StrNFill(Str, N, Pat);	\Fill string of length N with pattern Pat
efunc	StrNMul(A, B, C, N);	\Multiprecision multiply ASCII str: A * B -> C
efunc	StrNSub(A, B, N);	\Multiprecision subtract ASCII str: A - B -> B
efunc	SwapBits(N);		\Swap the order of the bits in integer N
eproc	Terminate(Str, N);	\Terminate string by setting MSB on last char
eproc	TextCenter(Dev, Str, Len); \Display a string centered on a line
eproc	TextIn(Dev, Str, N);	\Input string of max length N or ending with CR
eproc	TextN(Dev, Str, N);	\Output a string that is N bytes long
eproc	TextZ(Dev, Str);	\Output a zero-terminated string
eproc	TimeOut(Dev, Time);	\Output Time (e.g: 5:43p) (Time is DOS format)
efunc	ToLower(Ch);		\Convert character to lowercase
efunc	ToUpper(Ch);		\Convert character to uppercase
efunc	Unterminate(Str);	\Unterminate string by clearing MSB on last char
eproc	VLine(X1, Y1, Y2, T);	\Draw a horizontal line using type T box chars
eproc	WaitKey;		\Wait for a keystroke
eproc	WaitVB;			\Wait for beginning of next vertical blank
eproc	Wait(T);		\Wait T 18ths of a second or until keystroke
eproc	WeekDay(Date);		\Return day of week (0=Sun, 1=Mon, ... 6=Sat)
