\MINESWPR.XPL	JUL-09-95
\
\                       Minesweeper without Windows!
\                             by Loren Blaney
\
\ How fast can you mark the mines without blowing yourself up? Use the
\ left mouse button to uncover a square. Use the right button to mark, or
\ unmark, a mine.
\
\ The numbers show how many mines are in the eight surrounding squares.
\ When the mines are correctly marked, clicking with the left button on a
\ number quickly clears the surrounding tiles. (Unlike the Windows version,
\ you shouldn't press both buttons simultaneously.) If a square is marked
\ wrong, well, too bad.
\
\ Above the mine field, the number on the left shows the remaining unmarked
\ mines, and the number on the right shows the seconds since the beginning
\ of the game.
\
\ You can change the difficulty by adjusting FW and FH in the procedure
\ PlayGame. FH wants to be an even number <= 22, and FW should be <= 38.



int	VideoMode,	\Original video mode to be restored upon exit
	II;		\Scratch for Main

include	\CXPL\STDLIB.XPL; \Include library routines after declaring globals



proc	Exit;		\Make a graceful exit
int	I;
begin
Openi(0);		\Discard any pending keystrokes
SetVid(VideoMode);	\Restore original video mode
exit;
end;	\Exit



proc	Click;		\Make a click sound
begin
Sound(false, 1, 3000);	\Sync to system clock so click always sounds the same
Sound(1, 1, 3000);
end;	\Click



func	GetSec;		\Get seconds in BCD from CMOS time/date chip
begin
CallInt($1A, $0200);
return Cpureg(3)>>8;
end;	\GetSec



proc	Rectangle(X0, Y0, X1, Y1, C);	\Draw a filled rectangle
int	X0, Y0,	X1, Y1, C;	\Coordinates of opposite corners and color
int	J;
for J:= Y0, Y1 do
	[Move(X0, J);   Line(X1, J, C)];



proc	DrawTile(X,Y,Ch);	\Draw a tile (a covered cell)
int	X, Y,	\Screen coordinates of upper-left corner of tile
	Ch;	\Character on tile (marking symbol or blank)
begin
ShowMouse(false);		\Don't let mouse interfere
Rectangle(X, Y, X+15, Y+15, White);

Attrib(White<<4+Black);
Cursor((X+7)/8, Y/16);
Chout(6, Ch);

Move(X, Y);        Line(X+14, Y, BWhite);
Move(X, Y+1);      Line(X+13, Y+1, BWhite);
Move(X, Y+2);      Line(X, Y+14, BWhite);
Move(X+1, Y+2);    Line(X+1, Y+13, BWhite);

Move(X+2, Y+14);   Line(X+15, Y+14, Gray);
Move(X+1, Y+15);   Line(X+15, Y+15, Gray);
Move(X+14, Y+2);   Line(X+14, Y+13, Gray);
Move(X+15, Y+1);   Line(X+15, Y+13, Gray);
ShowMouse(true);
end;	\DrawTile



proc	DrawEmpty(X,Y,Ch,Atb);	\Draw an empty (uncovered) cell location
int	X, Y,		\Screen coordinates of upper-left corner of empty cell
	Ch, Atb;	\Character and attribute
begin
ShowMouse(false);		\Don't let mouse interfere
Rectangle(X, Y, X+14, Y+14, Atb>>4);

Attrib(Atb);
Cursor((X+7)/8, Y/16);
Chout(6, Ch);

Move(X+15, Y);   Line(X+15, Y+15, Gray);
Move(X, Y+15);   Line(X+15, Y+15, Gray);
ShowMouse(true);
end;	\DrawEmpty

\===============================================================================

proc	PlayGame;		\Play one game
def	FW = 12,  FH = 12,	\Mine field width & height in cells (adjustable)
	Mines = FW*FH/6,	\Number of mines
	X0 = (640-FW*16)/2,	\Screen coords of upper-left corner of field
	Y0 = (480-FH*16)/2,	\ (Each cell is 16 pixels square)
	CountX = X0/8+4,	\Character coords where Count and Timer are
	CountY = Y0/16-2,	\ displayed
	TimerX = (X0+FW*16)/8 -8,
	TimerY = CountY,
	BkgndColor = Blue;	\Background color
char	Field(FW,FH);		\The mine field--array of cells
def	Mined=$01, Covered=$02, Marked=$04; \Bits indicating state of Field cell
int	Count,			\Count of the number of unmarked mines
	I, J,			\Auxillary Field cell coordinates (cells)
	M, N,			\Scratch counter
	Oops,			\Flag: uncovered a mine
	Timer,			\Elapsed time in seconds since beginning of game
	Timer0,			\Determines when a full second has elapsed
	X, Y;			\Field cell coordinates (cells)



proc	ShowCount;		\Show count of unmarked mines
begin
ShowMouse(false);
Cursor(CountX, CountY);
Attrib(BkgndColor<<4+Yellow);
if Count<100 then Chout(6, Sp);			\Right justify
if Count<10 & Count>=0 then Chout(6, Sp);
Intout(6, Count);
ShowMouse(true);
end;	\ShowCount



proc	ShowTimer;		\Show number of seconds since beginning of game
begin
ShowMouse(false);
Cursor(TimerX, TimerY);
Attrib(BkgndColor<<4+Yellow);
if Timer < 100 then Chout(6, Sp);		\Right justify
if Timer < 10 then Chout(6, Sp);
Intout(6, Timer);
ShowMouse(true);
end;	\ShowTimer



proc	Uncover(X,Y);		\Uncover a cell
int	X, Y;			\Field cell coordinates
int	I, J, N;
begin
if Field(X,Y) & Marked then return;		\Don't uncover a marked cell
if Oops then return;				\In case we're recursed

Field(X,Y):= Field(X,Y) & ~Covered;		\Uncover the cell
if Field(X,Y) & Mined then			\If cell is mined...
	begin
	Oops:= true;				\Hasta la vista
	WaitVB;
	SetPalReg(BkgndColor, BWhite);		\Flash screen
	WaitVB;
	SetPalReg(BkgndColor, BkgndColor);
	Click;					\(Boom)
	for J:= 0, FH-1 do			\Show all of the mines
	    for I:= 0, FW-1 do
		if I>=0 & I<FW & J>=0 & J<FH then
		    if Field(I,J) & Mined then
			DrawEmpty(X0+I*16-4, Y0+J*16, ^, White<<4);
	DrawEmpty(X0+X*16-4, Y0+Y*16, ^, Red<<4);
	end
else	begin					\Cell is not mined...
	N:= 0;					\Count the surrounding mines
	for J:= Y-1, Y+1 do
	    for I:= X-1, X+1 do
		if I>=0 & I<FW & J>=0 & J<FH then  \Don't go outside of field
		    if Field(I,J) & Mined then N:= N +1;
	DrawEmpty(X0+X*16-4, Y0+Y*16, if N=0 then Sp else N+$30, White<<4+N|8);

	\If there were no surrounding mines then uncover the surrounding cells
	if N = 0 then
	    for J:= Y-1, Y+1 do
	        for I:= X-1, X+1 do
		    if I>=0 & I<FW & J>=0 & J<FH then
		        if Field(I,J) & Covered then Uncover(I,J);
	end;
end;	\Uncover

\-------------------------------------------------------------------------------

begin	\PlayGame
for Y:= 0, FH-1 do				\Set up the mine field
    for X:= 0, FW-1 do
        Field(X,Y):= Covered;
N:= 0;
loop	begin					\Plant "Mines" number of mines
	X:= Ran(FW);				\ in random locations
	Y:= Ran(FH);
	if (Field(X,Y) & Mined) = 0 then	\Don't plant two mines in the
		[Field(X,Y):= Mined ! Covered;	\ same location
		N:= N +1];
	if N >= Mines then quit;
	end;
Oops:= false;

ShowMouse(false);				\Draw a box with tiles in it
Rectangle(0, 0, 640-1, 480-1, BkgndColor);	\Clear screen
Rectangle(X0-4-8, Y0-8, X0-4+FW*16+8, Y0+FH*16+8, White);

Move(X0-4-8, Y0-8);   Line(X0-4+FW*16+7, Y0-8, BWhite);
Move(X0-4-8, Y0-7);   Line(X0-4+FW*16+6, Y0-7, BWhite);
Move(X0-4-8, Y0-6);   Line(X0-4-8, Y0+FH*16+7, BWhite);
Move(X0-4-7, Y0-6);   Line(X0-4-7, Y0+FH*16+6, BWhite);

Move(X0-4, Y0+FH*16+1);   Line(X0-4+FW*16+2, Y0+FH*16+1, BWhite);
Move(X0-4-1, Y0+FH*16+2); Line(X0-4+FW*16+2, Y0+FH*16+2, BWhite);
Move(X0-4+FW*16+1, Y0);   Line(X0-4+FW*16+1, Y0+FH*16, BWhite);
Move(X0-4+FW*16+2, Y0-1); Line(X0-4+FW*16+2, Y0+FH*16, BWhite);

Move(X0-4-2, Y0-2); Line(X0-4+FW*16+1, Y0-2, Gray);
Move(X0-4-2, Y0-1); Line(X0-4+FW*16, Y0-1, Gray);
Move(X0-4-2, Y0);   Line(X0-4-2, Y0+FH*16+1, Gray);
Move(X0-4-1, Y0);   Line(X0-4-1, Y0+FH*16, Gray);

Move(X0-4-7, Y0+FH*16+8);   Line(X0-4+FW*16+7, Y0+FH*16+8, Gray);
Move(X0-4-6, Y0+FH*16+7);   Line(X0-4+FW*16+6, Y0+FH*16+7, Gray);
Move(X0-4+FW*16+8, Y0-7);   Line(X0-4+FW*16+8, Y0+FH*16+7, Gray);
Move(X0-4+FW*16+7, Y0-6);   Line(X0-4+FW*16+7, Y0+FH*16+6, Gray);
ShowMouse(true);

for Y:= 0, FH-1 do
    for X:= 0, FW-1 do
	DrawTile(X0+X*16-4, Y0+Y*16, Sp);

Count:= Mines;					\Initialize Count and Timer
ShowCount;
Timer:= 0;
ShowTimer;

Openi(1);					\Discard any pending keystrokes
while GetMouseButton(0) ! GetMouseButton(1) do;	\Wait for buttons to be released
repeat if Chkkey then Exit;			\Wait for first button press
until GetMouseButton(0) ! GetMouseButton(1);
Timer0:= GetSec;				\Start the timer

loop	begin
	X:= (GetMousePosition(0) - X0 + 4) /16;	\Get cell coordinates pointed
	Y:= (GetMousePosition(1) - Y0) /16;	\ to by the mouse
	if X>=0 & X<FW & Y>=0 & Y<FH then	\If in the mine field...
		begin
		if GetMouseButton(0) then	\If left button, uncover a tile
			begin
			if Field(X,Y) & Covered then Uncover(X,Y)
			else	begin		\Clear around marked mines
				M:=0;   N:= 0;	\Count surrounding mines & marks
				for J:= Y-1, Y+1 do
				    for I:= X-1, X+1 do
					if I>=0 & I<FW & J>=0 & J<FH then
					    begin    \Don't look outside field
					    if Field(I,J) & Mined then N:= N +1;
					    if Field(I,J) & Marked then M:=M +1;
					    end;
				if M = N then	\If marks = mines, clear around
				    for J:= Y-1, Y+1 do \(wrong marks are fatal)
				        for I:= X-1, X+1 do
					    if I>=0 & I<FW & J>=0 & J<FH then
					        if Field(I,J) & Covered then
						    Uncover(I,J);
				end;
			if Oops then quit;	\You lose!
			repeat until not GetMouseButton(0);  \Wait for release
			end;
		if GetMouseButton(1) then	\If right button then mark mine
			begin
			if Field(X,Y) & Covered then
				begin		\Mark (or unmark) mine
				Field(X,Y):= Field(X,Y) | Marked;
				if Field(X,Y) & Marked then
					[N:= ^X;   Count:= Count -1]
				else	[N:= Sp;   Count:= Count +1];
				DrawTile(X0+X*16-4, Y0+Y*16, N);
				ShowCount;
				end;
			if Count = 0 then
				begin		\Won if exactly "Mined" number
				N:= 0;		\ of cells are correctly marked
				for J:= 0, FH-1 do
				    for I:= 0, FW-1 do
				        if Field(I,J) & Marked then
				            if Field(I,J) & Mined then N:= N +1;
				if N = Mines then
					begin
					Attrib(BkgndColor<<4+BWhite);
					Ctxt(80/2-6, CountY-2, "YOU DID IT!");
					quit;	\You won!
					end;
				end;
			repeat until not GetMouseButton(1);  \Wait for release
			end;
		end;
	if Chkkey then Exit;		\Any keystroke exits program
	if Timer0 # GetSec then		\Update timer display once per second
		begin
		Timer0:= GetSec;
		Timer:= Timer +1;
		ShowTimer;
		end;
	if ShiftKey then		\Cheat
		Point(1, 1, if Field(X,Y)&Mined then BWhite else BkgndColor);
	end;	\loop
while GetMouseButton(0) ! GetMouseButton(1) do; \Wait for buttons released
Sound(0, 18, 1);			\Debounce button-happy players
repeat if Chkkey then Exit;		\Press mouse button for next game
until GetMouseButton(0) ! GetMouseButton(1); \ (or any key to exit)
end;	\PlayGame

\-------------------------------------------------------------------------------

begin	\Main
II:= Equip;
if (II(2)&$08) = 0 then
	[Text(0, "

This program requires a VGA display.
");   exit];
VideoMode:= GetVid;
Setvid($12);				\640x480x16
Trapc(true);				\Don't let Ctrl-C make an awkward exit

if not OpenMouse then
	[Text(0, "This program requires a mouse.

Press Enter to continue...");
	WaitKey;   Exit];		\(Changing video modes erases screen)
MoveMouse(640/2, 480/2);		\Show mouse pointer in center of screen
ShowMouse(true);

loop PlayGame;				\Play games until a keystroke exits
end;	\Main
