'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//             Zip Studio 2.0 COPYRIGHT 1993, 1994 HEXANET - Written By Denis CHEVRON - All rights reserved
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//             Zip functions declarations header file for Basic and Basic like languages
'//
'//             To use the Zip VBX, put ZDLL20A.DLL, ZDLL20B.DLL and UZDLL20.DLL in your application directory
'//             or into the Windows/System directory.
'//             Also, don' t forget to redistribute the ZIPSTD20.VBX with your application...
'//
'//             If you choose the DLLs functions instead of the VBX interface:
'//              ->To Zip, Put ZDLL20A.DLL and ZDLL20B.DLL in the current dir and define _GOZIP.
'//             ->To UnZip, Put UZDLL20.DLL in the current dir and define _GOUNZIP.
'//
'//             The [2.0] means the routine is new.
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//             To get more informations, have a look at ZIP.H.
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//             Zip functions
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

'/* Errors constants */
Global Const ZERROR_OK = 0              ' No error
Global Const ZERROR_WARNING = 1         ' Just a warning (not an error)
Global Const ZERROR_DESTFILE = 2        ' Destfile ( *.ZIP ) error
Global Const ZERROR_INTERNAL = 3        ' Internal error
Global Const ZERROR_FORMAT = 4          ' Not a Zip file
Global Const ZERROR_NOMEM = 5           ' Not enough memory
Global Const ZERROR_NOFILE = 6          ' Nothing to do ( can be just a warning )
Global Const ZERROR_NODLL = 7           ' Can' t find required DLLs
Global Const ZERROR_COMMENT = 8         ' Comment missing or NULL
Global Const ZERROR_NOCRYPT = 9         ' Can' t encrypt the file [2.0]


'/* Overwrite mode */
Global Const OVERWRITE_ALWAYS = 0       ' Always overwrite ( always zip files ) (default)
Global Const OVERWRITE_NEVER = 1        ' Never overwrite
Global Const OVERWRITE_PROMPT = 2       ' Ask the user
Global Const OVERWRITE_UPDATE = 3       ' Overwrite if external file is newer


'/* Language mode ( for the replace dialog box )*/
Global Const LANGUAGE_FRENCH = 0        ' French mode
Global Const LANGUAGE_ENGLISH = 1       ' US Mode ( default )
Global Const LANGUAGE_GERMAN = 2        ' German mode '** NEW! **
Global Const LANGUAGE_NONE = 3          ' No language (used with ZN_REPLACE) '** NEW! **

'/* More easy to use with AddFileToZip */
Global Const STOREPATH_NO = 0           ' Don' t store paths
Global Const STOREPATH_YES = 1          ' Store paths
Global Const RECURSE_NO = 0             ' Don' t recurse sub dirs
Global Const RECURSE_YES = 1            ' Recurse sub dirs


'/* Notification messages */
'Global Const ZN_ZIPPING        =WM_USER + 46   ' Zipping a file, WP = compressed size in K, LP = current file name
'Global Const ZN_FILEZIPPED     =WM_USER + 45   ' File is zipped, WP = compress rate, LP = file name
'Global Const ZN_WRITING        =WM_USER + 48   ' Replace the Zip file, LP = zip file name
'Global Const ZN_DELETING       =WM_USER + 47   ' Delete a file , LP = current file name
'Global Const ZN_REPARING       =WM_USER + 49   ' Repare a Zip file, WP = (int)state
						' step =  1 : Read / Write ,  LP = current file name
						' step = 3 : Checking zip file, LP = zip file name
'Global Const ZN_COMPUTE        =WM_USER + 52   ' Before zip read, WP = zip files ( over 500, computing can be very long )
'Global Const ZN_REPLACE        =WM_USER + 53   ' The replace dialog box is opened ** NEW! **
'Global Const ZN_ENCRYPT        =WM_USER + 66   ' Encrypt a file, WP= RATE, LP = filename [2.0]
'Global Const ZN_NETREAD        =WM_USER + 67   ' Reading a file from the network, WP = rate, LP = file name [2.0]
'Global Const ZN_NETWRITE       =WM_USER + 68   ' Writing the ZIP file to the network, WP = rate, LP = file name [2.0]


'/* Main functions */
Declare Sub ZipInit Lib "ZDLL20A.DLL" (ByVal szYourName$, ByVal szPassword$)                            'Init the Zip DLL
Declare Function AddFileToZip Lib "ZDLL20A.DLL" (ByVal szZipFile$, ByVal szMask$, ByVal OverwriteMode%, ByVal bStorePath%, ByVal bRecurse%, ByVal hParentWnd%, ByVal szPassword$) As Integer    'Zip a file [2.0]
Declare Function ZipDeleteFiles Lib "ZDLL20A.DLL" (ByVal szZipFile$, ByVal szFiles$, ByVal hParentWnd%) As Integer                      'Delete files in a Zip
Declare Function ZipRepare Lib "ZDLL20A.DLL" (ByVal szZipFile$, ByVal hParentWnd%) As Integer           'Recreate the Zip file
Declare Function ZipSetComment Lib "ZDLL20A.DLL" (ByVal szZipFile$, ByVal szComment$, ByVal hParentWnd%) As Integer                     'Set the Zip Comment
				  

'/* Helpers */
Declare Function ZipSetLanguage Lib "ZDLL20A.DLL" (ByVal cZipLanguage%) As Integer                      'Set the Language
Declare Function ZipGetReplaceFlag Lib "ZDLL20A.DLL" () As Integer                                      'Return the current overwrite mode
Declare Function ZipSetReplaceText Lib "ZDLL20A.DLL" (ByVal szDialogTitle$, ByVal szDialogText$, ByVal szYesBtn$, ByVal szNoBtn$, ByVal szAlwaysBtn$, ByVal szNeverBtn$) As Integer
		 'Set the replace dialog box labels, used with the LANGUAGE_NONE mode and the ZN_REPLACE notification message.. ** NEW! **


'/* New routines [2.0]*/
Global Const ZMODE_NORMAL = 0
Global Const ZMODE_FAST = 1
Global Const ZMODE_SLOW = 2
Global Const ZMODE_STORE = 3
Declare Function ZipSetMode Lib "ZDLL20A.DLL" (ByVal zMode%) As Integer                 '// [2.0] Specify the compression method (ZMODE_..)
Declare Sub ZipCancel Lib "ZDLL20A.DLL" (ByVal bCancel%)                        '// [2.0] Stop the current Zip action ASAP


'/* Split [2.0] */
Declare Function ZipSplit Lib "ZDLL20A.DLL" (ByVal hParent%, ByVal szZipName$, ByVal szDestDir$, ByVal lFirstSize As Long, ByVal lNextSize As Long, ByVal bDiskettePause%, ByVal szTitle$, ByVal szMsg$) As Integer   ' [2.0] Split an existing Zip file

Global Const SPLIT_OK = 0                       '// ZipSplit result [2.0]
Global Const SPLIT_NOFILE = 1
Global Const SPLIT_NOMEM = 2
Global Const SPLIT_IOERROR = 3
Global Const SPLIT_TOOBIG = 4
Global Const SPLIT_ACCESSDENIED = 5
Global Const SPLIT_USERABORT = 6
Global Const SPLIT_FILETOOSMALL = 7
	    
'Global Const ZN_SPLITTING      =WM_USER + 61   '// Splitting in process, wp = size (kb), lp = piece name [2.0]
'Global Const ZN_SPLITTED       =WM_USER + 62   '// A zip part is done, wp = part number,  lp = size ( in bytes ) [2.0]


'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//             UnZip functions
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


'/* Initialisation function */
Declare Sub UnzipInit Lib "UZDLL20.DLL" (ByVal szYourName$, ByVal szPassword$)          'required, if you are not a registered user szYourName = "TEST"


'/* Interface constants --- Already defined*/
'Global Const LANGUAGE_FRENCH           =0      ' french language will be used in the replace dialog box
'Global Const LANGUAGE_ENGLISH          =1      ' English language will be used in the replace dialog box ( default )
'Global Const LANGUAGE_GERMAN           =2      ' German mode '** NEW! **
'Global Const LANGUAGE_NONE             =3      ' No language (used with ZN_REPLACE) '** NEW! **


'/* Interface setting functions */
Declare Function UnzipSetMsgBoxTitle Lib "UZDLL20.DLL" (ByVal szNewTitle$) As Integer   'Set the replace dialog box title ( default = "Replace...");
Declare Sub UnzipSetLanguage Lib "UZDLL20.DLL" (ByVal iLanguage%)                       'Set the language for the replace dialog box
Declare Function UnzipSetReceivingWindow Lib "UZDLL20.DLL" (ByVal hWnd%) As Integer     'Set the window for notification messages
Declare Sub UnzipSetBackgroundMode Lib "UZDLL20.DLL" (ByVal bBackGroundMode%)           'if TRUE, activate the multitask mode ( default )
Declare Function UnzipSetReplaceText Lib "UZDLL20.DLL" (ByVal szDialogTitle$, ByVal szDialogText$, ByVal szYesBtn$, ByVal szNoBtn$, ByVal szAlwaysBtn$, ByVal szNeverBtn$) As Integer
		 'Set the replace dialog box labels, used with the LANGUAGE_NONE mode and the ZN_REPLACE notification message.. ** NEW! **


'/* Zip method constants */
Global Const ZMETHOD_STORED = 0
Global Const ZMETHOD_SHRUNK = 1
Global Const ZMETHOD_REDUCE1 = 2
Global Const ZMETHOD_REDUCE2 = 3
Global Const ZMETHOD_REDUCE3 = 4
Global Const ZMETHOD_REDUCE4 = 5
Global Const ZMETHOD_IMPLODE = 6
Global Const ZMETHOD_TOKEN = 7
Global Const ZMETHOD_DEFLATE = 8
Global Const ZMETHOD_UNKNOWN = 9
Global Const ZMETHOD_ERROR = 10


'/* Information functions ( Zip ) */
Declare Function IsFileInZip Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As Integer             'Return true (-1) if the file is in the ZIP file ** NEW! **
Declare Function CountFileInZip Lib "UZDLL20.DLL" (ByVal szFileName$) As Integer                                'Return number of files in this Zip File
' ** NEW! ** As a VB user, you must call this patch function instead of GetFileNameFromZIP:
Declare Sub VBGetFileNameFromZIP Lib "UZDLL20.DLL" (ByVal szFileName$, ByVal iFileNumber%, ByVal szResult$)
'Declare Function GetFileNameFromZIP    Lib "UZDLL20.DLL"( ByVal szFileName$, ByVal iFileNumber% ) As String    'Return the name of the iFileNumber file in this Zip File
Declare Function GetZFileOriginalSize Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As Long       'Return the not compressed size of szFileName in octets.
Declare Function GetZFileCompressedSize Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As Long     'Return the compressed size of szFileName in octets.
' ** NEW! ** As a VB user, you must call this patch function instead of GetFileNameFromZIP:
Declare Sub VBGetZFileDate Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$, ByVal szResult$)
'Declare Function GetZFileDate          Lib "UZDLL20.DLL"( ByVal szZIPFileName$, ByVal szFileName$ ) As String  'Return the date of a file in a Zip
' ** NEW! ** As a VB user, you must call this patch function instead of GetFileNameFromZIP:
Declare Sub VBGetZFileTime Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$, ByVal szResult$)
Declare Function GetZFileTime Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As String             'Return the time of a file in a Zip
Declare Function GetZCompressMethod Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As Integer      'Return the Zip method for a file ( ZMETHOD_* )
Declare Function GetZFullInfos Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$, ByVal szResult$) As Integer                  'Fill <szResult> with all informations ** NEW! **
Declare Function GetZFileIsDir Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As Integer                                   'TRUE is the file is a directory specification ** NEW! **
Declare Function GetZFileIsEncrypted Lib "UZDLL20.DLL" (ByVal szZIPFileName$, ByVal szFileName$) As Integer                             'TRUE if the file is encrypted [2.0]
Declare Function IsThisFileAZipFile Lib "UZDLL20.DLL" (ByVal szFileName$, ByVal bQuickTest%) As Integer         'Return TRUE if this file seems to be a zip file [2.0]
Declare Function IsFileUnzipable Lib "UZDLL20.DLL" (ByVal szFileName$) As Integer                               'Return TRUE if this file name can be reproduce under DOS
Declare Function GetZipCommentLength Lib "UZDLL20.DLL" (ByVal szFileName$) As Integer                           'Return the size of the zip file comment in octets
Declare Function GetZipComment Lib "UZDLL20.DLL" (ByVal szFileName$, ByVal szBuffer$) As Integer                        'Put the zip comment in buffer


'/* Information functions ( General ) */
Declare Function bDoesFileExist Lib "UZDLL20.DLL" (ByVal szFileName$) As Integer                                'True if this file exists
Declare Function GetShortFileName Lib "UZDLL20.DLL" (ByVal szFileName$) As String                               'Return filename without any path
Declare Function GetPathFromFileName Lib "UZDLL20.DLL" (ByVal szFileName$) As String                            'Return the path without the file name
Declare Function IsFileNameInFilter Lib "UZDLL20.DLL" (ByVal szFileName$, ByVal szMask$) As Integer             'Return TRUE if filename is in specified filter


'/* Extraction function result constants */
Global Const ZEXTRACT_OK = 0
Global Const ZEXTRACT_INTERNALERROR = 1
Global Const ZEXTRACT_FILENOTFOUND = 2
Global Const ZEXTRACT_CORRUPTED = 3
Global Const ZEXTRACT_EMPTY = 4
Global Const ZEXTRACT_ERRORINZIPFILE = 5
Global Const ZEXTRACT_NOMEM = 6
Global Const ZEXTRACT_DISKFULL = 8
Global Const ZEXTRACT_WARNING = 10


'/* Helper constants */
Global Const OVERWRITE_FALSE = 0
Global Const OVERWRITE_TRUE = 1
Global Const OVERWRITE_QUERY = 2
Global Const CREATEDIR_FALSE = 0
Global Const CREATEDIR_TRUE = 1


'/* Extraction functions */
Declare Function ExtractZipFiles Lib "UZDLL20.DLL" (ByVal szFileName$, ByVal szMask$, ByVal szDestDir$, ByVal bOverwrite%, ByVal bCreateDir%) As Integer
Declare Function GetQueryFlag Lib "UZDLL20.DLL" () As Integer                                                   'Return the overwrite mode the user asked for


'/* Notification messages for UNZIP and VIEW*/
'Global Const ZN_OPENFILE       =WM_USER + 38   ' Open a file, WP = TRUE if Ok, LP = filename
'Global Const ZN_EXPANDING      =WM_USER + 39   ' Unzipping a file, WP = file current rate, LP = filename
'Global Const ZN_CLOSEFILE      =WM_USER + 40   ' Close a file, WP = TRUE if Ok, LP = filename
'Global Const ZN_REPLACE        =WM_USER + 53   ' Send when the replace dialog box is opened ** NEW! **
'Global Const ZN_NEWPASSWORD    =WM_USER + 65   ' A new password is required, WP= 0, LP = filename + tab key + current password [2.0]
'Global Const ZN_TEST           =WM_USER + 69   ' Send by IsThisFile..., WP = TRUE if ok, LP = tested file name [2.0]

'/* View function */
Declare Function ViewFileFromZip Lib "UZDLL20.DLL" (ByVal szZipFile$, ByVal szMask$, ByVal bTextOnly%) As Integer                               'View one or several files in a Zip

'/* ZIP files list [2.0]*/

Type ZIPITEM                                    '// A Zip file item [2.0]
	szName          As String * 50          '// The file name without any path
	szDir           As String * 260         '// The relative directory
	bIsDir          As Integer              '// TRUE if this item specifies a directory
	bIsEncrypted    As Integer              '// TRUE if this item is encrypted
	iMethod         As Integer              '// The compression method
	iDay            As Integer              '// Date: The Day
	iMonth          As Integer              '// Date: The month
	iYear           As Integer              '// Date: The year (no century specification)
	iHour           As Integer              '// Time: The hour
	iMin            As Integer              '// Time: The minutes
	lOriginalSize   As Long                 '// The original size in bytes
	iRate           As Integer              '// The compression rate
End Type
Global zItem As ZIPITEM

			    
Global Const ZSORT_BYFULLNAME = 0               '// The files list sort method [2.0]
Global Const ZSORT_BYNAME = 1
Global Const ZSORT_BYDIR = 2
Global Const ZSORT_BYDATE = 3
Global Const ZSORT_BYSIZE = 4
Global Const ZSORT_BYRATE = 5
Global Const ZSORT_NONE = 6
		
Declare Function GetZList Lib "UZDLL20.DLL" (ByVal szZipName$, ByVal hListWnd%, ByVal iFrom%, ByVal iSortMode%, ByVal bBackGnd%) As Integer                     '// Build the files list
Declare Function GetZipItem Lib "UZDLL20.DLL" (ByVal hListWnd%, ByVal iIndex%, zItem As ZIPITEM) As Integer                                         '// Retrieve an item from this list
Declare Function UnzipSortZList Lib "UZDLL20.DLL" (ByVal hListWnd%, ByVal iSortMode%, ByVal bBackGnd%) As Integer                                       '// Sort the list again
		

'/* New routines [2.0] */
Declare Function UnzipSetPassword Lib "UZDLL20.DLL" (ByVal szPassword$) As Integer              '// Specify the password to use to extract the encrypted file(s) [2.0]
Declare Sub SetAskPassword Lib "UZDLL20.DLL" (ByVal bAsk%)                                              '// TRUE if you want Zip Studio asks the user for a password [2.0]
Declare Function UnzipSetPasswordText Lib "UZDLL20.DLL" (ByVal szDialogTitle$, ByVal szDialogText$, ByVal szPasswordLabel$, ByVal szYesBtn$, ByVal szNoBtn$, ByVal szNeverBtn$) As Integer
									'// Set the password dialog box labels, used with ZN_NEWPASSWORD [2.0]
Declare Sub UnzipCancel Lib "UZDLL20.DLL" (ByVal bCancel%)                                              '// Set or Reset the Cancel flag for the UNZIP process:
									'// You must reset this flag before you call any UNZIP function:
									'// (eg UnzipCancel(FALSE) ... ) [2.0]

'/* Join function [2.0] */
Declare Function ZipJoin Lib "UZDLL20.DLL" (ByVal hParent%, ByVal szName$, ByVal szDestDir$, ByVal bSendMsg%, ByVal szTitle$, ByVal szMsg$) As Integer                  '// Join a splitted Zip file [2.0]
								
Global Const JOIN_OK = 0                        '// ZipJoin result code [2.0]
Global Const JOIN_NOFILE = 1
Global Const JOIN_NOMEM = 2
Global Const JOIN_IOERROR = 3
Global Const JOIN_ACCESSDENIED = 4
Global Const JOIN_USERABORT = 5
Global Const JOIN_NOTASPLITTEDFILE = 7
Global Const JOIN_ZIPEXIST = 8
	    
'Global Const ZN_JOINING        =WM_USER + 41   '// Split in process, wp = size in Kbytes, lp = file name
'Global Const ZN_JOINED         =WM_USER + 42   '// A zip part is done, wp = part number,  lp = size ( in bytes )
'Global Const ZN_JOINDONESIZE   =WM_USER + 43   '// Split is done for all the ZIP files, lp = total size in bytes
'Global Const ZN_JOINDONENAME   =WM_USER + 44   '// Split is done for all the ZIP files, lp = zip name




'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//
'//             ZIPSTD13.VBX Contants
'//
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

'---------------------------------
'For the <Action> special property
Global Const ACTION_NONE = 0
Global Const ACTION_ZIP = 1
Global Const ACTION_DELETE = 2
Global Const ACTION_UNZIP = 3
Global Const ACTION_VIEW = 4
Global Const ACTION_REPARE = 5
Global Const ACTION_DELETECOMMENT = 6
Global Const ACTION_SETCOMMENT = 13          'for actionresult only, do not use with <Action>! [2.0]
Global Const ACTION_BUILDZIPLIST = 7          '[2.0]
Global Const ACTION_SORT = 8                 '[2.0]
Global Const ACTION_CANCEL = 9               '[2.0]
Global Const ACTION_JOIN = 10                '[2.0]
Global Const ACTION_SPLIT = 11               '[2.0]
Global Const ACTION_TEST = 12                '[2.0]


'---------------------------------
'For the <OverwriteMode> property
Global Const VBXOVERWRITE_PROMPT = 0
Global Const VBXOVERWRITE_ALWAYS = 1
Global Const VBXOVERWRITE_NEVER = 2
Global Const VBXOVERWRITE_UPDATE = 3



		
'/* ---------------------------------------- End of file ------------------------------------------*/
			

