# VSDK UNIX style MAKEFILE for demo C and Fortran blocks
# use with Microsoft "nmake" or "nmk" 

# Model specifier
MODEL=L

# Put your Fortran object files here seperated by a space
# Note: must include the .obj
FOBJS=vsolver.obj
# Following flag is for win 3.1 rc to give win 3.0 compatibility
RCFLAGS=-30

# Windows Resource compiler
RC=rc -t $(RCFLAGS)

LIBENTRY=libentry

CODEVIEW=/co
LFLAGS=/AL:16/nod$(CODEVIEW)
DEBFLAG=-Zi
CFLAGS= $(DEBFLAG) -A$(MODEL) -Gsw -Zp -Aw 
FFLAGS= $(DEBFLAG) -A$(MODEL) -Gw -Aw

.SUFFIXES:      .for

.for.obj:
	fl -c $(FFLAGS) $*.for

.c.obj:
     cl -c $(CFLAGS) $*.c

it:   vsolver.dll 

#  Requires Microsoft FORTRAN 5.1 or better
vsolver.dll: $(FOBJS)
	  link @<<
$(LFLAGS) $(FOBJS)
$*.DLL
,
impsim $(MODEL)dllfew
$*.def
<<    
