{************************************************}
{                                                }
{   Borland Turbo Pascal                         }
{   VisSim DLL function example for Windows      }
{   Demo Dynamic Link Library                    }
{************************************************}

library testpdll;

uses WinTypes,WinProcs;

procedure getSimTime(var simTime); external 'VisSim';  {* VisSim function *}

type
Arraytype1 = array [0..5] of Double;
Arraytype2 = array [0..10] of Double;

procedure minmax( var param, inV:Arraytype1; var outV:Arraytype2); export;

   { The user function referenced in the VisSim user function block  }

 var 
 simTime,min,max,sum,avg :double;
 i:integer;

 begin
     
    getSimTime(simTime);   {* simulation time*}
    outV[0]:= simTime;  

    min:=inV[0];
    max:=inv[0];
    sum:=inV[0];
    avg:=0;

    for i:=1 to 3 do
     begin
       if (inV[i] <= min) then
         min:=inV[i];
       if (inV[i] >= max) then
         max:=inV[i];
       sum:=sum+inV[i];
     end;
  

    avg:=sum/4;
    outV[1]:=max;
    outV[2]:=min;
    outV[3]:=avg;
    outV[4]:=param[0]-param[1];

 end;

function minmaxPA( var pcount:integer):Longint; export;
{Parameter Allocation Function}
 begin
   pCount:=2;   { * number of prompted parametrs *}
   minmaxPA:=sizeof(Double)*pCount;
 end;
  
procedure minmaxPI( var param:Arraytype1); export;
{Parameter Initialization Function}
  begin
    param[0]:=1;  { * parameters *} 
    param[1]:=3;
  end;

function minmaxPC( var param:Arraytype1):Pchar; export;
{Parameter Change function }
begin
 minmaxPC:='Upper;Lower';
end;

exports
{ needed for building a DLL}
  minmax    index 1,
  minmaxPI  index 4,
  minmaxPA  index 5,
  minmaxPC  index 6;

begin
end.
