/* 06/04/94 */

#define SHIFTLENGTH	8

/* Cesar: single character */
void CesarEncodeChar(unsigned char *Char, short Base, short Key1, short Key2, short Key3);
void CesarDecodeChar(unsigned char *Char, short Base, short Key1, short Key2, short Key3);
/* Char: character to be crypted; contains result afterwards */
/* Base: base of calculation (must be varied for longer strings to prevent obvious code) */
/* Key 1, 2, 3: keys in the range -256 to 256 */
/* base and keys must be identical for encryption and decryption */

/* Cesar: string */
void CesarEncodeString(unsigned char *String, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
void CesarDecodeString(unsigned char *String, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
/* String: null-terminated string to be crypted; contains result afterwards */
/* Key 1, 2, 3: keys in the range -256 to 256 */
/* FirstChar, LastChar: ASCII range of input and output string (e.g. numbers are coded into numbers) */
/* keys must be identical for encryption and decryption */

/* Cesar: binary file */
void CesarEncodeBytes(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3);
void CesarDecodeBytes(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3);
/* InputFilename, OutputFilename: DOS file names of input and output file */
/* Key 1, 2, 3: keys in the range -256 to 256 */
/* keys must be identical for encryption and decryption */

/* Cesar: text file */
void CesarEncodeLines(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
void CesarDecodeLines(char *InputFilename, char *OutputFilename, short Key1, short Key2, short Key3, unsigned char FirstChar, unsigned char LastChar);
/* InputFilename, OutputFilename: DOS file names of input and output file */
/* Key 1, 2, 3: keys in the range -256 to 256 */
/* FirstChar, LastChar: ASCII range of input and output string (e.g. numbers are coded into numbers) */
/* keys must be identical for encryption and decryption */

/* Bit Shift: single character */
void ShiftEncodeChar(unsigned char *Char, short Base, short Start, short LoopA, short LoopB);
void ShiftDecodeChar(unsigned char *Char, short Base, short Start, short LoopA, short LoopB);
/* Char: character to be crypted; contains result afterwards */
/* Base: base of calculation (must be varied for longer strings to prevent obvious code) */
/* Start: initial value of shift register; LoopA, LoopB: bits to be recycled */
/* base and keys must be identical for encryption and decryption */

/* Bit Shift: string */
void ShiftEncodeString(unsigned char *String, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
void ShiftDecodeString(unsigned char *String, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
/* String: null-terminated string to be crypted; contains result afterwards */
/* Start: initial value of shift register; LoopA, LoopB: bits to be recycled */
/* FirstChar, LastChar: ASCII range of input and output string (e.g. numbers are coded into numbers) */
/* keys must be identical for encryption and decryption */

/* Bit Shift: binary file */
void ShiftEncodeBytes(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB);
void ShiftDecodeBytes(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB);
/* InputFilename, OutputFilename: DOS file names of input and output file */
/* Start: initial value of shift register; LoopA, LoopB: bits to be recycled */
/* keys must be identical for encryption and decryption */

/* Bit Shift: text file */
void ShiftEncodeLines(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
void ShiftDecodeLines(char *InputFilename, char *OutputFilename, short Start, short LoopA, short LoopB, unsigned char FirstChar, unsigned char LastChar);
/* InputFilename, OutputFilename: DOS file names of input and output file */
/* Start: initial value of shift register; LoopA, LoopB: bits to be recycled */
/* FirstChar, LastChar: ASCII range of input and output string (e.g. numbers are coded into numbers) */
/* keys must be identical for encryption and decryption */

/* Bit Shift: period length */
short ShiftPeriod(short Start, short LoopA, short LoopB);
/* Start: initial value of shift register; LoopA, LoopB: bits to be recycled */
/* Return value: period length of specified shift register */

/* User ID: */
long IDCalculate(char *Name, short Key1, short Key2);
/* Name: name to be calculated, null-terminated; remains unchanged */
/* Key 1, 2: keys in the range -256 to +256 */
/* Return value: a five digit ID */
void IDShortName(char *Name, char *ShortName);
/* Name: name to be shortened, null-terminated; remains unchanged */
/* Return value: shortened name in ShortName */
void IDLongName(char *Name, char *LongName);
/* Name: name to be lengthened, null-terminated; remains unchanged */
/* Return value: lengthened name in LongName */
