/*** SIMPL_IO.C ***/

#include "windows.h"
#include "stdio.h"
#include "string.h"
#include "pcl4w.h"
#include "simple.h"
#include "ascii.h"
#include "sioerror.h"
#include "simpl_io.h"
#include "paint.h"

char Temp[256];

/*** output character to serial port ***/

int PutChar(int Port, char ch)
{int rc;
 /* transmit character */
 rc = SioPutc(Port,ch);
 if(rc<0)
     {/* error */
      SioError(rc,"SioPutc");
      SioDone(Port);
     }
 return(rc);
}

/*** receive character from serial port ***/

int GetChar(int Port)
{int rc;
 rc = SioGetc(Port);
 if(rc<-1)
     {/* error */
      SioError(rc,"SioGetc");
      SioDone(Port);
     }
 return(rc);
}


/*** display the error text ***/

void SayError(int Port, char *ptr)
{char temp[81];
 sprintf(temp,"ERROR! COM%d : %s",1+Port,ptr);
 DisplayLine(temp);
 /* cancel remote */
 PutChar(Port,CAN);
 PutChar(Port,CAN);
 PutChar(Port,CAN);
} /* end SayError */

/*** display line on TERM client area ***/

char CRLF[2] = {CR,LF};

void DisplayLine(char *Ptr)
{
 WriteTheString("<",1);
 WriteTheString(Ptr,strlen(Ptr));
 WriteTheString(">",1);
 WriteTheString(CRLF,2);
} /* end DisplayLine */