function y=setgrid(x)
%setgrid	provides fine control of grid options for 2D plots
%	change the default values for any subsequent plot
%
%  x is a logical vector whose values are as follows
%
%  x(1) - Allow X axis not to end on tick marks (linear plot only)
%  x(2) - Allow Y axis not to end on tick marks (linear plot only)
%  x(3) - Place unlabeld X axis at top of plotting area
%  x(4) - Place unlabeld Y axis at right of plotting area
%  x(5) - Do not plot X axis tick labels (controlled by grid)
%  x(6) - Do not plot Y axis tick labels (controlled by grid)
%  x(7) - Set the tick marks inside the plotting area
%  x(8) - Include X axis grid lines
%  x(9) - Include Y axis grid lines
%
%  x=[1 1 1 1 0 0 1 1 1]  is the default
%  y=463

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

x=(x>0);
x=x(:);

n=length(x);
if n > 9
  x=x(1:9);
  x=x(:);
end

n = length(x);
y=0;
if n>1
   wght = 2^((1:n)-1);
   y=wght*x;
end
