%Demonstartion of a linear FM radar Gabor (time/frequency) transform
%The variable wave is the analytic linear FM radar signal which
%you can change to get the transform of other waveforms
%can be changed to an M-file function

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

clear
gwsel(0)
n=16
n2=n+n;
t=(0:n-1)/n;
f0=1;
f1=4;
arg=2*pi*f0*t.*(1+0.5*(f1-f0)*t);
wave0=sin(arg)+cos(arg)*1J;
wave = [zeros(wave0) wave0];
gabor=[]
for k=1:n2
  k
  sig=wave.*conj(fliplr(wave)<>[0 k]);
  siga=abs(fft(sig));
  gabor=[gabor siga'];
end
save gabor gabor

load gabor
gabor /= max(max(gabor));
mesh(gabor)
subplot(211)
plot(t,real(wave0)), xlabel('time'), ylabel('amp'), title('signal')
contour(flipud(gabor)),grid,xlabel('time'),ylabel('frequency'),title('Gabor Transform') 
subplot
threshold=0.95*ones(n2,1)*max(gabor);
% the time-frequency distribution (threshold detection)
contour(flipud(gabor>threshold),4)
