function [y, zf] = filter(b, a, x, z)
% [y, zf] = filter(b, a, x, z)
% computes the output of a digital filter (a wrapper around the
% built-in _filter)

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

% error checking

if nargin < 3
   error('filter: not enough input arguments');
end

x=x(:)';
a=a(:)';
b=b(:)';

na = length(a);
if na == 1
   a=[a 0];
end
na = length(a);
nb = length(b);
nz = max(na,nb);
  
if nargin < 4
   z = zeros(1,nz);
else
   z=z(:)';
end

if length(z) ~= nz
   error('filter state must match coefficients');
end

if abs(a(1))==0
   error('first element of A can not be zero')
end

[y, zf]= _filter(x, a, b, z);

