% Demonstartion of a linear FM radar ambiguty function
% The variable wave is the analytic linear FM radar signal which
% you can change to get the radar ambiguity of other radar waveforms

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

clear
gwsel(0);
n=16
n2=n+n;
t=(0:n-1)/n;
f0=1;
f1=4;
arg=2*pi*f0*t.*(1+0.5*(f1-f0)*t);
wave=sin(arg)+cos(arg)*1J;
wave(n2)=0;
ambg=[]
for k=1:n2
  k
  sig=wave.*conj(wave<>[0 k]);
  siga=abs(fft(sig));
  ambg=[ambg;siga];
end
ambg=ambg<>[n n];
save ambg ambg

load ambg
ambg /= max(max(ambg));
top=0.4;
ambg = min(ambg,top);
mesh(ambg)
contour(ambg),grid,xlabel('range'),ylabel('doppler')

