% Demonstration of MathViews graphics

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

clear
gwsel(0)
n=8;
x=(0:n)/n;
y=x.*(1.2-x);
y /= max(y);
z=y'*y;
fill3d(z)
surcnt(689,z)
surcnt(2209,z)

plot(x,'+',x,y,'g',y/2)

% multiple graphic windows
contour(z)
plot(z)

% subplots
subplot(221)
plot(x,y)
grid
xlabel('X Axis')
plot(x,z),grid,ylabel('Y Axis')

% contour
contour(z)
grid
title('Title')

mesh(z)

%subplot
subplot(211)
plot(x,y),grid
plot(x,z),grid
subplot

plot(x,y)
% hold
hold on
plot(x,z)
plot(x,y)
hold off

%mesh/contour plot
epsi = 1e-14;
x=(-24:3:24)/3;
y=x';
X=ones(y)*x;
Y=y*ones(x);
R=sqrt(X.^2+Y.^2) + epsi;
Z=sin(R)./R;
mesh(Z)
contour(Z),grid,xlabel('range'),ylabel('doppler'),title('Contour')

% contours with labels
cntrlb(Z),grid,xlabel('range'),ylabel('doppler'),title('Contour')

% NOTE: surcnt() (Surface-Contour) and fill3d() syntax and options are
% subject to change in later versions for 4.0 compatibility

%options for surface contours
%    1 - hide surface
%   16 - backfill
%   32 - fill contour
%   64 - line contour
%  128 - frame
%  256 - back frame
%  512 - draw filled surface
% 1024 - draw a single color wire frame
% 2048 - draw multi-colored wires

opt = 1+128+512+1024;  % fill3d
surcnt(opt,Z)

opt=1+32+64+128+256+512+1024;
surcnt(opt,Z)

%opt=1+32+128+256+2048;
%surcnt(opt,Z)

%opt=1+32+128+2048;
%surcnt(opt,Z)

%opt=1+16+32+128+512;
%surcnt(opt,Z)
