Declare Function OpenFile Lib "Kernel" (ByVal lpFileName As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Integer) As Integer

'  OpenFile() Flags

Const OF_READ = &H0
Const OF_WRITE = &H1
Const OF_CREATE = &H1000

Declare Function llseek Lib "Kernel" Alias "_llseek" (ByVal hFile As Integer, ByVal lOffset As Long, ByVal iOrigin As Integer) As Long
Declare Function lclose Lib "Kernel" Alias "_lclose" (ByVal hFile As Integer) As Integer

Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer

Const GMEM_MOVEABLE = &H2
Const GMEM_ZEROINIT = &H40
Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

Declare Function hread Lib "kernel" Alias "_hread" (ByVal hFile%, ByVal memAddr&, ByVal dwBytes&) As Long
Declare Function hwrite Lib "kernel" Alias "_hwrite" (ByVal hFile%, ByVal memAddr&, ByVal dwBytes&) As Long

Dim g_Of As OFSTRUCT

Const HFILE_ERROR = -1

Function CopyFile (InFile$, outFile$)

'********************************************************
'  InFile$ is the source file full path and file name
'  OutFile$ is the target file full path and file name
'
'  CopyFile returns "true" if copy completes successfully
'  and "false" if there is an error.
'********************************************************
    
    '--- open source file
    inHndl% = OpenFile(InFile$, g_Of, OF_READ)
    If inHndl% = HFILE_ERROR Then
        fail% = 1
        GoTo CopyError
    End If
    
    '--- get size of source file
    size& = llseek(inHndl%, 0, 2)
    
    '--- reset file pointer to start of file
    msg& = llseek(inHndl%, 0, 0)
    
    '--- Open target file
    OutHndl% = OpenFile(outFile$, g_Of, OF_CREATE Or OF_WRITE)
    If OutHndl% = HFILE_ERROR Then
        fail% = 2
        GoTo CopyError
    End If
    
    '--- allocate needed global memory
    memHndl% = GlobalAlloc(GHND, size&)
    If memHndl% = 0 Then
        fail% = 3
        GoTo CopyError
    End If
    
    '--- lock global memory
    memAddr& = GlobalLock(memHndl%)
    
    '--- read source file into global memory
    inBytes& = hread(inHndl%, ByVal memAddr&, size&)
    If inBytes& <> size& Then
        fail% = 4
        GoTo CopyError
    End If
    
    '--- write global memory to target file
    outBytes& = hwrite(OutHndl%, ByVal memAddr&, size&)
    If outBytes& <> size& Then
        fail% = 5
        GoTo CopyError
    End If
    
    '--- close source and target
    ok% = lclose(inHndl%)
    ok% = lclose(OutHndl%)
    
    '--- unlock and free global memory
    ok% = GlobalUnlock(memHndl%)
    ok% = GlobalFree(memHndl%)
    ok% = DoEvents()
    
    '--- set COPYFILE exit code
    CopyFile = HFILE_ERROR
    Exit Function

CopyError:

    '--- clean up if there was an error
    ok% = lclose(inHndl%)
    ok% = lclose(OutHndl%)
    ok% = GlobalUnlock(memHndl%)
    ok% = GlobalFree(memHndl%)
    ok% = DoEvents()
    
    '--- return failure code to calling proc
    CopyFile = fail%

End Function

