#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

#define BLACK_PEN  7

//---------------------------------------------------------------------------//

void WndDrawBox( HDC hDC, RECT * rct, HPEN hPUpLeft, HPEN hPBotRit )
{
   HPEN hOldPen = SelectObject( hDC, hPUpLeft );

   MoveTo( hDC, rct->left, rct->bottom );
   LineTo( hDC, rct->left, rct->top );
   LineTo( hDC, rct->right, rct->top );
   SelectObject( hDC, hPBotRit );
   MoveTo( hDC, rct->left, rct->bottom );
   LineTo( hDC, rct->right, rct->bottom );
   LineTo( hDC, rct->right, rct->top - 1 );
   SelectObject( hDC, hOldPen );

}

//---------------------------------------------------------------------------//

void WindowBoxIn( HDC hDC, RECT * pRect )
{
   HPEN hPen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) );

   WndDrawBox( hDC, pRect, hPen, GetStockObject( WHITE_PEN ) );

   DeleteObject( hPen );
}

//---------------------------------------------------------------------------//

void WindowBox( HDC hDC, RECT * pRect )
{
   HPEN hPen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) );

   WndDrawBox( hDC, pRect, GetStockObject( WHITE_PEN ), hPen );

   DeleteObject( hPen );
}

//---------------------------------------------------------------------------//

void WindowRaised( HDC hDC, RECT * pRect )
{
    HPEN hPen = CreatePen( PS_SOLID, 1, RGB( 128, 128, 128 ) );

    WndDrawBox( hDC, pRect, GetStockObject( WHITE_PEN ), hPen );

    DeleteObject( hPen );
}

//---------------------------------------------------------------------------//

CLIPPER WNDBOXIN() // hDC, nTop, nLeft, nBottom, nRight
{
   RECT rct;

   rct.top    = _parni( 2 );
   rct.left   = _parni( 3 );
   rct.bottom = _parni( 4 );
   rct.right  = _parni( 5 );

   WindowBoxIn( _parni( 1 ), &rct );
}

//---------------------------------------------------------------------------//

CLIPPER WNDBOX() // ( hDC, nTop, nLeft, nBottom, nRight )
{
   RECT rct;

   rct.top    = _parni( 2 );
   rct.left   = _parni( 3 );
   rct.bottom = _parni( 4 );
   rct.right  = _parni( 5 );

   WndDrawBox( _parni( 1 ), &rct,
               GetStockObject( BLACK_PEN ),
               GetStockObject( BLACK_PEN ) );
}

//---------------------------------------------------------------------------//

CLIPPER WNDRAISED()  // ( hWnd, hDC )
{
   RECT rct;

   GetClientRect( _parni( 1 ), &rct );
   --rct.bottom;
   --rct.right;

   WindowRaised( _parni( 2 ), &rct );
}

//---------------------------------------------------------------------------//

CLIPPER WNDBOXRAIS()  // ED()  //  hDC, nTop, nLeft, nBottom, nRight
{
   RECT rct;

   rct.top    = _parni( 2 );
   rct.left   = _parni( 3 );
   rct.bottom = _parni( 4 );
   rct.right  = _parni( 5 );

   WindowRaised( _parni( 1 ), &rct );
}

//---------------------------------------------------------------------------//
