// VBX support is under development

#include "FiveWin.ch"

#define CRLF Chr(13)+Chr(10)

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oGet, oPrg, oCode
   local cFile := Space( 30 )
   local cPrg  := ""
   local cText := ""

   SET 3DLOOK ON

   DEFINE DIALOG oDlg RESOURCE "Main"

   REDEFINE GET oGet VAR cFile ID 100 OF oDlg
   REDEFINE GET oPrg VAR cPrg  ID 120 OF oDlg

   REDEFINE GET oCode VAR cText MULTILINE ID 140 OF oDlg

   REDEFINE BUTTON ID 110 OF oDlg ;
      ACTION GetVbx( @cFile, @cPrg, @cText, oGet, oPrg, oCode )

   REDEFINE BUTTON ID 130 OF oDlg ACTION oDlg:End()

   REDEFINE BUTTON ID 150 OF oDlg ;
      ACTION ( cText := ClassGen( cFile ), oCode:Refresh() )

   REDEFINE BUTTON ID 160 OF oDlg ;
      ACTION SaveFile( cPrg, cText )

   ACTIVATE DIALOG oDlg CENTERED

return

//----------------------------------------------------------------------------//

function ClassGen( cVbx )

   local hVbx  := LoadLibrary( cVbx )
   local nVbx  := LoadVbx( hVbx )
   local n     := 1
   local cText := '#include "FiveWin.ch"' + CRLF + CRLF
   local cData

   MsgInfo( "LoadVBX OK" )

   cText += "CLASS TVb" + VbxClassName( nVbx ) + " FROM TVbControl" + CRLF + CRLF

   MsgInfo( "VBXClassName OK" )

   while ! Empty( cData := VbxDataName( nVbx, n++ ) )
      cText += "   DATA    " + cData + CRLF
   end

   MsgInfo( "VBXDataName OK" )

   n = 1
   cText += CRLF
   while ! Empty( cData := VbxMethName( nVbx, n++ ) )
      cText += "   METHOD " + cData + "()" + CRLF
   end

   MsgInfo( "VBXMethName OK" )


   cText += CRLF + "ENDCLASS" + CRLF

   FreeLibrary( hVbx )

return cText

//----------------------------------------------------------------------------//

function GetVbx( cFile, cPrg, cText, oGet, oPrg, oCode )

   local cFileName := cGetFile( "*.vbx", "Select a VBX file" )

   if ! Empty( cFileName )
      cFile = cFileName
      cPrg  = SubStr( cFileName, 1, RAt( ".", cFileName ) ) + "prg"
      cText = ""
      oGet:Refresh()
      oPrg:Refresh()
      oCode:Refresh()
   endif

return

//----------------------------------------------------------------------------//

function SaveFile( cFile, cText )

   local cFileName := cGetFile( cFile, "Save PRG source to..." )

   if ! Empty( cFileName )
      if File( cFileName )
         if MsgYesNo( "File already exist" + CRLF + "Overwrite?" )
            if MemoWrit( cFileName, cText )
               MsgInfo( "PRG generated", "OK" )
            endif
          endif
      else
         if MemoWrit( cFileName, cText )
            MsgInfo( "PRG generated", "OK" )
         endif
      endif
   endif

return

//----------------------------------------------------------------------------//
