// Reviewing arrays - using FiveWin TWBrowse

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()

   local oDlg, oBrw
   local aSample := { "The standard", "has", "a name...",;
                      "CA-Clipper 5.", "Wellcome", "to", "FiveWin",;
                      "the CA-Clipper 5", "Windows", "Library" }
   local nItem := 1

   DEFINE DIALOG oDlg FROM 2, 2 TO 20, 50 TITLE "FiveWin TWBrowse Power!!!"

   @ 1, 2 LISTBOX oBrw FIELDS aSample[ nItem ] ;
      HEADERS "Reviewing Array" ;
      FIELDSIZES 200 ;
      OF oDlg ;
      SIZE 100, 100

   oBrw:bGoTop    = { || nItem := 1 }
   oBrw:bGoBottom = { || nItem := Eval( oBrw:bLogicLen ) }
   oBrw:bSkip     = { | nWant, nOld | nOld := nItem, nItem += nWant,;
                        nItem := Max( 1, Min( nItem, Eval( oBrw:bLogicLen ) ) ),;
                        nItem - nOld }
   oBrw:bLogicLen = { || Len( aSample ) }
   oBrw:cAlias    = "Array"                // Just put something

   @ 1, 20 BUTTON "&End" OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//
