#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TRadMenu

   DATA   aItems
   DATA   bSetGet
   DATA   bClick

   METHOD New( nRow, nCol, acItems, bSetGet, oWnd, nHelp, bClick,;
               nClrText, nClrPane ) CONSTRUCTOR

   METHOD Redefine( bSetGet, oWnd, nHelp, aRadioIDs, bClick,;
                    nClrText, nClrPane ) CONSTRUCTOR

   METHOD nOption( nNewOption ) SETGET

   METHOD Refresh()

   METHOD End() INLINE  AEval( ::aItems, { | oRadio | oRadio:End() } ),;
                        Super:End()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, acItems, bSetGet, oWnd, nHelp, bClick,;
            nClrText, nClrPane ) CLASS TRadMenu

   local n

   if nClrText == nil
      nClrPane := oWnd:nClrPane
   endif

   DEFAULT nHelp := 100, nClrText := oWnd:nClrText

   ::aItems  = {}
   ::bSetGet = bSetGet
   ::bClick  = bClick

   if ValType( Eval( bSetGet ) ) != "N"
      Eval( bSetGet, 1 )
   endif

   for n = 1 to Len( acItems )
      AAdd( ::aItems, TRadio():New( nRow + n - 1, nCol, acItems[ n ],;
            n == 1,;                // First element is group
            n == Eval( bSetGet ),;  // Is Checked ?
            n, oWnd, Self, nHelp, nClrText, nClrPane ) )
   next

return nil

//----------------------------------------------------------------------------//

METHOD nOption( nNewOption ) CLASS TRadMenu

   if nNewOption != nil
      Eval( ::bSetGet, nNewOption )
      if ::bClick != nil
         Eval( ::bClick )
      endif
   else
      return Eval( ::bSetGet )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Redefine( bSetGet, oWnd, nHelp, anItemsIDs, bClick, nClrText,;
                 nClrPane )  CLASS TRadMenu

   local n

   if nClrText == nil
      nClrPane := oWnd:nClrPane
   endif

   DEFAULT nHelp := 100, nClrText := oWnd:nClrText

   ::bSetGet = bSetGet
   ::aItems  = {}
   ::bClick  = bClick

   if ValType( Eval( bSetGet ) ) != "N"
      Eval( bSetGet, 1 )
   else
      if Eval( bSetGet ) == 0
         Eval( bSetGet, 1 )
      endif
   endif

   for n = 1 to Len( anItemsIDs )
       AAdd( ::aItems, TRadio():ReDefine( anItemsIDs[ n ], ;
                               n == Eval( bSetGet ),;  // Is Checked ?
                               n,;
                               oWnd, Self, nHelp, nClrText, nClrPane ) )
   next

return Self

//---------------------------------------------------------------------------//

METHOD Refresh() CLASS TRadMenu

   local nOption := Eval( ::bSetGet )
   local nAt     := AScan( ::aItems, { | oRadio | oRadio:lIsChecked() } )

   if nAt != nOption .and. nAt <= Len( ::aItems )
      ::aItems[ nAt ]:SetCheck( .f. )
      ::aItems[ nOption ]:SetCheck( .t. )
   endif

return nil

//---------------------------------------------------------------------------//
