#include "FiveWin.ch"

#define BM_GETCHECK         (WM_USER+0)
#define BM_SETCHECK         (WM_USER+1)
#define LTGRAY_BRUSH                  1

#define GCW_HCURSOR               (-12)

//----------------------------------------------------------------------------//

CLASS TRadio FROM TControl

   DATA   lChecked             // to init correctly its state
   DATA   oRadMenu
   DATA   nPos

   METHOD New( nRow, nCol, cCaption, lGroup, lChecked, nPos, oWnd, oRadMenu,;
               nHelpId, nClrText, nClrPane ) CONSTRUCTOR

   METHOD Redefine( nID, lChecked, nPos, oDlg, oRadMenu, ;
                    nHelpID, nClrText, nClrPane ) CONSTRUCTOR

   METHOD Click()      INLINE  ::oRadMenu:nOption := ::nPos
   METHOD cToChar()    INLINE  Super:cToChar( "BUTTON" )

   METHOD Init( hDlg ) INLINE  Super:Init( hDlg ),;
                               ::SetCheck( ::lChecked )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD SetCheck( lOnOff ) INLINE  ::lChecked := lOnOff,;
                               ::SendMsg( BM_SETCHECK, If( lOnOff, 1, 0 ) )

   METHOD lIsChecked() INLINE  ::lChecked := ( ::SendMsg( BM_GETCHECK ) == 1 )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, cCaption, lGroup, lChecked, nPos, oWnd, oRadMenu,;
            nHelpId, nClrText, nClrPane ) CLASS TRadio

   DEFAULT lChecked := .f., lGroup := .f., nPos := 1, nHelpId := 100

   ::nTop      = nRow * 13
   ::nLeft     = ( nCol *  7 ) + 4
   ::nBottom   = ::nTop + 12
   ::nRight    = ::nLeft + ( Len( cCaption ) * 5 )
   ::cCaption  = cCaption
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, BS_AUTORADIOBUTTON,;
                      If( lGroup, WS_GROUP, 0 ) )
   ::nId       = ::GetNewId()
   ::nHelpId   = nHelpId
   ::lChecked  = lChecked
   ::nPos      = nPos
   ::oWnd      = oWnd
   ::oRadMenu  = oRadMenu
   ::lDrag     = .f.
   ::lCaptured = .f.

   ::SetColor( nClrText, nClrPane )

   if oWnd:lVisible
      ::Create( "BUTTON" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//---------------------------------------------------------------------------//

METHOD Redefine( nID, lChecked, nPos, oDlg, oRadMenu, nHelpID, nClrText,;
                 nClrPane ) CLASS TRadio

   DEFAULT lChecked := .f., nPos := 1, nHelpId := 100

   ::nId       = nID
   ::nHelpId   = nHelpId
   ::oWnd      = oDlg
   ::oRadMenu  = oRadMenu
   ::lChecked  = lChecked
   ::nPos      = nPos
   ::lDrag     = .f.
   ::lCaptured = .f.

   ::SetColor( nClrText, nClrPane )

   oDlg:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TRadio

   local nResult := Super:MouseMove( nRow, nCol, nKeyFlags )

return If( ::lDrag, nResult, nil )    // We want standard behavior !!!

//----------------------------------------------------------------------------//
