#include "FiveWin.ch"

#define COLOR_WINDOW         5
#define COLOR_WINDOWTEXT     8

#define MM_ISOTROPIC         7
#define MM_ANISOTROPIC       8

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TPrintPV FROM TControl

   DATA    nMinPage, nMaxPage
   DATA    nViewWidth, nViewHeight

   METHOD  ReDefine( bPaint, nMinPage, nMaxPage, nViewWidth, nViewHeight,;
                     nId, oWnd, nClrFore, nClrBack ) CONSTRUCTOR

   METHOD  HandleEvent( nMsg, nWParam, nLParam )

   METHOD  Paint()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD ReDefine( bPaint, nMinPage, nMaxPage, nViewWidth, nViewHeight,;
                 nId, oWnd, nClrFore, nClrBack ) CLASS TPrintPV

   DEFAULT nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack := GetSysColor( COLOR_WINDOW )

   ::nId         = nId
   ::oWnd        = oWnd
   ::nMinPage    = nMinPage
   ::nMaxPage    = nMaxPage
   ::nViewWidth  = nViewWidth
   ::nViewHeight = nViewHeight

   ::bPainted    = bPaint

   if ! lRegistered
      ::Register( nOr( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TPrintPV

   if nMsg == WM_PAINT        // We want to paint ourselves
      ::BeginPaint()          // all controls non-standard must do this
      ::Paint()
      ::EndPaint()
      return 0
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TPrintPV

   local oRect := ::GetRect()

   SetMapMode( ::hDC, MM_ISOTROPIC )

   SetWindowExt( ::hDC, ::nViewWidth, ::nViewHeight )
   SetViewportExt( ::hDC, oRect:nRight, oRect:nBottom )

   if ::bPainted != nil
      Eval( ::bPainted, Self )
   endif

return nil

//----------------------------------------------------------------------------//
