// Utilidad para comparar fechas y horas entre archivos
// Utility for comparing dates & times between files

// ERRORLEVEL 1  --> no coinciden // does not match
// ERRORLEVEL 0  -->    coinciden // does match
// (c) A.Linares & F.Pulpn, 1993-4

// Build: BCC -ml timedate.c

#include <stdio.h>
#include <dos.h>

void exit( unsigned char );

//----------------------------------------------------------------------------//

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long LONG;

typedef struct
{
   BYTE Buffer[ 21 ];
   BYTE Attribute[ 1 ];
   WORD wTime;
   WORD wDate;
   LONG lSize;
   BYTE Name[ 13 ];
} DTA;

//----------------------------------------------------------------------------//

void main( int Args, char * Arg[] )
{
   DTA * pDta;
   WORD wTime1, wTime2;
   WORD wDate1, wDate2;

   if( Args < 3 )
   {
      printf( "Time & Date files comparing utility v. 1.0\n" );
      printf( "FiveWin tools - (c) A.Linares & F.Pulpn, 1993-4\n" );
      return;
   }

   printf( "Comparing Time & Date of files: " );
   printf( Arg[ 1 ] ); printf( " / " ); printf( Arg[ 2 ] ); printf( "\n" );

   asm push ds;

   _CX = 0;
   _AH = 0x4E;
	 _DX = FP_OFF( Arg[ 1 ] );
	 _DS = FP_SEG( Arg[ 1 ] );
   asm int 0x21;

   asm pop ds;

   _AH = 0x2F;
   asm int 0x21;

	 pDta 	= MK_FP( _ES, _BX );
   wTime1 = pDta->wTime;
   wDate1 = pDta->wDate;

   asm push ds;

   _CX = 0;
   _AH = 0x4E;
	 _DX = FP_OFF( Arg[ 2 ] );
	 _DS = FP_SEG( Arg[ 2 ] );
   asm int 0x21;

   asm pop ds;

   _AH = 0x2F;
   asm int 0x21;

	 pDta 	= MK_FP( _ES, _BX );
	 wTime2 = pDta->wTime;
	 wDate2 = pDta->wDate;

   if( ( wTime1 < wTime2 ) && ( wDate1 <= wDate2 ) )
   {
      printf( "Need to update\n" );
      exit( 1 );
   }
   else
   {
      printf( "No need to update\n" );
      exit( 0 );
   }
}

//----------------------------------------------------------------------------//
