#include "FiveWin.ch"

#define COLOR_BTNFACE   15
#define COLOR_BTNSHADOW 16

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMsgBar FROM TWindow

   DATA   cMessage, cMsgDef

   METHOD New( oWnd, cPrompt ) CONSTRUCTOR
   METHOD Adjust()

   METHOD Paint() INLINE MsgPaint( ::hWnd, ::cMessage, ::cMsgDef, .t. ) // erase

   METHOD SetMsg( cText ) INLINE  MsgPaint( ::hWnd, ::cMessage := cText,;
                                  ::cMsgDef, .f. )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( oWnd, cPrompt ) CLASS TMsgBar

   local oRect := oWnd:GetCliRect()

   DEFAULT cPrompt := ""

   ::nClrPane = COLOR_BTNFACE + 1
   ::oWnd     = oWnd
   ::cMessage := ::cMsgDef  := cPrompt
   ::nStyle   = nOR( WS_VISIBLE, WS_CHILD, WS_OVERLAPPED, WS_BORDER )
   ::nLeft    = -1
   ::nTop     = oRect:nBottom - 25
   ::nBottom  = oRect:nBottom 
   ::nRight   = oRect:nRight  + 1
   ::oBrush   = TBrush():New( , nRGB( 192, 192, 192 ), )

   if ! lRegistered
      ::Register()
      lRegistered = .t.
   endif

   ::Create()

return nil

//----------------------------------------------------------------------------//

METHOD Adjust() CLASS TMsgBar

   local rctParent := ::oWnd:GetCliRect()

   ::SetCoors( TRect():New( rctParent:nBottom - 25, rctParent:nLeft - 1,;
                            rctParent:nBottom, rctParent:nRight ) )
return nil

//----------------------------------------------------------------------------//
