#include "FiveWin.ch"

#define ES_WANTRETURN    4096  // 0x1000

#define EM_GETSEL  (WM_USER+0)
#define EM_SETSEL  (WM_USER+1)

#define COLOR_WINDOW        5
#define COLOR_WINDOWTEXT    8

//----------------------------------------------------------------------------//

CLASS TMultiGet FROM TControl

   METHOD New( nRow, nCol, bSetGet, oWnd, nWidth, nHeight, oFont,;
               lHScroll, nClrFore, nClrBack, oCursor ) CONSTRUCTOR

   METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, nClrFore, nClrBack, oFont,;
                    oCursor ) CONSTRUCTOR

   METHOD cToChar() INLINE  Super:cToChar( "EDIT" )

   METHOD GotFocus() INLINE Super:GotFocus(),;
                            SetWindowText( ::hWnd, Eval( ::bSetGet ) )

   METHOD Init( hDlg )

   METHOD LostFocus() INLINE Super:LostFocus(),;
                             Eval( ::bSetGet, GetWindowText( ::hWnd ) )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD cText( cText ) SETGET

   METHOD Refresh() INLINE ;
                    SetWindowText( ::hWnd, cValToChar( Eval( ::bSetGet ) ) )

   METHOD Save() INLINE Eval( ::bSetGet, GetWindowText( ::hWnd ) )

   METHOD GetSel()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, bSetGet, oWnd, nWidth, nHeight, oFont, lHScroll,;
            nClrFore, nClrBack, oCursor ) CLASS TMultiGet

   DEFAULT lHScroll := .f.,;
           nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack := GetSysColor( COLOR_WINDOW )

   ::cCaption = cValToChar( Eval( bSetGet ) )
   ::nTop     = nRow * 13
   ::nLeft    = nCol * 8
   ::nBottom  = If( nHeight == nil, ::nTop + 11, ::nTop + nHeight )
   ::nRight   = If( nWidth == nil, ::nLeft + Len( ::cCaption ) * 3.5, ;
                    ::nLeft + nWidth )
   ::bSetGet  = bSetGet
   ::oWnd     = oWnd
   ::nStyle   = nOR( WS_CHILD, WS_VISIBLE, WS_BORDER, WS_TABSTOP, ES_LEFT,;
                     ES_WANTRETURN, ES_MULTILINE, WS_VSCROLL,;
                     If( lHScroll, WS_HSCROLL, 0 ) )
   ::nId       = ::GetNewId()
   ::cCaption  = RTrim( ::cCaption )
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::oCursor   = oCursor
   ::oFont     = oFont

   ::SetColor( nClrFore, nClrBack )

   if oWnd:lVisible
      ::Create( "EDIT" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, bSetGet, oWnd, nHelpId, nClrFore, nClrBack, oFont,;
                 oCursor ) CLASS TMultiGet

   DEFAULT nClrFore := GetSysColor( COLOR_WINDOWTEXT ),;
           nClrBack := GetSysColor( COLOR_WINDOW )

   ::nId       = nId
   ::bSetGet   = bSetGet
   ::oWnd      = oWnd
   ::nHelpId   = nHelpId
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::oFont     = oFont
   ::oCursor   = oCursor

   ::SetColor( nClrFore, nClrBack )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TMultiGet

   Super:Init( hDlg )
   SetWindowText( ::hWnd, cValToChar( Eval( ::bSetGet ) ) )

return nil

//----------------------------------------------------------------------------//

METHOD cText( cText ) CLASS TMultiGet

   if PCount() == 1
      SetWindowText( ::hWnd, cText )
   endif

return GetWindowText( ::hWnd )

//----------------------------------------------------------------------------//

METHOD GetSel() CLASS TMultiGet

   local n      := ::SendMsg( EM_GETSEL )
   local nStart := nLoWord( n )
   local nEnd   := nHiWord( n )

return If( nStart != nEnd, SubStr( ::cText, nStart + 1, nEnd - nStart + 1 ), "" )

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TMultiGet

   if ::lDrag
      return Super:MouseMove( nRow, nCol, nKeyFlags )
   else
      if ::oCursor != nil
         SetCursor( ::oCursor:hCursor )
      else
         CursorIBeam()
      endif
   endif

return nil      // We want standard MultiLine Get behavior !!!

//---------------------------------------------------------------------------//
