#include "FiveWin.ch"

#define IDI_HAND   32513

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TIcon FROM TControl

   DATA   cIcoFile, cResName
   DATA   hIcon

   METHOD New( nRow, nCol, cResName, cIcoFile, lBorder, bClick,;
                                                         oWnd ) CONSTRUCTOR
   METHOD ReDefine() VIRTUAL

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD Paint() INLINE DrawIcon( ::hDC, 0, 0, ::hIcon )

   METHOD Release() INLINE DeleteObject( ::hIcon ), Super:Release()

   METHOD SetName( cNewName )

   METHOD LButtonDown( nRow, nCol, nKeyFlags )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, cResName, cIcoFile, lBorder, bClick, oWnd ) CLASS TIcon

   DEFAULT nRow := 0, nCol := 0, cResName := "", cIcoFile := "", lBorder := .f.

   ::nTop      = nRow * 14
   ::nLeft     = nCol *  8
   ::nBottom   = ::nTop  + 32
   ::nRight    = ::nLeft + 32
   ::oWnd      = oWnd
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, If( lBorder, WS_BORDER, 0 ) )
   ::nId       = ::GetNewId()
   ::cIcoFile  = cIcoFile
   ::cResName  = cResName
   ::bLClicked = bClick
   ::lDrag     = .f.
   ::lCaptured = .f.

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW, CS_GLOBALCLASS ) )
      lRegistered = .t.
   endif

   if oWnd != nil
      if oWnd:lVisible
         ::Create()
      else
         oWnd:DefControl( Self )
      endif
   endif

   if ! Empty( cIcoFile )
      ::hIcon = ExtractIcon( cIcoFile )
   endif

   if ! Empty( cResName )
      ::hIcon = LoadIcon( GetResources(), cResName )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD SetName( cNewName ) CLASS TIcon

   if ! Empty( cNewName )
      ::cResName = cNewName
      if ::hIcon != 0
         DeleteObject( ::hIcon )
      endif
      ::hIcon = LoadIcon( GetResources(), cNewName )
      ::Paint()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nKeyFlags ) CLASS TIcon

   if ::lDrag
      return Super:LButtonDown( nRow, nCol, nKeyFlags )
   else
      if ::bLClicked != nil
         Eval( ::bLClicked, nRow, nCol, nKeyFlags )
      endif
      return 0
   endif

return nil

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TIcon

   if nMsg == WM_PAINT
      ::BeginPaint()
      ::Paint()
      ::EndPaint()
      return 0
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//
