#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TGroup FROM TControl

   METHOD New( nTop, nLeft, nBottom, nRight, cLabel, oWnd, nClrText,;
               nClrPane ) CONSTRUCTOR

   METHOD ReDefine( nId, cLabel, oWnd, nClrText, nClrPane ) CONSTRUCTOR

   METHOD cToChar() INLINE  Super:cToChar( "BUTTON" )

   METHOD Init( hDlg )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cLabel, oWnd, nClrText, nClrPane ) ;
                                                                  CLASS TGroup

   DEFAULT nClrText := oWnd:nClrText, nClrPane := oWnd:nClrPane

   ::nTop     = nTop    * 14
   ::nLeft    = nLeft   *  7
   ::nBottom  = nBottom * 14
   ::nRight   = nRight  *  7
   ::cCaption = cLabel
   ::oWnd     = oWnd
   ::nStyle   = nOR( WS_CHILD, WS_VISIBLE, BS_GROUPBOX )
   ::nId      = ::GetNewId()

   ::SetColor( nClrText, nClrPane )

   if oWnd:lVisible
      ::Create( "BUTTON" )
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, cLabel, oWnd, nClrText, nClrPane ) CLASS TGroup

   DEFAULT nId      := ::GetNewId(),;
           nClrText := oWnd:nClrText, nClrPane := oWnd:nClrPane

   ::nId      = nId
   ::cCaption = cLabel
   ::hWnd     = 0
   ::oWnd     = oWnd

   ::SetColor( nClrText, nClrPane )

   oWnd:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TGroup

   Super:Init( hDlg )

   if Empty( ::cCaption )
      ::cCaption = GetWindowText( ::hWnd )
   endif

return nil

//----------------------------------------------------------------------------//
