#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function DocNew()

   local cDocName
   local nStart := 1

   while File( cDocName := ( "DOC" + SubStr( Str( nStart + 100, 3 ), 2 ) ;
                             + ".doc" ) )
      nStart++
   end

   if ! File( cDocName )
      DbCreate( cDocName, { { "PAGE",     "N",  3, 0 },;
                            { "ITEM",     "N",  4, 0 },;
                            { "DESCRIPT", "C", 50, 0 },;
                            { "NOTES",    "M", 10, 0 } } )
   endif

   DocOpen( cDocName )

return nil

//----------------------------------------------------------------------------//

function DocOpen( cDocName )

   local oWndDoc, oBar, oBrw, oIco
   local oWnd := GetWndMain(), oWndAreas := GetWndAreas()
   local cAlias, nPage := 1

   field Page, Item, Descript, Notes

   DEFAULT cDocName := cGetFile( "FiveWin Documentation (*.doc) | *.doc",;
                                 "Select a Documentation to use" )

   if ! Empty( cDocName )

      USE ( cDocName ) NEW SHARED

      if RecCount() == 0
         APPEND BLANK
         Page     := 1
         Item     := 1
         Descript := "New item"
      endif

      INDEX ON StrZero( Page, 3 ) + StrZero( Item, 4 ) TO ( Alias() )
      SET INDEX TO ( Alias() )
      GO TOP

      cAlias = Alias()

      DEFINE ICON oIco RESOURCE "Doc"

      DEFINE WINDOW oWndDoc FROM 1, 1 TO 23, 33 ;
         TITLE "Documentation: " + cNoExt( cNoPath( cDocName ) ) ;
         ICON  oIco MDICHILD OF oWnd

      DEFINE BUTTONBAR oBar OF oWndDoc

      DEFINE BUTTON RESOURCE "New" OF oBar ;
         MESSAGE "Add a new page" ;
         ACTION nPage := nPageNew( oBrw, nPage )

      DEFINE BUTTON RESOURCE "NewItem" OF oBar ;
         MESSAGE "Add a new item" ;
         ACTION ItemNew( oBrw, nPage )

      DEFINE BUTTON RESOURCE "Edit" OF oBar ;
         MESSAGE "Edit this item page"

      DEFINE BUTTON RESOURCE "PrevPage" OF oBar ;
         MESSAGE "Go previous page" ACTION nPage := nPagePrev( oBrw, nPage )

      DEFINE BUTTON RESOURCE "NextPage" OF oBar ;
         MESSAGE "Go next page" ACTION nPage := nPageNext( oBrw, nPage )

      DEFINE BUTTON RESOURCE "NG" GROUP OF oBar ;
         MESSAGE "Create Norton Guide documentation"

      DEFINE BUTTON RESOURCE "HLP" OF oBar ;
         MESSAGE "Create Windows Help documentation"

      @ 0, 0 LISTBOX oBrw FIELDS Str( ( Alias() )->Page, 3 ),;
                                 xPadL( Str( ( Alias() )->Item, 4 ), 40 ),;
                                 ( Alias() )->Descript ;
                          FIELDSIZES 30, 51, 300 ;
                          HEADERS "Pag", OemToAnsi( "Item N" ), "Description" ;
         OF oWndDoc ;
         ON CHANGE If( oWndAreas != nil, oWndAreas:oControl:Refresh(),) ;
         SELECT StrZero( Page, 3 ) + StrZero(  1, 4 ) ;
         FOR StrZero( nPage, 3 ) + StrZero(    1, 4 ) ;
         TO  StrZero( nPage, 3 ) + StrZero( 9999, 4 ) ;
         SIZE 400, 400 ;
         COLOR "W+/G"
         // Indexed filter !!!

      oWndDoc:SetControl( oBrw )

      ACTIVATE WINDOW oWndDoc ;
         VALID oBrw:lCloseArea()

      if oWndAreas != nil
         oWndAreas:oControl:Refresh()  // We updates the info on the WorkAreas
      endif                            // Inspector

   endif

return nil

//----------------------------------------------------------------------------//

static function ItemNew( oBrw, nPage )

   local nItem

   oBrw:GoBottom()
   nItem = ( oBrw:cAlias )->Item

   ( oBrw:cAlias )->( DbAppend() )

   if ( oBrw:cAlias )->( RLock() )
      ( oBrw:cAlias )->Page = nPage
      ( oBrw:cAlias )->Item = nItem + 1
      ( oBrw:cAlias )->Descript = "New Item"
      UNLOCK
      oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                      StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                      StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
      oBrw:GoTop()
      oBrw:Refresh()
   else
      MsgAlert( "DataBase in use, please try again" )
   endif

return nil

//----------------------------------------------------------------------------//

static function nPageNew( oBrw, nPage )

   nPage++

   ( oBrw:cAlias )->( DbAppend() )

   if ( oBrw:cAlias )->( RLock() )
      ( oBrw:cAlias )->Page = nPage
      ( oBrw:cAlias )->Item = 1
      ( oBrw:cAlias )->Descript = "New Item"
      UNLOCK
      oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                      StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                      StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
      oBrw:GoTop()
      oBrw:Refresh()
   else
      MsgAlert( "DataBase in use, please try again" )
   endif

return nPage

//----------------------------------------------------------------------------//

static function nPagePrev( oBrw, nPage )

   if nPage > 1
      nPage--
      oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                      StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                      StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
      oBrw:GoTop()
      oBrw:Refresh()
   endif

return nPage

//----------------------------------------------------------------------------//

static function nPageNext( oBrw, nPage )

   local nRecNo := RecNo()

   GO BOTTOM
   if ! ( oBrw:cAlias )->Page >= nPage + 1
      GO nRecNo
      return nPage
   endif
   GO nRecNo

   nPage++
   oBrw:SetFilter( "StrZero( Page, 3 ) + StrZero( 1, 4 )",;
                   StrZero( nPage, 3 ) + StrZero( 1, 4 ),;
                   StrZero( nPage, 3 ) + StrZero( 9999, 4 ) )
   oBrw:GoTop()
   oBrw:Refresh()

return nPage

//----------------------------------------------------------------------------//
